/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.util.HashMap;
import java.util.Map;

public class RabbitMQInAdapter
extends AbstractInAdapter
implements IDataAdapter {
    private static final String RabbitIN_ADAPTER_NAME = "RabbitMQ\u63a5\u5165\u9002\u914d\u5668";
    private String host;
    private int port;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private String messageId;
    private String correlationId;
    private String head;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private QueueingConsumer queueingConsumer;

    @Override
    public String getAdapterTypeName() {
        return RabbitIN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        this.rabbitfactoryInit();
        this.validateParams();
        super.doStart();
        new Thread((Runnable)this, String.valueOf(this.getBundlerId()) + ":" + this.getPort()).start();
    }

    @Override
    public IRequest makeRequest() throws Exception {
        Map _head;
        String _correlationId;
        String _messageId;
        DataRequest request = new DataRequest();
        request.setInAdapter(this);
        HashMap<String, Object> context = new HashMap<String, Object>();
        request.setContext(context);
        QueueingConsumer.Delivery delivery = this.queueingConsumer.nextDelivery();
        byte[] msg = delivery.getBody();
        AMQP.BasicProperties prop = delivery.getProperties();
        if (!StringTools.isEmpty(this.messageId) && (_messageId = prop.getMessageId()) != null) {
            context.put(this.messageId, _messageId);
            this.logger.debug("{} @ \u6d88\u606f\u6807\u8bc6:{}", (Object)this.getAdapterTypeName(), (Object)_messageId);
        }
        if (!StringTools.isEmpty(this.correlationId) && (_correlationId = prop.getCorrelationId()) != null) {
            context.put(this.correlationId, _correlationId);
            this.logger.debug("{} @ \u5173\u8054\u6807\u8bc6:{}", (Object)this.getAdapterTypeName(), (Object)_correlationId);
        }
        if (!StringTools.isEmpty(this.head) && (_head = prop.getHeaders()) != null) {
            context.put(this.head, _head);
            this.logger.debug("{} @ \u6d88\u606f\u5934:{}", (Object)this.getAdapterTypeName(), (Object)_head);
        }
        request.setData(msg);
        return request;
    }

    @Override
    public void run() {
        String moduleLog = this.getSid().replaceAll("[.]", "/");
        LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
        boolean okLogger = true;
        while (this.isAlive()) {
            try {
                IRequest req = null;
                try {
                    if (this.connection == null) {
                        this.connection = this.connectionFactory.newConnection();
                        this.channel = this.connection.createChannel();
                        String queueName = this.getRecQName();
                        this.channel.queueDeclare(queueName, true, false, false, null);
                        this.queueingConsumer = new QueueingConsumer(this.channel);
                        this.channel.basicConsume(queueName, true, (Consumer)this.queueingConsumer);
                    }
                    req = this.makeRequest();
                    if (okLogger) {
                        this.logger.debug("{} @ \u6210\u529f\u8fde\u63a5\u4e0aMQ\u670d\u52a1\u5668", (Object)this.getAdapterTypeName());
                    }
                    okLogger = false;
                }
                catch (Exception e) {
                    okLogger = true;
                    this.logger.error("{} @ {}", (Object)this.getAdapterTypeName(), (Object)e.getMessage());
                    Thread.sleep(30000L);
                    continue;
                }
                if (req == null) continue;
                this.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                try {
                    this.doStop();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.logger.error("{} @ \u76d1\u542c\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        LogbackUtil.removeLogInfo();
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        request.needToClose();
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.queueingConsumer = null;
        this.channel = null;
        this.connection = null;
        super.doStop();
    }

    @Override
    public void send(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        String queueName = this.getSendQName();
        try {
            Object o;
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
            if (!StringTools.isEmpty(this.correlationId) && (o = req.getContext().get(this.correlationId)) != null) {
                builder.correlationId(StringTools.getString(o));
            }
            if (!StringTools.isEmpty(this.messageId) && (o = req.getContext().get(this.messageId)) != null) {
                builder.messageId(StringTools.getString(o));
            }
            if (!StringTools.isEmpty(this.head) && (o = req.getContext().get(this.messageId)) != null && o instanceof Map) {
                builder.headers((Map)o);
            }
            AMQP.BasicProperties replyProps = builder.build();
            this.channel.basicPublish("", queueName, replyProps, req.getData());
        }
        catch (Exception e) {
            this.logger.error("{} @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            request.setCloseFlag(true);
            this.doStop();
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private void validateParams() throws Exception {
        if (StringTools.isEmpty(this.getHost())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u76d1\u542c\u5730\u5740\u672a\u914d\u7f6e!");
        }
        if (this.getPort() == 0) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u76d1\u542c\u7aef\u53e3\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u63a5\u6536\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getSendQName())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u53d1\u9001\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
    }

    private void rabbitfactoryInit() throws Exception {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.getHost());
        this.connectionFactory.setPort(this.getPort());
        this.connectionFactory.setUsername(this.getUserId());
        this.connectionFactory.setPassword(this.getPassword());
        this.connectionFactory.setVirtualHost("/");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getHead() {
        return this.head;
    }

    public void setHead(String head) {
        this.head = head;
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        return null;
    }
}

