/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.impl.mq.MQTools;
import cn.com.yusys.yusp.bsp.communication.impl.pool.factory.MQToolsFactory;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.PwdTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.impl.GenericObjectPool;

public class MQInAdapter
extends AbstractInAdapter
implements IDataAdapter {
    private static final String IN_ADAPTER_NAME = "MQ\u63a5\u5165\u9002\u914d\u5668";
    private boolean doBound;
    private String host;
    private int port;
    private String queueManager;
    private String channel;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private int ccsid;
    private int charset;
    private int expiry;
    private boolean exchangeFlag;
    private String messageId;
    private String correlationId;
    private String applicationIdData;
    private boolean doSend;
    private String matchFlag;
    private String matchValue;
    private MQTools mqTools;
    protected GenericObjectPool<MQTools> _pool;
    private boolean keepRecvQueue = true;
    MQToolsFactory factory;

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        this.mqTools = this.isDoBound() ? new MQTools(this.getCcsid(), this.getUserId(), PwdTools.decryptStr(this.getUserId(), this.getPassword())) : new MQTools(this.getHost(), this.getPort(), this.getChannel(), this.getCcsid(), this.getUserId(), PwdTools.decryptStr(this.getUserId(), this.getPassword()));
        this.mqTools.setCharset(this.getCharset());
        this.mqTools.setExpiry(this.getExpiry());
        new Thread((Runnable)this, String.valueOf(this.getBundlerId()) + ":" + this.getPort()).start();
    }

    @Override
    public IRequest makeRequest() throws Exception {
        Map<String, Object> map = this.mqTools.receive(1, -1, this.getMatchFlag(), this.getMatchValue());
        DataRequest request = new DataRequest();
        request.setInAdapter(this);
        request.setDatasourceWrapper(this.mqTools);
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (!StringTools.isEmpty(this.getMessageId())) {
            OgnlTools.setValue(this.getMessageId(), map.remove("messageId"), context);
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            OgnlTools.setValue(this.getCorrelationId(), map.remove("correlationId"), context);
        }
        if (!StringTools.isEmpty(this.getApplicationIdData())) {
            OgnlTools.setValue(this.getApplicationIdData(), map.remove("applicationIdData"), context);
        }
        request.setContext(context);
        request.setData((byte[])map.remove("message"));
        return request;
    }

    @Override
    public void run() {
        String moduleLog = this.getSid().replaceAll("[.]", "/");
        LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
        boolean okLogger = true;
        while (this.isAlive()) {
            try {
                IRequest req = null;
                try {
                    this.mqTools.initRecQueue(this.getQueueManager(), this.getRecQName(), this.isKeepRecvQueue());
                    if (okLogger) {
                        this.logger.debug("{} @ \u6210\u529f\u8fde\u63a5\u4e0aMQ\u670d\u52a1\u5668", (Object)this.getAdapterTypeName());
                    }
                    req = this.makeRequest();
                    if (!this.isKeepRecvQueue()) {
                        this.mqTools.closeOnlyRecQueue();
                        this.logger.debug("{} @ {}", (Object)this.getAdapterTypeName(), (Object)"\u5173\u95ed\u63a5\u6536\u961f\u5217");
                    }
                    okLogger = false;
                }
                catch (Exception e) {
                    okLogger = true;
                    this.logger.error("{} @ {}", (Object)this.getAdapterTypeName(), (Object)e.getMessage());
                    try {
                        this.mqTools.close();
                    }
                    catch (Exception closeE) {
                        this.logger.error("{} @ \u5173\u95ed\u63a5\u6536\u961f\u5217\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)closeE);
                    }
                    Thread.sleep(30000L);
                    continue;
                }
                if (req == null) continue;
                this.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                okLogger = true;
                this.logger.error("{} @ \u76d1\u542c\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        LogbackUtil.removeLogInfo();
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        if (request.needToClose()) {
            this.mqTools.close();
        }
    }

    @Override
    public void doStop() throws Exception {
        try {
            this.mqTools.close();
        }
        catch (Exception e) {
            this.logger.error("{} @ \u5173\u95ed\u5e94\u7528\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
        }
    }

    @Override
    public void send(IRequest request) throws Exception {
        if (!this.isDoSend()) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + "\u914d\u7f6e\u4e2d\u4e3a\u4e0d\u5efa\u7acb\u53d1\u9001\u901a\u9053\uff0c\u4e0d\u80fd\u505a\u4fe1\u606f\u53d1\u9001\uff01");
        }
        DataRequest req = (DataRequest)request;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object objMessgeId = null;
        Object objCorrelationId = null;
        Object objApplicationIdData = null;
        if (!StringTools.isEmpty(this.getMessageId())) {
            objMessgeId = OgnlTools.getValue(this.getMessageId(), req.getContext());
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            objCorrelationId = OgnlTools.getValue(this.getCorrelationId(), req.getContext());
        }
        if (!StringTools.isEmpty(this.getApplicationIdData())) {
            objApplicationIdData = OgnlTools.getValue(this.getApplicationIdData(), req.getContext());
        }
        if (this.isExchangeFlag()) {
            map.put("messageId", objCorrelationId);
            map.put("correlationId", objMessgeId);
        } else {
            map.put("messageId", objMessgeId);
            map.put("correlationId", objCorrelationId);
        }
        map.put("applicationIdData", objApplicationIdData);
        try {
            this.mqTools.initSendQueue(this.getQueueManager(), this.getSendQName());
            this.mqTools.send(map, req.getData(), false);
        }
        catch (Exception e) {
            this.logger.error("{} @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            request.setCloseFlag(true);
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private void validateParams() throws Exception {
        if (!this.isDoBound()) {
            if (StringTools.isEmpty(this.getHost())) {
                throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e!");
            }
            if (StringTools.isEmpty(this.getChannel())) {
                throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u8fde\u63a5\u901a\u9053\u672a\u914d\u7f6e!");
            }
        }
        if (this.getPort() == 0) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u76d1\u542c\u7aef\u53e3\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getQueueManager())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u961f\u5217\u7ba1\u7406\u5668\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u63a5\u6536\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
        if (this.isDoSend() && StringTools.isEmpty(this.getSendQName())) {
            throw new Exception(String.valueOf(this.getAdapterTypeName()) + " @ \u5efa\u7acb\u53d1\u9001\u901a\u9053\u65f6\uff0c\u9700\u8981\u914d\u7f6e\u53d1\u9001\u961f\u5217\u540d\u79f0!");
        }
        if (this.getCcsid() == 0) {
            this.setCcsid(1381);
        }
    }

    public boolean isDoBound() {
        return this.doBound;
    }

    public void setDoBound(boolean doBound) {
        this.doBound = doBound;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public boolean isExchangeFlag() {
        return this.exchangeFlag;
    }

    public void setExchangeFlag(boolean exchangeFlag) {
        this.exchangeFlag = exchangeFlag;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getApplicationIdData() {
        return this.applicationIdData;
    }

    public void setApplicationIdData(String applicationIdData) {
        this.applicationIdData = applicationIdData;
    }

    public boolean isDoSend() {
        return this.doSend;
    }

    public void setDoSend(boolean doSend) {
        this.doSend = doSend;
    }

    public String getMatchFlag() {
        return this.matchFlag;
    }

    public void setMatchFlag(String matchFlag) {
        this.matchFlag = matchFlag;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(String matchValue) {
        this.matchValue = matchValue;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isKeepRecvQueue() {
        return this.keepRecvQueue;
    }

    public void setKeepRecvQueue(boolean keepRecvQueue) {
        this.keepRecvQueue = keepRecvQueue;
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        return null;
    }
}

