/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.dataformat.MsgConvertUtil;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.filter.BspFilterResult;
import cn.com.yusys.yusp.bsp.filter.ExecutionStatus;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.log.BspSpan;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CommunicatUtil {
    private static Logger logger = LoggerFactory.getLogger(CommunicatUtil.class);

    public static Map<String, Object> send(String serviceName, String tradeCode, Map<String, Object> context) throws Exception {
        Map<String, Object> retMap;
        if (StringTools.isEmpty(tradeCode)) {
            tradeCode = "default";
        }
        logger.info("Communication dial-out @ service name[{}], transaction code[{}]", new Object[]{serviceName, tradeCode});
        AbstractCommOut comm = (AbstractCommOut)ResourcePortal.getInstance().getOutCommMap().get(serviceName);
        if (comm == null) {
            throw new Exception("Service[" + serviceName + "]communication dial-out configuration does not exist");
        }
        AbstractRequest request = null;
        AbstractOutAdapter outAdapter = comm.getOutAdapter();
        MsgConfig msgConfig = outAdapter.getMsgConfig();
        BspFilterResult result = CommunicatUtil.executeBspFilter(msgConfig.getPreFilter(), context);
        if (result != null) {
            throw result.getException();
        }
        try {
            byte[] recvData;
            Session session = new Session();
            BspSpan span = new BspSpan();
            String sn = span.getStringSpanId();
            String bsn = MDC.get((String)"X-B3-TraceId");
            if (bsn == null) {
                bsn = span.getStringTraceId();
                MDC.put((String)"X-B3-TraceId", (String)bsn);
            }
            session.setSessionId(sn);
            session.setContext(context);
            session.setBsn(bsn);
            context.put("T_SESSION", session);
            String reqMfd = String.valueOf(msgConfig.getOutServicePath()) + tradeCode + "_out_req.mfd";
            byte[] sendData = MsgConvertUtil.packMsg(context, FileTools.isExist(reqMfd) ? reqMfd : null, msgConfig.getReqMsgType(), msgConfig.getMsgEncode());
            if (sendData == null || sendData.length == 0) {
                throw new ComponentException("Service[" + serviceName + "]sending content cannot be empty");
            }
            AbstractDataProcess dataProcess = msgConfig.getDataProcess();
            if (dataProcess != null) {
                sendData = dataProcess.processSendData(sendData, context);
            }
            if ((request = (AbstractRequest)outAdapter.borrowRequest(session)) == null) {
                throw new Exception("Service[" + serviceName + "]get communication receive exception");
            }
            if (request instanceof StreamRequest && ((StreamRequest)request).getSocketWrapper().getBos() == null) {
                throw new ComponentException("Service[" + serviceName + "]does not support data sending operation, output stream is empty");
            }
            try {
                Object readTimeout = context.get("timeout");
                if (request instanceof StreamRequest) {
                    StreamRequest sr = (StreamRequest)request;
                    int defaultReadTimeOut = sr.getSocketWrapper().getSocket().getSoTimeout();
                    sr.getSocketWrapper().getSocket().setSoTimeout(Objects.isNull(readTimeout) ? defaultReadTimeOut : Integer.parseInt(readTimeout.toString()));
                    recvData = comm.processExch(context, sendData, request);
                    sr.getSocketWrapper().getSocket().setSoTimeout(defaultReadTimeOut);
                } else {
                    recvData = comm.processExch(context, sendData, request);
                }
            }
            catch (Exception e) {
                request.setCloseFlag(true);
                throw e;
            }
            if (dataProcess != null) {
                recvData = dataProcess.processRecvData(recvData, context);
            }
            String respMsgType = msgConfig.getRespMsgType();
            Map<String, Object> autoMap = null;
            if (StringTools.isEmpty(respMsgType) || respMsgType.equals("NONE")) {
                throw new Exception("The dial-out response message is not configured");
            }
            String respMfd = String.valueOf(msgConfig.getOutServicePath()) + tradeCode + "_out_resp.mfd";
            autoMap = MsgConvertUtil.unpackMsg(recvData, context, FileTools.isExist(respMfd) ? respMfd : null, respMsgType, msgConfig.getMsgEncode());
            context.put("__T_AUTOPACK", autoMap);
            result = CommunicatUtil.executeBspFilter(msgConfig.getPostFilter(), context);
            if (result != null) {
                throw result.getException();
            }
        }
        catch (Throwable throwable) {
            if (outAdapter != null && request != null) {
                outAdapter.returnRequest(request);
            }
            throw throwable;
        }
        if (outAdapter != null && request != null) {
            outAdapter.returnRequest(request);
        }
        return (retMap = (Map<String, Object>)context.get("__T_AUTOPACK")) != null ? retMap : context;
    }

    private static BspFilterResult executeBspFilter(TreeSet<BspFilter> preFilter, Map<String, Object> context) {
        for (BspFilter bspFilter : preFilter) {
            try {
                BspFilterResult result = bspFilter.runFilter(context);
                if (result.getResult()) continue;
                return result;
            }
            catch (Exception e) {
                BspFilterResult result = new BspFilterResult(ExecutionStatus.FAILED);
                result.setException(e);
                return result;
            }
        }
        return null;
    }
}

