/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.workflow.BspController;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.TradeMapping;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import cn.com.yusys.yusp.bsp.workflow.worker.IServiceUrl;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AppStartAssist {
    private static Logger logger = LoggerFactory.getLogger(AppStartAssist.class);
    public static final String CONFIG_PATH = "config";
    public static final String CONFIG_FROM_CP = "cp";
    public static final String CONFIG_FROM_FILE = "file";
    private static String model = "cp";
    public static final String CONFIG_MODULE_PATH = "file:///config/*/*/*.mrd";
    public static final String CONFIG_MODULE_CPATH = "classpath:config/*/*/*.mrd";
    private static SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();
    private static Map<String, ServiceEntity> _serviceEntityMap = new ConcurrentHashMap<String, ServiceEntity>();

    public static void startModule() throws Exception {
        try {
            String[] array = BspAutoConfiguration.applicationContext.getBeanNamesForAnnotation(BspController.class);
            int i = 0;
            while (i < array.length) {
                Object obean = BspAutoConfiguration.applicationContext.getBean(array[i]);
                Method[] methods = obean.getClass().getDeclaredMethods();
                int j = 0;
                while (j < methods.length) {
                    TradeMapping tradeMapping = methods[j].getAnnotation(TradeMapping.class);
                    if (tradeMapping != null) {
                        String value = tradeMapping.value();
                        String code = tradeMapping.code();
                        if (code.isEmpty()) {
                            code = value;
                        }
                        Class<?> paraClazz = methods[j].getParameterTypes()[0];
                        Class<?> retType = methods[j].getReturnType();
                        ServiceEntity entity = new ServiceEntity();
                        entity.setCode(code);
                        entity.setValue(value);
                        entity.setParaType(paraClazz);
                        entity.setRetType(retType);
                        entity.setParameterType(methods[j].getGenericParameterTypes()[0]);
                        entity.setReturnType(methods[j].getGenericReturnType());
                        entity.setMethod(methods[j]);
                        entity.setBean(obean);
                        ServiceEntity existEntity = _serviceEntityMap.get(value);
                        if (existEntity != null) {
                            throw new Exception("[" + entity.getBean() + "]transaction definition is the same as[" + existEntity.getBean() + "]");
                        }
                        _serviceEntityMap.put(value, entity);
                    }
                    ++j;
                }
                ++i;
            }
            logger.info("Load communication configuration[{}]", (Object)(AppStartAssist.getModel().equalsIgnoreCase(CONFIG_FROM_FILE) ? CONFIG_MODULE_PATH : CONFIG_MODULE_CPATH));
            String threadName = Thread.currentThread().getName();
            if (AppStartAssist.getModel().equalsIgnoreCase(CONFIG_FROM_FILE)) {
                String[] reses = FileTools.recursiveListFileBySuffix(new File(CONFIG_PATH), ".mrd").toArray(new String[0]);
                Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
                String[] stringArray = reses;
                int n = reses.length;
                int tradeMapping = 0;
                while (tradeMapping < n) {
                    String res = stringArray[tradeMapping];
                    AppStartAssist.loadModule(res, outCommMap);
                    ++tradeMapping;
                }
            } else {
                PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
                Resource[] reses = pmrpr.getResources(CONFIG_MODULE_CPATH);
                Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
                Resource[] resourceArray = reses;
                int n = reses.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource res = resourceArray[n2];
                    AppStartAssist.loadModule(res.getURL().toString(), outCommMap);
                    ++n2;
                }
            }
            Thread.currentThread().setName(threadName);
            logger.info("Load communication configuration successfully\uff01");
        }
        catch (Exception e) {
            logger.error("Failed to load communication configuration :", (Throwable)e);
            throw e;
        }
    }

    public static void loadModule(String modulePath, Map<String, IComm> outCommMap) {
        block9: {
            BspAppContext xc = new BspAppContext(new String[]{modulePath}, false, BspAutoConfiguration.applicationContext);
            try {
                boolean ret;
                String serviceName;
                String shortName = serviceName = AppStartAssist.fetchService(modulePath);
                if (serviceName.startsWith("commOut.")) {
                    shortName = shortName.substring(8);
                } else if (serviceName.startsWith("commIn.")) {
                    shortName = shortName.substring(7);
                }
                Thread.currentThread().setName(serviceName);
                logger.info("Load service name[{}] configuration", (Object)serviceName);
                xc.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)BspAutoConfiguration.getCustomEditorConfigurer());
                xc.refresh();
                IComm comm = AppStartAssist.loadComm(xc, modulePath, shortName);
                if (comm == null) {
                    return;
                }
                AbstractOutAdapter outAdapter = AppStartAssist.loadOutAdapter(xc, shortName);
                if (outAdapter != null) {
                    ((AbstractCommOut)comm).setOutAdapter(outAdapter);
                    comm.setMsgConfig(outAdapter.getMsgConfig());
                    outCommMap.put(shortName, comm);
                }
                if (!(ret = AppStartAssist.loadCommInProcess(xc, shortName))) {
                    return;
                }
                ret = AppStartAssist.loadDataProcess(xc, shortName);
                if (!ret) {
                    return;
                }
                AppStartAssist.loadBspFilter(xc, shortName);
                _contextRegistry.addAppContext(serviceName, xc);
            }
            catch (Exception e) {
                logger.error("module start fail:" + modulePath, (Throwable)e);
                if (xc == null) break block9;
                xc.close();
            }
        }
    }

    private static IComm loadComm(BspAppContext xc, String res, String serviceName) {
        String[] commName = xc.getBeanNamesForType(IComm.class);
        if (commName.length == 0) {
            logger.error("Communication type is not configured");
            logger.warn("[{}] configuration ignored", (Object)res);
            xc.close();
            return null;
        }
        if (commName.length > 1) {
            logger.error("Multiple communication configurations");
            logger.warn("[{}] configuration ignored", (Object)res);
            xc.close();
            return null;
        }
        IComm comm = (IComm)xc.getBean(commName[0]);
        String[] inAdaptersName = xc.getBeanNamesForType(AbstractInAdapter.class);
        int i = 0;
        while (i < inAdaptersName.length) {
            AbstractInAdapter inAdapter = (AbstractInAdapter)xc.getBean(inAdaptersName[i]);
            inAdapter.setComm(comm);
            inAdapter.getMsgConfig().setServiceName(serviceName);
            ++i;
        }
        return comm;
    }

    private static AbstractOutAdapter loadOutAdapter(BspAppContext xc, String serviceName) {
        String[] outAdapterName = xc.getBeanNamesForType(AbstractOutAdapter.class);
        if (outAdapterName.length > 1) {
            logger.warn("{},configuration of multiple dial-out adapters is not supported, service does not start", (Object)serviceName);
            xc.close();
            return null;
        }
        if (outAdapterName.length == 1) {
            AbstractOutAdapter outAdapter = (AbstractOutAdapter)xc.getBean(outAdapterName[0]);
            outAdapter.getMsgConfig().setServiceName(serviceName);
            return outAdapter;
        }
        return null;
    }

    private static boolean loadCommInProcess(BspAppContext xc, String serviceName) throws Exception {
        String[] serviceUrls = xc.getBeanNamesForType(IServiceUrl.class);
        if (serviceUrls.length > 1) {
            logger.warn("{},repeatedly configure the access extension service to implement [IServiceUrl], and the service does not start", (Object)serviceName);
            xc.close();
            return false;
        }
        if (serviceUrls.length == 1) {
            MsgConfig msgConfig = AppStartAssist.findMsgConfig(xc, serviceName);
            IServiceUrl serviceUrl = (IServiceUrl)xc.getBean(serviceUrls[0]);
            msgConfig.setServiceUrl(serviceUrl);
        }
        return true;
    }

    private static boolean loadDataProcess(BspAppContext xc, String serviceName) throws Exception {
        String[] dataProcess = xc.getBeanNamesForType(AbstractDataProcess.class);
        if (dataProcess.length > 1) {
            logger.warn("{},repeatedly configure the access extension service to implement [IDataProcess], and the service does not start", (Object)serviceName);
            xc.close();
            return false;
        }
        if (dataProcess.length == 1) {
            MsgConfig msgConfig = AppStartAssist.findMsgConfig(xc, serviceName);
            AbstractDataProcess dataProcessIns = (AbstractDataProcess)xc.getBean(dataProcess[0]);
            msgConfig.setDataProcess(dataProcessIns);
            dataProcessIns.setMsgConfig(msgConfig);
        }
        return true;
    }

    private static boolean loadBspFilter(BspAppContext xc, String serviceName) throws Exception {
        String[] filters = xc.getBeanNamesForType(BspFilter.class);
        if (filters.length > 0) {
            MsgConfig msgConfig = AppStartAssist.findMsgConfig(xc, serviceName);
            int i = 0;
            while (i < filters.length) {
                BspFilter filter = (BspFilter)xc.getBean(filters[i]);
                if ("PRE".equals(filter.filterType())) {
                    msgConfig.getPreFilter().add(filter);
                } else if ("POST".equals(filter.filterType())) {
                    msgConfig.getPostFilter().add(filter);
                } else if ("BOTH".equals(filter.filterType())) {
                    filter.setFilterType("PRE");
                    msgConfig.getPreFilter().add(filter);
                    filter = filter.clone();
                    filter.setFilterType("POST");
                    msgConfig.getPostFilter().add(filter);
                } else {
                    logger.warn("Filter type [" + filter.filterType() + "] is not supported");
                }
                ++i;
            }
        }
        return true;
    }

    private static MsgConfig findMsgConfig(BspAppContext xc, String serviceName) throws Exception {
        String[] msgConfigs = xc.getBeanNamesForType(MsgConfig.class);
        if (msgConfigs.length != 1) {
            logger.warn("{},message configuration [MsgConfig] is incorrect, service does not start", (Object)serviceName);
            throw new Exception(String.valueOf(serviceName) + "Message configuration [MsgConfig] is incorrect, service does not start");
        }
        return (MsgConfig)xc.getBean(msgConfigs[0]);
    }

    private static String fetchService(String path) {
        int index = path.indexOf("config/comm");
        int startIndex = path.indexOf("/", index);
        int endIndex = path.indexOf("/module.mrd", startIndex);
        return path.substring(startIndex + 1, endIndex).replaceAll("/", ".");
    }

    public static List<String> getModules() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (AppStartAssist.getModel().equalsIgnoreCase(CONFIG_FROM_FILE)) {
            String[] reses;
            String[] stringArray = reses = FileTools.recursiveListFileBySuffix(new File(CONFIG_PATH), ".mrd").toArray(new String[0]);
            int n = reses.length;
            int n2 = 0;
            while (n2 < n) {
                String res = stringArray[n2];
                list.add(AppStartAssist.fetchService(res));
                ++n2;
            }
        } else {
            Resource[] reses;
            PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
            Resource[] resourceArray = reses = pmrpr.getResources(CONFIG_MODULE_CPATH);
            int n = reses.length;
            int n3 = 0;
            while (n3 < n) {
                Resource res = resourceArray[n3];
                list.add(AppStartAssist.fetchService(res.getURL().toString()));
                ++n3;
            }
        }
        return list;
    }

    public static void stopModule() throws Exception {
        Collection<BspAppContext> contextSet = _contextRegistry.getContextMap().values();
        for (BspAppContext bspAppContext : contextSet) {
            bspAppContext.close();
        }
    }

    public static Map<String, ServiceEntity> get_serviceEntityMap() {
        return _serviceEntityMap;
    }

    public static void set_serviceEntityMap(Map<String, ServiceEntity> _serviceEntityMap) {
        AppStartAssist._serviceEntityMap = _serviceEntityMap;
    }

    public static String getModel() {
        return model;
    }

    public static void setModel(String model) {
        AppStartAssist.model = model;
    }
}

