/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class FixByteCommIn
extends AbstractCommIn {
    protected String unitName = "Fixed length byte communication access";
    private String recvLen;

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataOutputStream dos = new DataOutputStream(streamRequest.getSocketWrapper().getBos());
        try {
            this.sendMessageData(dos, bsend);
            dos.flush();
        }
        catch (Exception e) {
            throw new Exception(this.getUnitName() + " @ Send data exception", e);
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataInputStream dis = new DataInputStream(streamRequest.getSocketWrapper().getBis());
        String recvStr = FixByteCommIn.getInExpressStringValue(this.recvLen, context);
        int headerLen = Integer.parseInt(StringTools.getString(recvStr));
        if ((long)headerLen > 0xA00000L) {
            throw new IOException("Request too large buffer: " + headerLen + " recv failed");
        }
        byte[] data = new byte[headerLen];
        this.recvMessageData(dis, data);
        return data;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public String getRecvLen() {
        return this.recvLen;
    }

    public void setRecvLen(String recvLen) {
        this.recvLen = recvLen;
    }
}

