/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.el.ognl;

import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ASTChain;
import ognl.ASTProperty;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlEnhanceUtils {
    private static Logger logger = LoggerFactory.getLogger(OgnlEnhanceUtils.class);
    private static Map<String, Boolean> exprResultMap = new ConcurrentHashMap<String, Boolean>();

    public static Object getValue(String expr, Node ac, Map<String, Object> contextRoot) throws Exception {
        Boolean isSimpleExpr = true;
        int childrenCount = ac.jjtGetNumChildren();
        Boolean bSimple = exprResultMap.get(expr);
        if (bSimple != null) {
            isSimpleExpr = bSimple;
        } else {
            if (!(ac instanceof ASTProperty) && !(ac instanceof ASTChain)) {
                isSimpleExpr = false;
            } else if (childrenCount > 0) {
                for (int i = 0; i < childrenCount; ++i) {
                    if (ac.jjtGetChild(i) instanceof ASTProperty) continue;
                    isSimpleExpr = false;
                    break;
                }
            } else if (!(ac instanceof ASTProperty)) {
                isSimpleExpr = false;
            }
            exprResultMap.put(expr, isSimpleExpr);
        }
        if (!isSimpleExpr.booleanValue()) {
            OgnlContext ognlContext = OgnlTools.getOgnlContext(contextRoot);
            return Ognl.getValue((Object)ac, (Map)ognlContext, contextRoot);
        }
        if (ac instanceof ASTProperty) {
            return contextRoot.get(expr);
        }
        Map context = contextRoot;
        int lastIndex = OgnlEnhanceUtils.getLastNonArrayIndex(ac);
        boolean lastIsArray = lastIndex != childrenCount - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            boolean isVar = i == lastIndex;
            Node n = ac.jjtGetChild(i);
            Node nn = isVar && !lastIsArray ? null : ac.jjtGetChild(i + 1);
            String cName = n.toString();
            ASTProperty np = (ASTProperty)nn;
            Object obj = context.get(cName);
            if (obj == null) {
                return null;
            }
            if (nn == null || !np.isIndexedAccess()) {
                if (isVar) {
                    return obj;
                }
                if (!(obj instanceof Map)) {
                    isSimpleExpr = false;
                    break;
                }
                context = (Map)obj;
                continue;
            }
            ASTProperty na = np;
            Object objArr = obj;
            int ai = 1;
            while (i <= childrenCount - 2) {
                Node nt;
                ++i;
                boolean isList = true;
                if (objArr instanceof List) {
                    isList = true;
                } else if (objArr instanceof byte[] || objArr instanceof short[] || objArr instanceof char[] || objArr instanceof int[] || objArr instanceof long[] || objArr instanceof float[] || objArr instanceof double[] || objArr instanceof Object[]) {
                    isList = false;
                } else {
                    throw new Exception("Variable [" + cName + "]  is not a legal array type (dimension " + ai + " is not an array) : " + obj.getClass().getName());
                }
                int index = 0;
                try {
                    String idxExpr = na.jjtGetChild(0).toString();
                    Object value = OgnlTools.getValue(idxExpr, contextRoot);
                    index = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new Exception("The specified array index  " + ai + " is not an integer value:" + na.jjtGetChild(0).toString());
                }
                if (isList) {
                    List list = (List)objArr;
                    if (list.size() <= index) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("The index of the i-th dimension of array [" + cName + "] is out of bounds, the maximum is: [" + (list.size() - 1) + "], the actual index:" + index);
                        }
                        return null;
                    }
                    objArr = list.get(index);
                } else {
                    int al = Array.getLength(objArr);
                    if (al <= index) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("The index of the i-th dimension of array [" + cName + "] is out of bounds, the maximum is: [" + (al - 1) + "], the actual index:" + index);
                        }
                        return null;
                    }
                    objArr = Array.get(objArr, index);
                }
                if (i > childrenCount - 2 || (nt = ac.jjtGetChild(i + 1)) == null || !((ASTProperty)nt).isIndexedAccess()) break;
                ++ai;
                na = (ASTProperty)nt;
            }
            if (isVar) {
                return objArr;
            }
            if (!(objArr instanceof Map)) {
                isSimpleExpr = false;
                break;
            }
            context = (Map)objArr;
        }
        if (isSimpleExpr.booleanValue()) {
            return null;
        }
        OgnlContext ognlContext = OgnlTools.getOgnlContext(contextRoot);
        return Ognl.getValue((Object)ac, (Map)ognlContext, contextRoot);
    }

    public static void setValue(String expr, Node ac, Object value, Map<String, Object> contextRoot) throws Exception {
        if (ac instanceof ASTChain) {
            OgnlEnhanceUtils.setValue(contextRoot, (ASTChain)ac, value);
        } else if (ac instanceof ASTProperty) {
            OgnlEnhanceUtils.setValue(contextRoot, expr, value);
        } else {
            throw new Exception("Unsupported ognl assignment type:" + ac.getClass().getName());
        }
    }

    private static void setValue(Map<String, Object> contextRoot, String expr, Object value) throws Exception {
        contextRoot.put(expr, value);
    }

    private static void setValue(Map<String, Object> contextRoot, ASTChain ac, Object value) throws Exception {
        Map<String, Object> context = contextRoot;
        int childrenCount = ac.jjtGetNumChildren();
        int lastIndex = OgnlEnhanceUtils.getLastNonArrayIndex((Node)ac);
        boolean lastIsArray = lastIndex != childrenCount - 1;
        block2: for (int i = 0; i <= lastIndex; ++i) {
            boolean isVar = i == lastIndex;
            Node n = ac.jjtGetChild(i);
            Node nn = isVar && !lastIsArray ? null : ac.jjtGetChild(i + 1);
            String cName = n.toString();
            if (!(n instanceof ASTProperty) || nn != null && !(nn instanceof ASTProperty)) break;
            ASTProperty np = (ASTProperty)nn;
            if (nn == null || !np.isIndexedAccess()) {
                if (isVar) {
                    context.put(cName, value);
                    continue;
                }
                HashMap obj = context.get(cName);
                if (obj == null || !(obj instanceof Map)) {
                    obj = new HashMap();
                    context.put(cName, obj);
                }
                context = obj;
                continue;
            }
            ASTProperty na = np;
            ArrayList objArr = context.get(cName);
            int ai = 1;
            while (i <= childrenCount - 2) {
                HashMap<String, Object> next;
                List<ArrayList<Object>> list;
                boolean nextIsArray = false;
                Node nt = null;
                if (++i <= childrenCount - 2) {
                    nt = ac.jjtGetChild(i + 1);
                    nextIsArray = nt != null && ((ASTProperty)nt).isIndexedAccess();
                }
                int index = 0;
                try {
                    String idxExpr = na.jjtGetChild(0).toString();
                    Object v = OgnlTools.getValue(idxExpr, (Map<String, Object>)contextRoot);
                    index = v instanceof Number ? ((Number)v).intValue() : Integer.parseInt(v.toString());
                }
                catch (NumberFormatException e) {
                    throw new Exception("The specified array index is not an integer value:" + np.jjtGetChild(0).toString());
                }
                if (objArr == null) {
                    if (index != 0) {
                        throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0, actual value is [" + index + "]");
                    }
                    if (nextIsArray) {
                        list = new ArrayList<Object>();
                        context.put(cName, list);
                        ArrayList list2 = new ArrayList();
                        list.add(index, list2);
                        objArr = list2;
                    } else if (isVar) {
                        list = new ArrayList();
                        list.add((ArrayList<Object>)value);
                        context.put(cName, list);
                    } else {
                        list = new ArrayList();
                        next = new HashMap<String, Object>();
                        list.add((ArrayList<Object>)((Object)next));
                        context.put(cName, list);
                        context = next;
                    }
                } else if (nextIsArray) {
                    List l = new ArrayList();
                    ArrayList list2 = null;
                    if (objArr instanceof List) {
                        list2 = objArr;
                        if (index > list2.size()) {
                            throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is " + list2.size() + ", actual value is [" + index + "]");
                        }
                        if (index <= list2.size() - 1) {
                            Object o = list2.get(index);
                            if (o instanceof List) {
                                l = (List)o;
                            } else {
                                l.add(list2.remove(index));
                                list2.add(index, l);
                            }
                        } else {
                            list2.add(index, l);
                        }
                    } else {
                        if (index > 1) {
                            throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0 or 1, actual value is [" + index + "]");
                        }
                        list2 = new ArrayList();
                        list2.add(objArr);
                        if (ai != 1) {
                            throw new Exception("The " + (ai - 1) + "-th dimension element of array [" + cName + "] is not an array, changing the type is not allowed");
                        }
                        context.put(cName, list2);
                        list2.add(index, l);
                    }
                    objArr = l;
                } else if (isVar) {
                    list = null;
                    if (objArr instanceof List) {
                        list = objArr;
                        if (index > list.size()) {
                            throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is " + list.size() + ", actual value is [" + index + "]");
                        }
                    } else {
                        if (index > 1) {
                            throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0 or 1, actual value is [" + index + "]");
                        }
                        list = new ArrayList();
                        list.add(objArr);
                        if (ai == 1) {
                            context.put(cName, list);
                        } else {
                            ((List)objArr).add(list);
                        }
                    }
                    list.add(index, (ArrayList<Object>)value);
                } else if (objArr instanceof Map) {
                    if (index > 1) {
                        throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0 or 1, actual value is [" + index + "]");
                    }
                    list = new ArrayList();
                    list.add((ArrayList<Object>)((Object)((Map)((Object)objArr))));
                    if (ai == 1) {
                        context.put(cName, list);
                    } else {
                        ((List)objArr).add(list);
                    }
                    if (index == 0) {
                        context = (Map)((Object)objArr);
                    } else if (index == 1) {
                        next = new HashMap();
                        list.add((ArrayList<Object>)((Object)next));
                        context = next;
                    }
                } else if (objArr instanceof List) {
                    list = objArr;
                    if (index > list.size()) {
                        throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is " + list.size() + ", actual value is [" + index + "]");
                    }
                    if (index == list.size()) {
                        next = new HashMap();
                        list.add((ArrayList<Object>)((Object)next));
                        context = next;
                    } else {
                        Object obj = list.get(index);
                        if (!(obj instanceof Map)) {
                            throw new Exception("The value of the " + ai + "-th dimension of array [" + cName + "] is not a legal variable group");
                        }
                        context = (Map)obj;
                    }
                } else {
                    throw new Exception("Conversion of variable [" + cName + " the " + ai + "-th dimension] of type [" + objArr.getClass().getName() + "] to array is not allowed");
                }
                if (i > childrenCount - 2 || !nextIsArray) continue block2;
                ++ai;
                na = (ASTProperty)nt;
            }
        }
    }

    private static int getLastNonArrayIndex(Node ac) {
        int childrenCount = ac.jjtGetNumChildren();
        int lastIndex = childrenCount - 1;
        Node node = null;
        for (int i = childrenCount - 1; i >= 0 && (node = ac.jjtGetChild(i)) instanceof ASTProperty && ((ASTProperty)node).isIndexedAccess(); --i) {
            lastIndex = i - 1;
        }
        return lastIndex;
    }
}

