/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.toolkit.common.Base64Tools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class DesTools {
    private static final String DES = "DES";
    private static final String DES3 = "DESede";

    public static byte[] des1Encode(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = DesTools.getSecretKey(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        return DesTools.encode(encryptData, secretKey, cipher);
    }

    public static byte[] des1Encode(byte[] encryptData, byte[] keyData, String mode, String padding, byte[] IV) throws Exception {
        Object[] object = DesTools.getSecretKey(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        return DesTools.encode(encryptData, secretKey, cipher, IV);
    }

    public static byte[] des3Encode(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        if (keyData.length != 16) {
            throw new Exception("Des tool class @ the length of Des3 key should be 16 :" + keyData.length);
        }
        byte[] forePart = new byte[8];
        byte[] nextPart = new byte[8];
        System.arraycopy(keyData, 0, forePart, 0, 8);
        System.arraycopy(keyData, 8, nextPart, 0, 8);
        int dataLength = encryptData.length;
        int length = dataLength % 8 == 0 ? dataLength : 8 * (dataLength / 8 + 1);
        byte[] tmpArray = new byte[length];
        System.arraycopy(encryptData, 0, tmpArray, 0, length);
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(nextPart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
        return tmpArray;
    }

    public static byte[] des3Encode2(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = DesTools.getSecretKey3DES(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        return DesTools.encode(encryptData, secretKey, cipher);
    }

    public static byte[] des3Encode2(byte[] encryptData, byte[] keyData, String mode, String padding, byte[] IV) throws Exception {
        Object[] object = DesTools.getSecretKey3DES(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        return DesTools.encode(encryptData, secretKey, cipher, IV);
    }

    public static byte[] cirEncode(byte[] encryptData, byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = DesTools.getSecretKey(keyData, mode, padding);
        SecretKey secretKey = (SecretKey)object[0];
        Cipher cipher = (Cipher)object[1];
        int dataLength = encryptData.length;
        int surplus = dataLength % 8;
        if (surplus == 0) {
            return DesTools.encodeXorCal(encryptData, secretKey, cipher);
        }
        byte[] dividedPart = new byte[dataLength - surplus];
        System.arraycopy(encryptData, 0, dividedPart, 0, dividedPart.length);
        dividedPart = DesTools.encodeXorCal(dividedPart, secretKey, cipher);
        byte[] padPart = new byte[8];
        System.arraycopy(dividedPart, dividedPart.length - (8 - surplus), padPart, 0, 8 - surplus);
        System.arraycopy(encryptData, dataLength - surplus, padPart, 8 - surplus, surplus);
        padPart = DesTools.encode(padPart, secretKey, cipher);
        byte[] retArray = new byte[dataLength];
        System.arraycopy(dividedPart, 0, retArray, 0, dataLength - 8);
        System.arraycopy(padPart, 0, retArray, dataLength - 8, 8);
        return retArray;
    }

    public static byte[] encodeXorCal(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        int len = data.length;
        byte[] retArray = new byte[len];
        retArray = data;
        for (int i = 0; i < len; i += 8) {
            byte[] tmpArray = new byte[8];
            if (i > 0) {
                for (int j = 0; j < 8; ++j) {
                    int n = i + j;
                    retArray[n] = (byte)(retArray[n] ^ retArray[i + j - 8]);
                    tmpArray[j] = retArray[i + j];
                }
            } else {
                System.arraycopy(retArray, 0, tmpArray, 0, 8);
            }
            tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
            System.arraycopy(tmpArray, 0, retArray, i, 8);
        }
        return retArray;
    }

    public static byte[] encode(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        byte[] retArray = null;
        try {
            cipher.init(1, secretKey);
            retArray = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("DES tool class @ fail to encrypt key", e);
        }
        return retArray;
    }

    public static byte[] encode(byte[] data, SecretKey secretKey, Cipher cipher, byte[] IV) throws Exception {
        byte[] retArray = null;
        try {
            IvParameterSpec zeroIv = new IvParameterSpec(IV);
            cipher.init(1, (Key)secretKey, zeroIv);
            retArray = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("DES tool class @ fail to encrypt key", e);
        }
        return retArray;
    }

    public static byte[] des1Decode(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        byte[] retArray = DesTools.decode(decodeData, secretKey, cipher);
        return retArray;
    }

    public static byte[] des1Decode(byte[] decodeData, byte[] keyData, String mode, String padding, byte[] IV) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        byte[] retArray = DesTools.decode(decodeData, secretKey, cipher, IV);
        return retArray;
    }

    public static byte[] cirDecode(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        int dataLength = decodeData.length;
        int surplus = dataLength % 8;
        if (surplus == 0) {
            return DesTools.decodeXorCal(decodeData, secretKey, cipher);
        }
        byte[] left = new byte[8];
        System.arraycopy(decodeData, dataLength - 8, left, 0, 8);
        left = DesTools.decode(left, secretKey, cipher);
        int length = dataLength - surplus;
        byte[] des = new byte[length];
        System.arraycopy(decodeData, 0, des, 0, length - 8 + surplus);
        System.arraycopy(left, 0, des, length - 8 + surplus, 8 - surplus);
        des = DesTools.decodeXorCal(des, secretKey, cipher);
        byte[] retArray = new byte[dataLength];
        System.arraycopy(des, 0, retArray, 0, length);
        System.arraycopy(left, 8 - surplus, retArray, length, surplus);
        return retArray;
    }

    public static byte[] des3Decode(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        if (keyData.length != 16) {
            throw new Exception("Des tool class @ the length of Des3 key should be 16 : " + keyData.length);
        }
        byte[] forePart = new byte[8];
        byte[] nextPart = new byte[8];
        System.arraycopy(keyData, 0, forePart, 0, 8);
        System.arraycopy(keyData, 8, nextPart, 0, 8);
        if (decodeData.length % 8 != 0) {
            throw new Exception("Des tool class @ DES3 data length should be a multiple of 8: " + decodeData.length);
        }
        byte[] tmpArray = new byte[decodeData.length];
        System.arraycopy(decodeData, 0, tmpArray, 0, decodeData.length);
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(nextPart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.encode(tmpArray, secretKey, cipher);
        ketAndCipher = DesTools.getSecretKey(forePart, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
        byte[] retArray = ByteTools.stripEnd(tmpArray, (byte)0);
        return retArray;
    }

    public static byte[] des3Decode2(byte[] decodeData, byte[] keyData, String mode, String padding) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey3DES(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        byte[] retArray = DesTools.decode(decodeData, secretKey, cipher);
        return retArray;
    }

    public static byte[] des3Decode2(byte[] decodeData, byte[] keyData, String mode, String padding, byte[] IV) throws Exception {
        SecretKey secretKey = null;
        Cipher cipher = null;
        Object[] ketAndCipher = new Object[2];
        ketAndCipher = DesTools.getSecretKey3DES(keyData, mode, padding);
        secretKey = (SecretKey)ketAndCipher[0];
        cipher = (Cipher)ketAndCipher[1];
        byte[] retArray = DesTools.decode(decodeData, secretKey, cipher, IV);
        return retArray;
    }

    public static byte[] decodeXorCal(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        int length = data.length;
        byte[] retArray = new byte[length];
        System.arraycopy(data, 0, retArray, 0, length);
        for (int i = length - 8; i >= 0; i -= 8) {
            byte[] tmpArray = new byte[8];
            System.arraycopy(retArray, i, tmpArray, 0, 8);
            tmpArray = DesTools.decode(tmpArray, secretKey, cipher);
            System.arraycopy(tmpArray, 0, retArray, i, 8);
            if (i <= 0) continue;
            for (int j = 0; j < 8; ++j) {
                int n = i + j;
                retArray[n] = (byte)(retArray[n] ^ retArray[i + j - 8]);
            }
        }
        return retArray;
    }

    public static byte[] decode(byte[] data, SecretKey secretKey, Cipher cipher) throws Exception {
        if (data.length % 8 != 0) {
            throw new Exception("DES tool class @ the data length of key decryption [" + data.length + "] should be a multiple of 8");
        }
        byte[] retArray = null;
        try {
            cipher.init(2, secretKey);
            retArray = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("DES tool class @ fail to decrypt key", e);
        }
        return retArray;
    }

    public static byte[] decode(byte[] data, SecretKey secretKey, Cipher cipher, byte[] IV) throws Exception {
        if (data.length % 8 != 0) {
            throw new Exception("DES tool class @ the data length of key decryption [" + data.length + "] should be a multiple of 8");
        }
        byte[] retArray = null;
        try {
            IvParameterSpec zeroIv = new IvParameterSpec(IV);
            cipher.init(2, (Key)secretKey, zeroIv);
            retArray = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("DES tool class @ fail to decrypt key", e);
        }
        return retArray;
    }

    public static Object[] getSecretKey(byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = new Object[2];
        try {
            DESKeySpec desKeySpec = new DESKeySpec(keyData);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DES/");
            stringBuilder.append(mode);
            stringBuilder.append("/");
            stringBuilder.append(padding);
            object[0] = keyFactory.generateSecret(desKeySpec);
            object[1] = Cipher.getInstance(stringBuilder.toString());
        }
        catch (Exception e) {
            throw new Exception("DES tool class @ fail to generate key", e);
        }
        return object;
    }

    public static Object[] getSecretKey3DES(byte[] keyData, String mode, String padding) throws Exception {
        Object[] object = new Object[2];
        try {
            DESedeKeySpec desKeySpec = new DESedeKeySpec(keyData);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES3);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DESede/");
            stringBuilder.append(mode);
            stringBuilder.append("/");
            stringBuilder.append(padding);
            object[0] = keyFactory.generateSecret(desKeySpec);
            object[1] = Cipher.getInstance(stringBuilder.toString());
        }
        catch (Exception e) {
            throw new Exception("DES tool class @ fail to generate key", e);
        }
        return object;
    }

    public static void main(String[] args) throws Exception {
        String srcData = "123456789";
        String key = "123456788765432188888888";
        String mode = "CFB";
        String padding = "PKCS5Padding";
        byte[] encryptData = srcData.getBytes("UTF-8");
        if (padding.equals("NoPadding")) {
            int length = (srcData.getBytes("UTF-8").length / 8 + 1) * 8;
            byte[] tmpArray = new byte[length];
            System.arraycopy(encryptData, 0, tmpArray, 0, encryptData.length);
            encryptData = tmpArray;
        }
        String iv = "11111112";
        byte[] IV = iv.getBytes();
        byte[] encode = DesTools.des1Encode(encryptData, key.getBytes(), mode, padding, IV);
        System.out.println("DES1 encryption " + mode + "\uff1a" + Base64Tools.base64Encode2String(encode));
        byte[] encode2 = DesTools.des1Decode(encode, key.getBytes(), mode, padding, IV);
        System.out.println("DES1 decryption " + mode + "\uff1a" + new String(encode2, "UTF-8"));
    }
}

