/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.core;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixSizeHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 3650822618656384108L;
    private final Logger logger = LoggerFactory.getLogger(FixSizeHashMap.class);
    private int maxSize = 0xA00000;
    private int currentSize = 0;

    @Override
    public V put(K key, V value) {
        try {
            if (value == null) {
                this.remove(key);
                return null;
            }
            this.currentSize += this.computeObjectSize(value);
            if (this.currentSize < this.maxSize) {
                V o = super.put(key, value);
                if (o != null) {
                    this.currentSize -= this.computeObjectSize(o);
                }
                return o;
            }
            this.logger.warn(key + ",It will exceed the maximum cache capacity of 10MB after putting in");
        }
        catch (Exception e) {
            this.logger.error("Only serializable objects can be added to the cache:" + value, (Throwable)e);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        try {
            if (value != null) {
                this.currentSize -= this.computeObjectSize(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private int computeObjectSize(Object o) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        int size = baos.toByteArray().length;
        baos.close();
        return size;
    }
}

