/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class KVXmlExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "KVXML";
    private static final String DATA_FORMAT_VALUE_TYPE = "valueType";
    private static final String ITEM_ATTRIBUTE_VARNAME = "varName";
    private Map<String, Object> unpackMap;
    private LinkedHashMap<String, byte[]> packMap;
    private boolean isString;
    private byte[] startFlag = "<".getBytes();
    private byte[] endFlag = ">".getBytes();
    private byte[] endSign = "</>".getBytes();

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.packMap = new LinkedHashMap();
        } else {
            this.unpackMap = new HashMap<String, Object>();
            String attr = property.get(DATA_FORMAT_VALUE_TYPE);
            if ("string".equals(attr) && this.isAutoUnpack()) {
                this.isString = true;
            }
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        this.parserData(this.unpackMap, inputData, 1);
    }

    @Override
    public byte[] outputInner() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (String key : this.packMap.keySet()) {
            out.write(this.startFlag);
            out.write(key.getBytes(this.getEncoding()));
            out.write(this.endFlag);
            out.write(this.packMap.get(key));
            out.write(this.endSign);
        }
        byte[] data = out.toByteArray();
        out.close();
        return data;
    }

    @Override
    public byte[] autoPack(Map<String, Object> map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = null;
        Object obj = null;
        for (String key : map.keySet()) {
            obj = map.get(key);
            if (this.isSimpleType(obj)) {
                data = ByteTools.getBytes(obj, this.getEncoding());
                if (this.isFilterEmpty() && data.length == 0) {
                    this.logger.debug("{} @ Auto packing: {}, filtering empty string", new Object[]{this.getExecutorName(), key});
                    continue;
                }
                data = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), data, 1);
                out.write(this.startFlag);
                out.write(ByteTools.getBytes(key, this.getEncoding()));
                out.write(this.endFlag);
                out.write(data);
                out.write(this.endSign);
                this.logger.debug("{} @ Auto packing: {}=[{}]", new Object[]{this.getExecutorName(), key, StringTools.getString(obj, this.getEncoding())});
                continue;
            }
            if (obj != null) {
                this.logger.debug("{} @ Auto packing: {}, type [{}] is not supported", new Object[]{this.getExecutorName(), key, obj.getClass().getName()});
                continue;
            }
            this.logger.debug("{} @ Auto packing: {}, ignore(value is null)", new Object[]{this.getExecutorName(), key});
        }
        data = out.toByteArray();
        out.close();
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String node = paras.get(ITEM_ATTRIBUTE_VARNAME);
        if (StringTools.isEmpty(node)) {
            node = item.getName();
        }
        this.packMap.put(node, data);
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        return this.unpackMap;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String node = paras.get(ITEM_ATTRIBUTE_VARNAME);
        if (StringTools.isEmpty(node)) {
            node = item.getName();
        }
        return ByteTools.getBytes(this.unpackMap.get(node), this.getEncoding());
    }

    private void parserData(Map<String, Object> map, byte[] data, int index) throws Exception {
        if (index >= data.length) {
            return;
        }
        int pos = ExecutorHelper.searchSeparatorPosition(index, data, this.endFlag, this.getEncoding());
        int len = pos - index;
        byte[] key = new byte[len];
        System.arraycopy(data, index, key, 0, len);
        pos = ExecutorHelper.searchSeparatorPosition(index += len + 1, data, this.startFlag, this.getEncoding());
        len = pos - index;
        byte[] value = new byte[len];
        System.arraycopy(data, index, value, 0, len);
        index += len + 4;
        value = (byte[])this.invokeMethods(this.getGlobalParseMethod(), value, 1);
        if (this.isString) {
            map.put(new String(key, this.getEncoding()), new String(value, this.getEncoding()));
        } else {
            map.put(new String(key, this.getEncoding()), value);
        }
        this.parserData(map, data, index);
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

