/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.dataformat.MsgType;
import cn.com.yusys.yusp.bsp.dataformat.Utils;
import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.BCCPExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.JsonExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.KVSeparatorExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.KVXmlExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.SimpleXmlExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.SoapExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Property;
import cn.com.yusys.yusp.bsp.schema.dataformat.lib.Dataformat;
import cn.com.yusys.yusp.bsp.schema.dataformat.lib.DataformatDefinition;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataFormatRegistry {
    public static final String SIMPLE_DATAGRAM_JSON = "JSON";
    public static final String SIMPLE_DATAGRAM_XML = "XML";
    public static final String SIMPLE_DATAGRAM_SOAP = "SOAP";
    public static final String SIMPLE_DATAGRAM_KVSEPARATOR = "KVSeparator";
    public static final String SIMPLE_DATAGRAM_KVXML = "KVXml";
    public static final String SIMPLE_DATAGRAM_BCCP = "BCCP";
    private static final String EP_DF_PACKAGE = "cn.com.yusys.yusp.bsp.dataformat.impl.";
    private static Map<String, Map<String, Class<?>>> _registry = new HashMap();
    public static Map<String, Class<?>> _simpleDataformatRegistry = new HashMap();
    public static List<String> _plainDataformat = new ArrayList<String>();
    public static Map<String, Map<String, DataFormat>> cacheDataformat;

    public static void addPlatDataFormat(Class<?> clazz) {
        DataFormatRegistry.addDataFormat("plat", clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataFormat getDataformat(String msgtype, String encode) throws Exception {
        DataFormat dataformat;
        Map<String, DataFormat> dataformatMap = cacheDataformat.get(msgtype);
        if (dataformatMap == null) {
            String string = msgtype.intern();
            synchronized (string) {
                dataformatMap = cacheDataformat.get(msgtype);
                if (dataformatMap == null) {
                    dataformatMap = new ConcurrentHashMap<String, DataFormat>();
                    cacheDataformat.put(msgtype, dataformatMap);
                }
            }
        }
        if ((dataformat = dataformatMap.get(encode)) == null) {
            Map<String, DataFormat> map = dataformatMap;
            synchronized (map) {
                dataformat = dataformatMap.get(encode);
                if (dataformat == null) {
                    if (SIMPLE_DATAGRAM_JSON.equals(msgtype)) {
                        dataformat = DataFormatRegistry.createJsonDataformat(encode);
                    } else if (SIMPLE_DATAGRAM_XML.equals(msgtype)) {
                        dataformat = DataFormatRegistry.createSimpleXMLDataformat(encode);
                    } else if (SIMPLE_DATAGRAM_SOAP.equals(msgtype)) {
                        dataformat = DataFormatRegistry.createSoapDataformat(encode);
                    } else if (SIMPLE_DATAGRAM_KVSEPARATOR.equals(msgtype)) {
                        dataformat = DataFormatRegistry.createKVSeparatorDataformat(encode);
                    } else if (SIMPLE_DATAGRAM_KVXML.equals(msgtype)) {
                        dataformat = DataFormatRegistry.createKVXmlDataformat(encode);
                    } else if (SIMPLE_DATAGRAM_BCCP.equals(msgtype)) {
                        dataformat = DataFormatRegistry.createBCCPDataformat(encode);
                    } else {
                        throw new Exception("Message type [" + msgtype + "] does not support automatic processing");
                    }
                    dataformatMap.put(encode, dataformat);
                }
            }
        }
        return dataformat;
    }

    public static DataFormat createJsonDataformat(String encode) {
        DataFormat dataFormat = DataFormatRegistry.creataBaseDataformat(encode);
        dataFormat.setImplClass("JsonExecutor");
        return dataFormat;
    }

    public static DataFormat createSimpleXMLDataformat(String encode) {
        DataFormat dataFormat = DataFormatRegistry.creataBaseDataformat(encode);
        dataFormat.setImplClass("SimpleXmlExecutor");
        return dataFormat;
    }

    public static DataFormat createSoapDataformat(String encode) {
        DataFormat dataFormat = DataFormatRegistry.creataBaseDataformat(encode);
        Property property = new Property();
        property.setName("soapOperation");
        property.setValue(MsgType.SOAP_OPERATION.getKey());
        dataFormat.getHead().addProperty(property);
        property = new Property();
        property.setName("soapActionNamespace");
        property.setValue(MsgType.SOAP_ACTION_NAMESPACE.getKey());
        dataFormat.getHead().addProperty(property);
        property = new Property();
        property.setName("soapActionNamespaceValue");
        property.setValue(MsgType.SOAP_ACTION_NAMESPACE_VALUE.getKey());
        dataFormat.getHead().addProperty(property);
        property = new Property();
        property.setName("soapEntity");
        property.setValue(MsgType.SOAP_ENTITY.getKey());
        dataFormat.getHead().addProperty(property);
        dataFormat.setImplClass("SoapExecutor");
        return dataFormat;
    }

    public static DataFormat createKVSeparatorDataformat(String encode) {
        DataFormat dataFormat = DataFormatRegistry.creataBaseDataformat(encode);
        Property property = new Property();
        property.setName("firstSign");
        property.setValue(MsgType.KVSEPARATOR_FIRSTSIGN.getKey());
        dataFormat.getHead().addProperty(property);
        property = new Property();
        property.setName("secondSign");
        property.setValue(MsgType.KVSEPARATOR_SECONDSIGN.getKey());
        dataFormat.getHead().addProperty(property);
        property = new Property();
        property.setName("isHave");
        property.setValue("none");
        dataFormat.getHead().addProperty(property);
        property = new Property();
        property.setName("valueType");
        property.setValue("string");
        dataFormat.getHead().addProperty(property);
        dataFormat.setImplClass("KVSeparatorExecutor");
        return dataFormat;
    }

    public static DataFormat createKVXmlDataformat(String encode) {
        DataFormat dataFormat = DataFormatRegistry.creataBaseDataformat(encode);
        Property property = new Property();
        property.setName("valueType");
        property.setValue("string");
        dataFormat.getHead().addProperty(property);
        dataFormat.setImplClass("KVXmlExecutor");
        return dataFormat;
    }

    public static DataFormat createBCCPDataformat(String encode) {
        DataFormat dataFormat = DataFormatRegistry.creataBaseDataformat(encode);
        Property property = new Property();
        property.setName("valueType");
        property.setValue("byte");
        dataFormat.getHead().addProperty(property);
        dataFormat.setImplClass("BCCPExecutor");
        return dataFormat;
    }

    private static DataFormat creataBaseDataformat(String encode) {
        DataFormat dataFormat = new DataFormat();
        dataFormat.setEncoding(encode);
        Head head = new Head();
        Property property = new Property();
        property.setName("isAuto");
        property.setValue("true");
        head.addProperty(property);
        property = new Property();
        property.setName("autoPack");
        property.setValue("true");
        head.addProperty(property);
        dataFormat.setHead(head);
        return dataFormat;
    }

    public static void addBankDataFormat(Class<?> clazz) {
        DataFormatRegistry.addDataFormat("bank", clazz);
    }

    public static void addAppDataFormat(String appPath, Class<?> clazz) {
        DataFormatRegistry.addDataFormat(appPath, clazz);
    }

    public static void addDataFormat(String type, Class<?> clazz) {
        Map<String, Class<?>> entryMap = _registry.get(type);
        if (entryMap == null) {
            entryMap = new HashMap();
            _registry.put(type, entryMap);
        }
        String simpleName = clazz.getName().substring(EP_DF_PACKAGE.length());
        entryMap.put(simpleName, clazz);
    }

    public static void registryDataFormat(File dataformatDefinition, Class<?> clazz, String appPath) throws Exception {
        DataformatDefinition dd = Utils.loadDefinitionFile(dataformatDefinition);
        List<Dataformat> ds = Utils.getAllComponent(dd);
        for (Dataformat d : ds) {
            String clazzName;
            int index;
            Class<?> clazzTM = Utils.loadDataformatClass(clazz.getClassLoader(), d.getClazz());
            if (DataFormatRegistry.isExist(d, appPath) || (index = (clazzName = clazzTM.getName()).indexOf(EP_DF_PACKAGE)) == -1) continue;
            if (StringTools.isEmpty(d.getDomain()) || "plat".equals(d.getDomain())) {
                DataFormatRegistry.addPlatDataFormat(clazzTM);
                continue;
            }
            if ("bank".equals(d.getDomain())) {
                DataFormatRegistry.addBankDataFormat(clazzTM);
                continue;
            }
            throw new Exception("Illegal message domain name: [" + d.getDomain() + ":" + clazzName + "]");
        }
    }

    public static void registryDataFormat(InputStream dataformatStream, Class<?> clazz, String appPath) throws Exception {
        DataformatDefinition dd = Utils.loadDefinitionFile(dataformatStream);
        List<Dataformat> ds = Utils.getAllComponent(dd);
        for (Dataformat d : ds) {
            String clazzName;
            int index;
            Class<?> clazzTM = Utils.loadDataformatClass(clazz.getClassLoader(), d.getClazz());
            if (DataFormatRegistry.isExist(d, appPath) || (index = (clazzName = clazzTM.getName()).indexOf(EP_DF_PACKAGE)) == -1) continue;
            if (StringTools.isEmpty(d.getDomain()) || "plat".equals(d.getDomain())) {
                DataFormatRegistry.addPlatDataFormat(clazzTM);
                continue;
            }
            if ("bank".equals(d.getDomain())) {
                DataFormatRegistry.addBankDataFormat(clazzTM);
                continue;
            }
            throw new Exception("Illegal message domain name: [" + d.getDomain() + ":" + clazzName + "]");
        }
    }

    public static void unRegistryDataFormat(String domain, String name) {
        Map<String, Class<?>> entryMap = _registry.get(domain);
        if (entryMap != null) {
            entryMap.remove(name);
        }
    }

    public static Class<?> getPlatDataFormat(String shortClassName) {
        Map<String, Class<?>> entry = _registry.get("plat");
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    public static Class<?> getBankDataFormat(String shortClassName) {
        Map<String, Class<?>> entry = _registry.get("bank");
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    public static Class<?> getAppDataFormat(String appPath, String shortClassName) {
        Map<String, Class<?>> entry = _registry.get(appPath);
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    public static Class<?> getProjDataFormat(String type, String shortClassName) {
        Map<String, Class<?>> entry = _registry.get(type);
        if (entry == null) {
            return null;
        }
        return entry.get(shortClassName);
    }

    @Deprecated
    public static AbstractExecutor getDataFormatExecutor(String appPath, String name) throws Exception {
        Class<?> clazz = null;
        String type = null;
        int index = name.indexOf(":");
        if (index != -1) {
            type = name.substring(0, index);
            name = name.substring(index + 1);
        }
        if (StringTools.isEmpty(type) || "plat".equals(type)) {
            clazz = DataFormatRegistry.getPlatDataFormat(name);
        } else if ("bank".equals(type)) {
            clazz = DataFormatRegistry.getBankDataFormat(name);
        } else if ("proj".equals(type)) {
            appPath = appPath.substring(0, appPath.indexOf("."));
            appPath = appPath + "/plugins";
            clazz = DataFormatRegistry.getProjDataFormat(appPath, name);
        } else if ("app".equals(type)) {
            appPath = appPath.substring(0, appPath.lastIndexOf("/"));
            appPath = appPath + "/plugins";
            clazz = DataFormatRegistry.getAppDataFormat(appPath, name);
        }
        if (clazz == null) {
            throw new DataFormatException("Data format is not registered " + name);
        }
        return (AbstractExecutor)clazz.newInstance();
    }

    public static AbstractExecutor getDataFormatExecutor(String name) throws Exception {
        Class<?> clazz = null;
        String type = null;
        int index = name.indexOf(":");
        if (index != -1) {
            type = name.substring(0, index);
            name = name.substring(index + 1);
        }
        if (StringTools.isEmpty(type) || "plat".equals(type)) {
            clazz = DataFormatRegistry.getPlatDataFormat(name);
        } else if ("bank".equals(type)) {
            clazz = DataFormatRegistry.getBankDataFormat(name);
        }
        if (clazz == null) {
            throw new DataFormatException("Data format is not registered " + name);
        }
        return (AbstractExecutor)clazz.newInstance();
    }

    public static boolean isExist(Dataformat c, String appPath) {
        Map<String, Class<?>> entry = null;
        if (StringTools.isEmpty(c.getDomain()) || "plat".equals(c.getDomain())) {
            entry = _registry.get("plat");
        } else if ("bank".equals(c.getDomain())) {
            entry = _registry.get("bank");
        } else if (appPath != null) {
            entry = _registry.get(appPath);
        }
        if (entry != null) {
            return entry.containsKey(c.getClazz());
        }
        return false;
    }

    static {
        _simpleDataformatRegistry.put(SIMPLE_DATAGRAM_JSON, JsonExecutor.class);
        _simpleDataformatRegistry.put(SIMPLE_DATAGRAM_XML, SimpleXmlExecutor.class);
        _simpleDataformatRegistry.put(SIMPLE_DATAGRAM_SOAP, SoapExecutor.class);
        _simpleDataformatRegistry.put(SIMPLE_DATAGRAM_KVSEPARATOR, KVSeparatorExecutor.class);
        _simpleDataformatRegistry.put(SIMPLE_DATAGRAM_KVXML, KVXmlExecutor.class);
        _simpleDataformatRegistry.put(SIMPLE_DATAGRAM_BCCP, BCCPExecutor.class);
        _plainDataformat.add(SIMPLE_DATAGRAM_JSON);
        _plainDataformat.add(SIMPLE_DATAGRAM_XML);
        _plainDataformat.add(SIMPLE_DATAGRAM_SOAP);
        _plainDataformat.add(SIMPLE_DATAGRAM_KVSEPARATOR);
        _plainDataformat.add(SIMPLE_DATAGRAM_KVXML);
        cacheDataformat = new ConcurrentHashMap<String, Map<String, DataFormat>>();
    }
}

