/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication;

import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.dataformat.MsgConvertUtil;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.filter.BspFilterResult;
import cn.com.yusys.yusp.bsp.filter.ExecutionStatus;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.log.BspSpan;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicatUtil {
    private static Logger logger = LoggerFactory.getLogger(CommunicatUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> send(String serviceName, String tradeCode, Map<String, Object> context) throws Exception {
        Map<String, Object> retMap;
        if (StringTools.isEmpty(tradeCode)) {
            tradeCode = "default";
        }
        logger.info("Communication dial-out @ service name[{}], transaction code[{}]", new Object[]{serviceName, tradeCode});
        AbstractCommOut comm = (AbstractCommOut)ResourcePortal.getInstance().getOutCommMap().get(serviceName);
        if (comm == null) {
            throw new Exception("Service[" + serviceName + "]communication dial-out configuration does not exist");
        }
        StreamRequest request = null;
        AbstractOutAdapter outAdapter = comm.getOutAdapter();
        MsgConfig msgConfig = outAdapter.getMsgConfig();
        BspFilterResult result = CommunicatUtil.executeBspFilter(msgConfig.getPreFilter(), context);
        if (result != null) {
            throw result.getException();
        }
        try {
            byte[] recvData;
            Session session = new Session();
            BspSpan span = new BspSpan();
            String sn = span.getStringSpanId();
            String bsn = org.slf4j.MDC.get((String)"X-B3-TraceId");
            if (bsn == null) {
                bsn = span.getStringTraceId();
                MDC.put((String)"X-B3-TraceId", (Object)bsn);
            }
            session.setSessionId(sn);
            session.setContext(context);
            session.setBsn(bsn);
            context.put("T_SESSION", session);
            String reqMfd = msgConfig.getOutServicePath() + tradeCode + "_out_req.mfd";
            byte[] sendData = MsgConvertUtil.packMsg(context, FileTools.isExist(reqMfd) ? reqMfd : null, msgConfig.getReqMsgType(), msgConfig.getMsgEncode());
            if (sendData == null || sendData.length == 0) {
                throw new ComponentException("Service[" + serviceName + "]sending content cannot be empty");
            }
            AbstractDataProcess dataProcess = msgConfig.getDataProcess();
            if (dataProcess != null) {
                sendData = dataProcess.processSendData(sendData, context);
            }
            if ((request = (StreamRequest)outAdapter.borrowRequest(session)) == null) {
                throw new Exception("Service[" + serviceName + "]get communication receive exception");
            }
            if (request.getSocketWrapper().getBos() == null) {
                throw new ComponentException("Service[" + serviceName + "]does not support data sending operation, output stream is empty");
            }
            try {
                Object readTimeout = context.get("timeout");
                int defaultReadTimeOut = request.getSocketWrapper().getSocket().getSoTimeout();
                request.getSocketWrapper().getSocket().setSoTimeout(Objects.isNull(readTimeout) ? defaultReadTimeOut : Integer.parseInt(readTimeout.toString()));
                recvData = comm.processExch(context, sendData, request);
                request.getSocketWrapper().getSocket().setSoTimeout(defaultReadTimeOut);
            }
            catch (Exception e) {
                request.setCloseFlag(true);
                throw e;
            }
            if (dataProcess != null) {
                recvData = dataProcess.processRecvData(recvData, context);
            }
            String respMsgType = msgConfig.getRespMsgType();
            Map<String, Object> autoMap = null;
            if (StringTools.isEmpty(respMsgType) || respMsgType.equals("NONE")) {
                throw new Exception("The dial-out response message is not configured");
            }
            String respMfd = msgConfig.getOutServicePath() + tradeCode + "_out_resp.mfd";
            autoMap = MsgConvertUtil.unpackMsg(recvData, context, FileTools.isExist(respMfd) ? respMfd : null, respMsgType, msgConfig.getMsgEncode());
            context.put("__T_AUTOPACK", autoMap);
            result = CommunicatUtil.executeBspFilter(msgConfig.getPostFilter(), context);
            if (result != null) {
                throw result.getException();
            }
            if (outAdapter == null || request == null) return (retMap = (Map<String, Object>)context.get("__T_AUTOPACK")) != null ? retMap : context;
        }
        catch (Throwable throwable) {
            if (outAdapter == null || request == null) throw throwable;
            outAdapter.returnRequest(request);
            throw throwable;
        }
        outAdapter.returnRequest(request);
        retMap = (Map<String, Object>)context.get("__T_AUTOPACK");
        return retMap != null ? retMap : context;
    }

    private static BspFilterResult executeBspFilter(TreeSet<BspFilter> preFilter, Map<String, Object> context) {
        for (BspFilter bspFilter : preFilter) {
            try {
                BspFilterResult result = bspFilter.runFilter(context);
                if (result.getResult()) continue;
                return result;
            }
            catch (Exception e) {
                BspFilterResult result = new BspFilterResult(ExecutionStatus.FAILED);
                result.setException(e);
                return result;
            }
        }
        return null;
    }
}

