/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.component.impl.dataformat;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.component.impl.dataformat.AbstractDataFormat;
import java.nio.ByteBuffer;
import java.util.Map;

public class DataFormatPacker
extends AbstractDataFormat {
    @Override
    public void executeDataFormat(AbstractExecutor<Object> messageExecutor, DataFormat dataFormat, Map<String, Object> context) throws Exception {
        this.logger.info("Start packaging, packaging message [{}] ", context.get("messageName"));
        messageExecutor.pack(dataFormat);
        Object ret = messageExecutor.outputData();
        if (ret == null) {
            return;
        }
        if (ret instanceof Map) {
            context.put("packVarName", ret);
        } else if (ret instanceof byte[]) {
            context.put("packVarName", ret);
            byte[] retByte = (byte[])ret;
            if (this.logger.isDebugEnabled()) {
                if (messageExecutor.isHiddenInfo()) {
                    this.logger.debug("Packaging, message[{}]: contains sensitive information, ignored", new Object[]{String.valueOf(retByte.length)});
                } else {
                    this.logger.debug("Packaging, message[{}]:\n{}", new Object[]{String.valueOf(retByte.length), StringTools.toHexTable(retByte, messageExecutor.getEncoding())});
                }
            }
        } else if (ret instanceof ByteBuffer) {
            byte[] retByte = ((ByteBuffer)ret).array();
            context.put("packVarName", ret);
            if (this.logger.isDebugEnabled()) {
                if (messageExecutor.isHiddenInfo()) {
                    this.logger.debug("Packaging, message[{}]: contains sensitive information, ignored", new Object[]{String.valueOf(retByte.length)});
                } else {
                    this.logger.debug("Packaging, message[{}]:\n{}", new Object[]{String.valueOf(retByte.length), StringTools.toHexTable(retByte, messageExecutor.getEncoding())});
                }
            }
        } else {
            context.put("packVarName", ret);
            if (this.logger.isDebugEnabled()) {
                if (messageExecutor.isHiddenInfo()) {
                    this.logger.debug("Packaging, contains sensitive information, ignored");
                } else {
                    this.logger.debug("Packaging, message[{}]:\n{}", (Object)ret.toString());
                }
            }
        }
        this.logger.info("Packaging finished");
    }

    @Override
    public int getPackType() {
        return 0;
    }
}

