/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.proxy;

import cn.com.yusys.yusp.bsp.communication.CommunicatUtil;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.reflect.BeanMapUtil;
import cn.com.yusys.yusp.bsp.workflow.comm.out.annotation.MsgHead;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CommInvocationHandler
implements InvocationHandler {
    private static final String TRADE_CODE = "tradeCode";
    private static final String COMMOUT = "CommOut";
    private String serviceName;
    private static Map<Method, Map<String, String>> attrCache = new ConcurrentHashMap<Method, Map<String, String>>();

    public CommInvocationHandler(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args.length != 1) {
            throw new Exception("The number of interface parameters must be one");
        }
        BeanMapUtil util = new BeanMapUtil();
        Map<String, Object> inPara = util.beanToMap(args[0]);
        Map<String, String> attrs = this.getMethodAttribute(method);
        String tradeCode = attrs.get(TRADE_CODE);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("__COMMHEAD", attrs);
        context.put("__T_AUTOPACK", inPara);
        context.putAll(attrs);
        context.putAll(inPara);
        Map<String, Object> outPara = CommunicatUtil.send(this.serviceName, tradeCode, context);
        return util.mapToBean(outPara, method.getReturnType(), method.getGenericReturnType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMethodAttribute(Method method) throws Exception {
        Map<String, String> attrs = attrCache.get(method);
        if (attrs == null) {
            Map<Method, Map<String, String>> map = attrCache;
            synchronized (map) {
                attrs = attrCache.get(method);
                if (attrs == null) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    Annotation[] annotations = method.getAnnotations();
                    boolean isAnno = false;
                    for (int i = 0; i < annotations.length; ++i) {
                        String tmp = annotations[i].annotationType().getCanonicalName();
                        if (!tmp.endsWith(COMMOUT)) continue;
                        Method[] methods = annotations[i].annotationType().getDeclaredMethods();
                        for (int j = 0; j < methods.length; ++j) {
                            String methodV = (String)methods[j].invoke((Object)annotations[i], null);
                            if (StringTools.isEmpty(methodV)) continue;
                            tmpMap.put(methods[j].getName(), methodV);
                        }
                        isAnno = true;
                        break;
                    }
                    if (!isAnno) {
                        throw new Exception("Method must be annotated with communication type");
                    }
                    MsgHead msghead = method.getAnnotation(MsgHead.class);
                    if (msghead != null) {
                        String[] value = msghead.value();
                        for (int i = 0; i < value.length; ++i) {
                            int index = value[i].indexOf("=");
                            if (index == -1) {
                                throw new Exception("The format of MsgHead annotation on the method is incorrect. It must be in the format of key=value");
                            }
                            tmpMap.put(value[i].substring(0, index), value[i].substring(index + 1));
                        }
                    }
                    attrCache.put(method, tmpMap);
                    attrs = tmpMap;
                }
            }
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.putAll(attrs);
        return retMap;
    }
}

