/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.out.tcp.TcpOutAdapter;
import cn.com.yusys.yusp.bsp.dataformat.LogPhase;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;

public class HttpCommOut
extends AbstractCommOut
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String COMM_ATTRIBUTE_RECEIVE_HEAD = "recvHead";
    protected static final String COMM_ATTRIBUTE_SEND_HEAD = "sendHead";
    protected static final String HTTP_HEADER_SOAPACTION = "SoapAction";
    protected static final String DEFAULT_VALUE_CONTENT_TYPE = "text/xml; charset=UTF-8";
    protected HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
    HttpService httpService = null;
    protected volatile HttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
    protected static final String HTTP_REQUEST_METHOD_POST = "POST";
    protected static final String HTTP_REQUEST_METHOD_GET = "GET";
    protected String unitName = "HTTP communication dial-out";
    private String method;
    private String contentType;
    private String sendHead;
    private String uri;
    private String soapAction;
    private String userAgent;
    private String trace;

    @Override
    public byte[] processExch(Map<String, Object> context, byte[] sendData, AbstractRequest request) throws Exception {
        String _trace;
        String contentType;
        String method;
        String uri = this.getInExpressStringValue(this.uri, "uri", context);
        if (StringTools.isEmpty(uri)) {
            uri = "/";
        }
        if (StringTools.isEmpty(method = this.getInExpressStringValue(this.method, "method", context))) {
            method = HTTP_REQUEST_METHOD_POST;
        }
        if (StringTools.isEmpty(contentType = this.getInExpressStringValue(this.contentType, "contentType", context))) {
            contentType = DEFAULT_VALUE_CONTENT_TYPE;
        }
        String soapAction = this.getInExpressStringValue(this.soapAction, "soapAction", context);
        Map<Object, Object> headers = new HashMap();
        Object sendHead = this.getInExpressObjectValue(this.sendHead, COMM_ATTRIBUTE_SEND_HEAD, context);
        if (sendHead != null) {
            if (sendHead instanceof Map) {
                headers = (Map)sendHead;
            } else {
                this.logger.debug("{} @ Sending message header is not Map[{}]:{}", new Object[]{this.getUnitName(), COMM_ATTRIBUTE_SEND_HEAD, sendHead});
                headers = StringTools.string2Map(sendHead.toString());
            }
        }
        headers.remove("Content-Length");
        if (!StringTools.isEmpty(soapAction)) {
            headers.put(HTTP_HEADER_SOAPACTION, soapAction);
        }
        if ("true".equals(_trace = this.getInExpressStringValue(this.trace, "trace", context))) {
            Session session = (Session)context.get("T_SESSION");
            headers.put("X-B3-TraceId", session.getBsn());
            headers.put("X-B3-SpanId", session.getSessionId());
            headers.put("X-B3-Sampled", "1");
        }
        HttpParams params = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpClientProcessor();
        BasicHttpContext httpContext = new BasicHttpContext(null);
        DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
        DefaultConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
        httpContext.setAttribute("http.connection", (Object)conn);
        if (!conn.isOpen()) {
            Socket socket = null;
            if (request instanceof StreamRequest) {
                Object dw = request.getDatasourceWrapper();
                if (dw instanceof SocketWrapper) {
                    socket = ((SocketWrapper)dw).getSocket();
                } else if (dw instanceof Socket) {
                    socket = (Socket)dw;
                }
                if (params.getParameter("http.socket.timeout") == null) {
                    params.setIntParameter("http.socket.timeout", socket.getSoTimeout());
                }
                conn.bind(socket, params);
            }
            if (headers.get("Host") == null && request.getOutAdapter() instanceof TcpOutAdapter) {
                Object op;
                TcpOutAdapter tcpOutAdapter = (TcpOutAdapter)request.getOutAdapter();
                String _host = tcpOutAdapter.getHost();
                String _port = tcpOutAdapter.getPort();
                Object oh = context.get(_host);
                if (oh == null) {
                    oh = _host;
                }
                if ((op = context.get(_port)) == null) {
                    op = _port;
                }
                if ("80".equals(op) || "443".equals(op)) {
                    headers.put("Host", StringTools.getString(oh));
                } else {
                    headers.put("Host", StringTools.getString(oh) + ":" + StringTools.getString(op));
                }
            }
        }
        HttpHost host = new HttpHost(conn.getRemoteAddress().getHostAddress(), conn.getRemotePort());
        httpContext.setAttribute("http.connection", (Object)conn);
        httpContext.setAttribute("http.target_host", (Object)host);
        BasicHttpEntityEnclosingRequest httpRequest = null;
        StringEntity httpEntity = null;
        if (HTTP_REQUEST_METHOD_POST.equals(method)) {
            httpRequest = new BasicHttpEntityEnclosingRequest(HTTP_REQUEST_METHOD_POST, uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
            byte[] valueObj = sendData;
            if (valueObj instanceof String) {
                httpEntity = new StringEntity((String)valueObj, HttpProtocolParams.getContentCharset((HttpParams)params));
            } else if (valueObj instanceof byte[]) {
                httpEntity = new ByteArrayEntity(valueObj);
            }
            ((AbstractHttpEntity)httpEntity).setContentType(contentType);
            httpRequest.setEntity((HttpEntity)httpEntity);
        } else if (HTTP_REQUEST_METHOD_GET.equals(method)) {
            httpRequest = new BasicHttpRequest(HTTP_REQUEST_METHOD_GET, uri);
        }
        httpRequest.setHeaders(this.buildHeader(headers));
        httpRequest.setParams(params);
        this.httpexecutor.preProcess((HttpRequest)httpRequest, httpProc, (HttpContext)httpContext);
        this.logHeader((HttpRequest)httpRequest);
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.SEND)) {
                this.logger.info("{} @ Send data[{}]:\n{}", new Object[]{this.getUnitName(), sendData.length, StringTools.toHexTable(sendData)});
            } else {
                this.logger.info("{} @ Send data[{}]:\n{}", new Object[]{this.getUnitName(), sendData.length, StringTools.printStr(sendData, this.getMsgConfig().getMsgEncode())});
            }
        }
        HttpResponse httpResponse = this.httpexecutor.execute((HttpRequest)httpRequest, (HttpClientConnection)conn, (HttpContext)httpContext);
        httpResponse.setParams(params);
        this.httpexecutor.postProcess(httpResponse, httpProc, (HttpContext)httpContext);
        headers = this.parserHeader((HttpMessage)httpResponse);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new ComponentException("Return status error:" + httpResponse + "\n" + EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
        }
        context.put(COMM_ATTRIBUTE_RECEIVE_HEAD, headers);
        this.logHeader(httpResponse);
        HttpEntity responseEntity = httpResponse.getEntity();
        byte[] rspData = new byte[]{};
        if (responseEntity != null) {
            rspData = EntityUtils.toByteArray((HttpEntity)responseEntity);
            if (this.logger.isInfoEnabled()) {
                if (this.printHexLog(LogPhase.RECV)) {
                    this.logger.info("{} @ Return data [{}]:\n{}", new Object[]{this.getUnitName(), rspData.length, StringTools.toHexTable(rspData, this.getMsgConfig().getMsgEncode())});
                } else {
                    this.logger.info("{} @ Return data [{}]:\n{}", new Object[]{this.getUnitName(), rspData.length, StringTools.printStr(rspData, this.getMsgConfig().getMsgEncode())});
                }
            }
        }
        if (!connStrategy.keepAlive(httpResponse, (HttpContext)httpContext)) {
            request.setCloseFlag(true);
        }
        return rspData;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSendHead() {
        return this.sendHead;
    }

    public void setSendHead(String sendHead) {
        this.sendHead = sendHead;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    protected Map<String, String> parserHeader(HttpMessage httpMessage) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpMessage;
            map.put("method", req.getRequestLine().getMethod());
            map.put("uri", req.getRequestLine().getUri());
            map.put("protocol", req.getRequestLine().getProtocolVersion().getProtocol());
        }
        for (Header h : httpMessage.getAllHeaders()) {
            map.put(h.getName(), h.getValue());
        }
        return map;
    }

    private void logParams(Map<String, String> map, String headkey) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append(headkey + "." + key);
                sb.append("=");
                sb.append(value);
                sb.append("\n");
            }
            this.logger.debug(sb.toString());
        }
    }

    protected void logHeader(HttpRequest request) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ Reuqest HTTP header:\n{}", (Object)this.getUnitName(), (Object)request);
        }
    }

    protected void logHeader(HttpResponse response) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ Return HTTP header:\n{}", (Object)this.getUnitName(), (Object)response);
        }
    }

    protected Header[] buildHeader(Map<String, String> headers) {
        Header[] heads = new Header[headers.size()];
        int i = 0;
        for (String key : headers.keySet()) {
            BasicHeader head = new BasicHeader(key, headers.get(key));
            heads[i] = head;
            ++i;
        }
        return heads;
    }

    protected HttpParams getHttpParams(String contentType, Map<String, Object> context) throws Exception {
        NameValuePair param;
        BasicHeader header;
        HeaderElement[] values;
        String charset = "UTF-8";
        if (contentType != null && (values = (header = new BasicHeader("Content-Type", contentType)).getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)charset);
        String userAgent = this.getInExpressStringValue(this.userAgent, "userAgent", context);
        if (userAgent == null || userAgent.length() == 0) {
            userAgent = "BSP-HttpClient/1.1";
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        params.setParameter("http.origin-server", (Object)"BSP-HttpServer/1.1");
        params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true);
        params.setIntParameter("http.connection.timeout", 10000);
        return params;
    }

    protected HttpProcessor getHttpClientProcessor() {
        ImmutableHttpProcessor httpProc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue(), new RequestDate()});
        return httpProc;
    }

    protected HttpProcessor getHttpServerProcessor() {
        ImmutableHttpProcessor httpProc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseContent(), new ResponseConnControl(), new ResponseServer(), new ResponseDate()});
        return httpProc;
    }

    protected void handleException(HttpException ex, HttpResponse response) throws UnsupportedEncodingException {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        byte[] msg = ByteTools.getBytes(StringTools.printExceptionStackTrace(ex), "UTF-8");
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=UTF-8");
        response.setEntity((HttpEntity)entity);
    }
}

