/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.LogPhase;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComm
implements IComm {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private MsgConfig msgConfig;

    protected void sendMessageData(OutputStream output, byte[] bSend) throws Exception {
        if (bSend == null || bSend.length == 0) {
            throw new Exception(this.getUnitName() + " @ The variable sent is empty");
        }
        output.write(bSend);
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.SEND)) {
                this.logger.info("{} @ Send data[{}]:\n{}", new Object[]{this.getUnitName(), bSend.length, StringTools.toHexTable(bSend, this.getMsgConfig().getMsgEncode())});
            } else {
                this.logger.info("{} @ Send data[{}]:\n{}", new Object[]{this.getUnitName(), bSend.length, StringTools.printStr(bSend, this.getMsgConfig().getMsgEncode())});
            }
        }
    }

    protected void recvMessageData(DataInputStream dis, byte[] bRecv) throws Exception {
        dis.readFully(bRecv);
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.RECV)) {
                this.logger.info("{} @ Receive data[{}]:\n{}", new Object[]{this.getUnitName(), bRecv.length, StringTools.toHexTable(bRecv, this.getMsgConfig().getMsgEncode())});
            } else {
                this.logger.info("{} @ Receive data[{}]:\n{}", new Object[]{this.getUnitName(), bRecv.length, StringTools.printStr(bRecv, this.getMsgConfig().getMsgEncode())});
            }
        }
    }

    public static String getInExpressStringValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static byte[] getInExpressByteValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return null;
        }
        try {
            return (byte[])value;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The type of expression value is not byte[]");
        }
    }

    public static boolean getInExpressBooleanValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(String.valueOf(value));
    }

    protected Object getInExpressObjectValue(String expr, Map<String, Object> context) throws Exception {
        return ExpressTools.getValue(expr, context);
    }

    protected boolean printHexLog(LogPhase phase) {
        String msgType = this.msgConfig.getInputMsgType();
        if (phase == LogPhase.RECV) {
            if (StringTools.isEmpty(msgType) || "NONE".equals(msgType)) {
                msgType = this.msgConfig.getReqMsgType();
            }
        } else if (phase == LogPhase.SEND) {
            msgType = this.msgConfig.getRespMsgType();
        }
        return !DataFormatRegistry._plainDataformat.contains(msgType);
    }

    protected abstract String getUnitName();

    @Override
    public MsgConfig getMsgConfig() {
        return this.msgConfig;
    }

    @Override
    public void setMsgConfig(MsgConfig msgConfig) {
        this.msgConfig = msgConfig;
    }
}

