/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.el;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.HashMap;
import java.util.Map;

public class MagicVariableFactory {
    private static Map<String, String> libraries = new HashMap<String, String>();
    private static Map<String, String> expressionMap = new HashMap<String, String>();
    public static final String MAGIC_NAME_HAS_NEXT_ROW = "HasNextRow";
    public static final String PREFIX_TAG = "${";
    public static final String POSTFIX_TAG = "}";

    public static void addMagicVarible(String varibleName, String varibleValue) {
        libraries.put(varibleName, varibleValue);
    }

    public static String getMagicVariableExpression(String magicName) {
        String value = libraries.get(magicName);
        return value == null ? magicName : value;
    }

    public static boolean isMagic(String magicName) {
        return libraries.get(magicName) != null;
    }

    public static String parseMagicExpression(String expression) {
        if (StringTools.isEmpty(expression)) {
            return expression;
        }
        int start = 0;
        int mark = expression.indexOf(PREFIX_TAG);
        if (mark < 0) {
            return expression;
        }
        String ret = expressionMap.get(expression);
        if (ret != null) {
            return ret;
        }
        StringBuilder buffer = new StringBuilder();
        while (mark >= 0) {
            buffer.append(expression.substring(start, mark));
            int markEnd = expression.indexOf(POSTFIX_TAG, mark);
            start = markEnd + 1;
            String name = expression.substring(mark + 2, markEnd);
            String value = MagicVariableFactory.getMagicVariableExpression(name);
            buffer.append(value);
            mark = expression.indexOf(PREFIX_TAG, markEnd);
        }
        buffer.append(expression.substring(start));
        ret = buffer.toString();
        expressionMap.put(expression, ret);
        return ret;
    }

    static {
        MagicVariableFactory.addMagicVarible("ExceptionType", "G_EXCEPTION_TYPE");
        MagicVariableFactory.addMagicVarible("ExceptionMessage", "G_EXCEPTION_MESSAGE");
        MagicVariableFactory.addMagicVarible("ExceptionCode", "G_EXCEPTION_CODE");
        MagicVariableFactory.addMagicVarible("ExceptionDetail", "G_EXCEPTION_DETAIL");
        MagicVariableFactory.addMagicVarible("RowData", "T_TMP.magic.RowData");
        MagicVariableFactory.addMagicVarible("RowNumber", "T_TMP.magic.RowNumber");
        MagicVariableFactory.addMagicVarible(MAGIC_NAME_HAS_NEXT_ROW, "T_TMP.magic.HasNextRow");
        MagicVariableFactory.addMagicVarible("Cell", "T_TMP.magic.excel.Cell");
    }
}

