/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class LoggerTools {
    private static final char CHAR_DOT = '.';

    public static void contextLog(String name, Map<String, Object> context, Logger logger, int level) {
        try {
            Object oCode = context.remove("G_EXCEPTION_CODE");
            Object oType = context.remove("G_EXCEPTION_TYPE");
            Object oMsg = context.remove("G_EXCEPTION_MESSAGE");
            Object oDetail = context.remove("G_EXCEPTION_DETAIL");
            StringBuilder buffer = new StringBuilder(name + " @\n");
            LoggerTools.printMap(context, "", "", logger, level, "", buffer);
            if (oCode != null) {
                buffer.append(" **Exception information ignored:G_EXCEPTION_CODE\u3001G_EXCEPTION_TYPE\u3001G_EXCEPTION_MESSAGE\u3001G_EXCEPTION_DETAIL");
                context.put("G_EXCEPTION_CODE", oCode);
                context.put("G_EXCEPTION_TYPE", oType);
                context.put("G_EXCEPTION_MESSAGE", oMsg);
                context.put("G_EXCEPTION_DETAIL", oDetail);
            }
            LoggerTools.print(buffer.toString(), logger, level);
        }
        catch (Throwable e) {
            logger.error("Log record exception", e);
        }
    }

    private static void print(String content, Logger logger, int level) {
        switch (level) {
            case 0: {
                if (!logger.isInfoEnabled()) break;
                logger.info(content);
                break;
            }
            case 1: {
                if (!logger.isDebugEnabled()) break;
                logger.debug(content);
                break;
            }
            case 2: {
                if (!logger.isErrorEnabled()) break;
                logger.error(content);
                break;
            }
        }
    }

    private static boolean printMap(Object object, String path, String key, Logger logger, int level, String info, StringBuilder stringBuilder) {
        if (path.length() > 0 && path.charAt(0) == '.') {
            path = path.substring(1);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            map.hashCode();
            for (Map.Entry entry : map.entrySet()) {
                boolean con;
                if (((String)entry.getKey()).startsWith("T_") || (con = LoggerTools.printMap(entry.getValue(), path + "." + (String)entry.getKey(), (String)entry.getKey(), logger, level, info, stringBuilder))) continue;
                return con;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                boolean con = LoggerTools.printMap(list.get(i), path + "[" + i + "]", "", logger, level, info, stringBuilder);
                if (con) continue;
                return con;
            }
            return true;
        }
        String sv = object instanceof byte[] ? StringTools.toHexTable((byte[])object, 16, 3, StringTools.defaultCharset) : StringTools.getString(object);
        StringBuilder buffer = new StringBuilder();
        buffer.append(" ");
        if (info != null && info.length() > 0) {
            buffer.append(info);
            buffer.append(" @ ");
        }
        buffer.append(path);
        buffer.append('=');
        buffer.append(sv);
        if (stringBuilder == null) {
            LoggerTools.print(buffer.toString(), logger, level);
            return true;
        }
        int varSizeLeft = 10240 - buffer.length();
        int varSize = varSizeLeft < 0 ? buffer.length() + varSizeLeft : buffer.length();
        int totalSizeLeft = 38912 - (stringBuilder.length() + varSize);
        if (totalSizeLeft < 0) {
            varSize += totalSizeLeft;
        }
        if (varSize < buffer.length()) {
            stringBuilder.append(buffer.substring(0, varSize)).append(" (").append(buffer.length()).append("bytes ignored)\n");
        } else {
            stringBuilder.append((CharSequence)buffer).append("\n");
        }
        if (totalSizeLeft < 0) {
            stringBuilder.append(" **Other variables ignored\n");
            return false;
        }
        return true;
    }
}

