/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.spring.editor;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import java.beans.PropertyEditorSupport;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractEditor
extends PropertyEditorSupport {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractEditor.class);
    protected static Map<String, Object> propMap = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        int prefixIndex = -1;
        if (text != null && (prefixIndex = text.indexOf("${")) > -1) {
            int defaultIndex;
            int postfixIndex;
            if ((postfixIndex = text.indexOf("}", prefixIndex++)) < 0) {
                throw new IllegalArgumentException("Expression [" + text + "] is missing end tag '}'");
            }
            String defaultValue = null;
            if ((defaultIndex = text.indexOf(":", prefixIndex++)) > -1 && postfixIndex > defaultIndex) {
                defaultValue = text.substring(defaultIndex + 1, postfixIndex);
            }
            String express = null;
            express = defaultValue != null ? text.substring(prefixIndex, defaultIndex) : text.substring(prefixIndex, postfixIndex);
            Environment environment = (Environment)BspAutoConfiguration.applicationContext.getBean(Environment.class);
            String property = environment.getProperty(express);
            if (property != null && property.length() != 0) {
                this.setValue(this.converObject(property));
                return;
            } else {
                if (defaultValue == null) throw new IllegalArgumentException("The value of expression [" + express + "] is empty");
                logger.warn("\u8868Expression [{}] uses default value: [{}]", (Object)express, (Object)defaultValue);
                this.setValue(this.converObject(defaultValue));
            }
            return;
        } else {
            super.setValue(this.converObject(text));
        }
    }

    protected abstract Object converObject(Object var1);
}

