/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.sn;

import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.sn.ISnGenerator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerialManager {
    private Map<String, ISnGenerator> _publicSerialCache = new ConcurrentHashMap<String, ISnGenerator>();

    public Object getNextValue(String serialName) throws ResourceException {
        ISnGenerator sng = this._publicSerialCache.get(serialName);
        if (sng == null) {
            throw new ResourceException("The specified serial number was not found:" + serialName);
        }
        return sng.getNextSn();
    }

    public void addSnGenerator(String snName, ISnGenerator generator) {
        this._publicSerialCache.put(snName, generator);
    }

    public void clearSnGenerator() {
        this._publicSerialCache.clear();
    }
}

