/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.mfd;

import cn.com.yusys.yusp.bsp.resources.mfd.CacheBody;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheBuild;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheMethod;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheParse;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Body;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.BodyItem;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Build;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Case;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormatRef;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Default;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.ItemRef;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Method;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Methods;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Parse;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.SubRefDataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Switch;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;

public class DataFormatTransfer {
    private String dataformatName;

    public String getDataformatName() {
        return this.dataformatName;
    }

    public void setDataformatName(String dataformatName) {
        this.dataformatName = dataformatName;
    }

    public void transferDataFormat(DataFormat dataformat, String parentPath) throws Exception {
        this.setDataformatName(dataformat.getImplClass());
        this.transferBody(dataformat.getBody(), parentPath);
        dataformat.setHead(new CacheHead(dataformat.getHead()));
        dataformat.setBody(new CacheBody(dataformat.getBody()));
    }

    private void transferBody(Body body, String parentPath) throws Exception {
        BodyItem[] bodyItem = body.getBodyItem();
        for (int i = 0; i < bodyItem.length; ++i) {
            this.transferBodyItem(bodyItem[i].getChoiceValue(), parentPath);
        }
    }

    private void transferBodyItem(Object choiceValue, String parentPath) throws Exception {
        if (choiceValue instanceof Item) {
            this.transferItem((Item)choiceValue, parentPath);
        } else if (choiceValue instanceof Group) {
            this.transferGroup((Group)choiceValue, parentPath);
        } else if (choiceValue instanceof While) {
            this.transferWhile((While)choiceValue, parentPath);
        } else if (choiceValue instanceof Switch) {
            this.transferSwitch((Switch)choiceValue, parentPath);
        } else if (choiceValue instanceof DataFormatRef) {
            this.transferDataFormatRef((DataFormatRef)choiceValue, parentPath);
        } else if (choiceValue instanceof SubRefDataFormat) {
            this.transferSubRefDataFormat((SubRefDataFormat)choiceValue, parentPath);
        } else if (choiceValue instanceof ItemRef) {
            this.transferItemRef((ItemRef)choiceValue, parentPath);
        }
    }

    protected void transferItemRef(ItemRef itemRef, String parentPath) {
        itemRef.setHead(new CacheHead(itemRef.getHead()));
        this.transferMethods(itemRef.getMethods());
    }

    protected void transferDataFormatRef(DataFormatRef dataFormatRef, String parentPath) {
        dataFormatRef.setPath(parentPath);
    }

    private void transferSubRefDataFormat(SubRefDataFormat subRefDataFormat, String parentPath) {
        subRefDataFormat.setPath(parentPath);
    }

    private void transferSwitch(Switch _switch, String parentPath) throws Exception {
        Default _default;
        Case[] cases = _switch.getCase();
        if (cases != null) {
            for (int i = 0; i < cases.length; ++i) {
                this.transferCase(cases[i], parentPath);
            }
        }
        if ((_default = _switch.getDefault()) != null) {
            this.transferDefault(_default, parentPath);
        }
    }

    private void transferCase(Case _case, String parentPath) throws Exception {
        this.transferBody(_case.getBody(), parentPath);
    }

    private void transferDefault(Default _default, String parentPath) throws Exception {
        this.transferBody(_default.getBody(), parentPath);
    }

    private void transferWhile(While _while, String parentPath) throws Exception {
        if (StringTools.isEmpty(parentPath)) {
            parentPath = _while.getName();
            _while.setPath(parentPath);
            parentPath = parentPath + "[" + _while.getVar() + "]";
        } else {
            parentPath = parentPath + "." + _while.getName();
            _while.setPath(parentPath);
            parentPath = parentPath + "[" + _while.getVar() + "]";
        }
        this.transferBody(_while.getBody(), parentPath);
        _while.setHead(new CacheHead(_while.getHead()));
        _while.setBody(new CacheBody(_while.getBody()));
    }

    protected void transferItem(Item item, String parentPath) throws Exception {
        if (item.getDataFormat() != null) {
            DataFormatTransfer transfer = new DataFormatTransfer();
            transfer.transferDataFormat(item.getDataFormat(), parentPath);
        } else if (item.getSubRefDataFormat() != null) {
            DataFormatTransfer transfer = new DataFormatTransfer();
            transfer.transferSubRefDataFormat(item.getSubRefDataFormat(), parentPath);
        }
        parentPath = StringTools.isEmpty(parentPath) ? item.getName() : parentPath + "." + item.getName();
        item.setPath(parentPath);
        item.setHead(new CacheHead(item.getHead()));
        this.transferMethods(item.getMethods());
    }

    protected void transferMethods(Methods methods) {
        if (methods != null) {
            Method[] methodArr;
            Method[] methodArr2;
            Build build = methods.getBuild();
            if (build != null && (methodArr2 = build.getMethod()) != null) {
                for (int i = 0; i < methodArr2.length; ++i) {
                    methodArr2[i] = new CacheMethod(methodArr2[i]);
                }
                build.setMethod(methodArr2);
            }
            methods.setBuild(new CacheBuild(build));
            Parse parse = methods.getParse();
            if (parse != null && (methodArr = parse.getMethod()) != null) {
                for (int i = 0; i < methodArr.length; ++i) {
                    methodArr[i] = new CacheMethod(methodArr[i]);
                }
                parse.setMethod(methodArr);
            }
            methods.setParse(new CacheParse(parse));
        }
    }

    private void transferGroup(Group group, String parentPath) throws Exception {
        parentPath = StringTools.isEmpty(parentPath) ? group.getName() : parentPath + "." + group.getName();
        group.setPath(parentPath);
        this.transferBody(group.getBody(), parentPath);
        group.setHead(new CacheHead(group.getHead()));
        group.setBody(new CacheBody(group.getBody()));
    }
}

