/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.util;

import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DesTools;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesEncrypAndDecrypUtil {
    private static final String APPEND = "AppendToTail";
    private static final String REPLACE = "ReplaceToTail";
    private static final String RETVAR = "RetVar";
    private static final String FILE = "File";
    private static final String VAR = "Var";
    private static final String ENCODE = "ENCODE";
    private static final String DECODE = "DECODE";
    private static final String DES1 = "DES1";
    private static final String CIRCLE = "CIRCLE";
    private static final String DES3 = "DES3";
    protected static final String PARA_DATASTARTPOS = "dataStartPos";
    protected static final String PARA_DATALENGTH = "dataLength";
    protected static final String PARA_KEYTYPE = "keyType";
    protected static final String PARA_KEYVAR = "keyVar";
    protected static final String PARA_KEYFILE = "keyFile";
    protected static final String PARA_OPERATION = "operation";
    protected static final String PARA_METHOD = "method";
    protected static final String PARA_MODE = "mode";
    protected static final String PARA_PADDING = "padding";
    protected static final String PARA_RETWAY = "retWay";
    private static final Logger logger = LoggerFactory.getLogger(DesEncrypAndDecrypUtil.class);

    public static byte[] des(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        byte[] dataSrc = ByteTools.getBytes(_srcData);
        int dataStartPos = -1;
        String inputDataStartPos = "";
        try {
            inputDataStartPos = StringTools.getString(paras.get(PARA_DATASTARTPOS));
            dataStartPos = Integer.parseInt(inputDataStartPos);
        }
        catch (Exception e) {
            throw new Exception("Exception in parsing the interception location of the encrypting and decrypting source data:" + inputDataStartPos);
        }
        int dataLength = -1;
        String inputDataLength = "";
        inputDataLength = StringTools.getString(paras.get(PARA_DATALENGTH));
        dataLength = Integer.parseInt(inputDataLength);
        if (logger.isDebugEnabled()) {
            logger.debug(" The encrypting and decrypting source data: \n{}", (Object)StringTools.toHexTable(dataSrc));
        }
        byte[] encryptData = null;
        try {
            encryptData = ByteTools.subBytes(dataSrc, dataStartPos, true, dataLength, true);
            if (encryptData.length % 8 != 0) {
                int length = (encryptData.length / 8 + 1) * 8;
                byte[] tmpArray = new byte[length];
                System.arraycopy(encryptData, 0, tmpArray, 0, encryptData.length);
                encryptData = tmpArray;
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to get the encrypting and decrypting source data", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Intercepted encrypting and decrypting data: \n{}", (Object)StringTools.toHexTable(encryptData));
        }
        String keyType = (String)paras.get(PARA_KEYTYPE);
        byte[] keyData = null;
        if (VAR.equals(keyType)) {
            Object keyVar = paras.get(PARA_KEYVAR);
            keyData = ByteTools.getBytes(keyVar);
        } else if (FILE.equals(keyType)) {
            Object keyFile = paras.get(PARA_KEYFILE);
            String keyPath = StringTools.getString(keyFile);
            try {
                keyData = FileTools.readFileContent(keyPath);
            }
            catch (Exception e) {
                throw new Exception("Failed to read key file", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" Key file content:\n{}", (Object)StringTools.toHexTable(keyData));
            }
        }
        String operation = (String)paras.get(PARA_OPERATION);
        String method = (String)paras.get(PARA_METHOD);
        String mode = (String)paras.get(PARA_MODE);
        String padding = (String)paras.get(PARA_PADDING);
        padding = StringTools.isEmpty(padding) ? "NoPadding" : padding;
        mode = StringTools.isEmpty(mode) ? "ECB" : mode;
        byte[] result = null;
        if (ENCODE.equals(operation)) {
            if (DES1.equals(method)) {
                result = DesTools.des1Encode(encryptData, keyData, mode, padding);
            } else if (CIRCLE.equals(method)) {
                result = DesTools.cirEncode(encryptData, keyData, mode, padding);
            } else if (DES3.equals(method)) {
                result = DesTools.des3Encode(encryptData, keyData, mode, padding);
            }
        } else if (DECODE.equals(operation)) {
            if (DES1.equals(method)) {
                result = DesTools.des1Decode(encryptData, keyData, mode, padding);
            } else if (CIRCLE.equals(method)) {
                result = DesTools.cirDecode(encryptData, keyData, mode, padding);
            } else if (DES3.equals(method)) {
                result = DesTools.des3Decode(encryptData, keyData, mode, padding);
            }
        }
        String retWay = (String)paras.get(PARA_RETWAY);
        if (RETVAR.equals(retWay)) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u52a0\u89e3\u5bc6\u7ed3\u679c: \n{}", (Object)StringTools.toHexTable(result));
            }
            return result;
        }
        if (APPEND.equals(retWay)) {
            byte[] tmpArray = new byte[dataSrc.length + result.length];
            System.arraycopy(dataSrc, 0, tmpArray, 0, dataSrc.length);
            System.arraycopy(result, 0, tmpArray, dataSrc.length, result.length);
            if (logger.isDebugEnabled()) {
                logger.debug(" Encryption and decryption result:\n{} ", (Object)StringTools.toHexTable(tmpArray));
            }
            return tmpArray;
        }
        if (REPLACE.equals(retWay)) {
            if (dataSrc.length > result.length) {
                System.arraycopy(result, 0, dataSrc, dataSrc.length - -result.length, result.length);
                if (logger.isDebugEnabled()) {
                    logger.debug(" Encryption and decryption result:\n{} ", (Object)StringTools.toHexTable(dataSrc));
                }
                return dataSrc;
            }
            throw new Exception("The byte length of encrypting and decrypting source data is too short");
        }
        return result;
    }
}

