/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.impl;

import cn.com.yusys.yusp.bsp.method.impl.StringMethodTool;
import cn.com.yusys.yusp.bsp.method.util.ArithUtil;
import cn.com.yusys.yusp.bsp.method.util.CurrencuUtil;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntMethodTool {
    private static final Logger logger = LoggerFactory.getLogger(IntMethodTool.class);
    private static final String BASE_NUM = "baseNumber";
    private static final char CHAR_DOT = '.';
    private static final String DIR_DOWN = "DOWN";
    private static final String DIR_LEFT = "LEFT";
    private static final String DIR_RIGHT = "RIGHT";
    private static final String DIR_UP = "UP";
    private static final String DIRECTION = "direction";
    private static final String FILL_LEN = "fillLength";
    private static final String LENGTH = "length";
    private static final String NUM_STR = "num2str";
    private static final String OP_ADD = "+";
    private static final String OP_NUM = "opNumber";
    private static final String OP_SIGN = "opSign";
    private static final String OP_SUB = "-";
    private static final String OP_MUL = "*";
    private static final String OP_DIV = "/";
    private static final String SIGN_CHAR = "signChar";
    private static final String STR_INT = "str2int";
    private static final String STR_LONG = "str2long";
    private static final String STR_SHORT = "str2short";
    private static final String SWITCH_FORMAT = "switchFormat";
    private static final String TARGET_LEN = "targetLength";

    public static String addDecimalPoint(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        int len = srcData.length;
        if (len == 0) {
            return "";
        }
        for (int n = 0; n < len; ++n) {
            if (srcData[n] != 46) continue;
            return new String(srcData);
        }
        byte[] bt = null;
        if (srcData[0] == 45 && len <= 3) {
            bt = new byte[]{45, 48, 46, len == 3 ? srcData[1] : (byte)48, srcData[len - 1]};
        } else if (len <= 2) {
            bt = new byte[]{48, 46, len == 2 ? srcData[0] : (byte)48, srcData[len - 1]};
        } else {
            bt = new byte[len + 1];
            int i = len;
            int j = len - 1;
            while (i >= 0) {
                if (i == len - 2) {
                    bt[i] = 46;
                    ++j;
                } else {
                    bt[i] = srcData[j];
                }
                --i;
                --j;
            }
        }
        return new String(bt);
    }

    public static byte[] ASC2BCD(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        String signChar = new String(sign);
        String direction = StringTools.getString(paras.get(DIRECTION));
        int fillLength = Integer.parseInt(StringTools.getString(paras.get(FILL_LEN)));
        boolean bLeft = false;
        int nFill = Integer.parseInt(signChar, 16);
        byte[] ret = null;
        if (direction.equals(DIR_LEFT)) {
            bLeft = true;
        }
        try {
            ret = ByteTools.asc2Bcd(srcData, nFill, bLeft, fillLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static byte[] BCD2ASC(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        String signChar = new String(sign);
        String direction = StringTools.getString(paras.get(DIRECTION));
        int fillLength = Integer.parseInt(StringTools.getString(paras.get(FILL_LEN)));
        boolean bLeft = false;
        int nFill = Integer.parseInt(signChar, 16);
        byte[] ret = null;
        if (direction.equals(DIR_LEFT)) {
            bLeft = true;
        }
        try {
            ret = fillLength <= 0 ? ByteTools.bcd2Asc(srcData) : ByteTools.bcd2Asc(srcData, nFill, bLeft, fillLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static int binary2Int(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        int baseNum = Integer.parseInt(StringTools.getString(paras.get(BASE_NUM)));
        String direction = StringTools.getString(paras.get(DIRECTION));
        if (baseNum <= 0) {
            throw new IllegalArgumentException("Wrong parameter");
        }
        int result = 0;
        if (DIR_UP.equals(direction)) {
            for (int i = 0; i < srcData.length; ++i) {
                result += (int)((double)(0xFF & srcData[i]) * Math.pow(baseNum, i));
            }
        } else if (DIR_DOWN.equals(direction)) {
            for (int i = 0; i < srcData.length; ++i) {
                result += (int)((double)(0xFF & srcData[i]) * Math.pow(baseNum, srcData.length - i - 1));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static String delDecimalPoint(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        String src = StringTools.getString(_srcData);
        if (src.length() == 0) {
            return src;
        }
        BigDecimal bsrc = new BigDecimal(src);
        BigDecimal tem = bsrc.multiply(new BigDecimal(100));
        src = tem.toString();
        return new String(IntMethodTool.delPoint(src.getBytes()));
    }

    public static byte[] deleteWord(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SIGN_CHAR)))) {
            logger.warn("Delete character function @ identifier has no parameter configured, do not delete");
            return srcData;
        }
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        byte signChar = sign[0];
        String direction = StringTools.isEmpty(StringTools.getString(paras.get(DIRECTION))) ? DIR_RIGHT : StringTools.getString(paras.get(DIRECTION));
        int targetLength = StringTools.isEmpty(StringTools.getString(paras.get(TARGET_LEN))) ? 0 : Integer.parseInt(StringTools.getString(paras.get(TARGET_LEN)));
        if (targetLength < 0) {
            targetLength = 0;
        }
        byte[] tempbt = new byte[]{48};
        if (direction.equals(DIR_LEFT)) {
            int i = 0;
            int j = 0;
            while (srcData[i] == signChar && srcData.length - i > targetLength) {
                if (++i == srcData.length) {
                    return tempbt;
                }
                ++j;
            }
            byte[] bt = new byte[srcData.length - j];
            System.arraycopy(srcData, j, bt, 0, srcData.length - j);
            return bt;
        }
        if (direction.equals(DIR_RIGHT)) {
            int i = srcData.length - 1;
            while (srcData[i] == signChar && i != targetLength - 1) {
                if (--i >= 0) continue;
                return tempbt;
            }
            byte[] bt = new byte[i + 1];
            System.arraycopy(srcData, 0, bt, 0, i + 1);
            return bt;
        }
        return srcData;
    }

    public static byte[] delPoint(byte[] b) {
        int i;
        byte[] reb = null;
        for (i = 0; i < b.length && b[i] != 46; ++i) {
        }
        reb = new byte[i];
        System.arraycopy(b, 0, reb, 0, i);
        return reb;
    }

    public static byte[] fillWord(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        return StringMethodTool.fillWord(_srcData, paras, context);
    }

    public static String formatMoney(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        String ret;
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (srcData.length == 0) {
            return "";
        }
        String sf = StringTools.getString(paras.get(SWITCH_FORMAT));
        if (StringTools.isEmpty(sf)) {
            logger.warn("Format amount function @ the converted amount format does not have parameters configured and is not formatted");
            return new String(srcData);
        }
        DecimalFormat formatter = new DecimalFormat(sf);
        String str = new String(srcData);
        if (str.indexOf(46) != -1) {
            double i = Double.parseDouble(str);
            ret = formatter.format(i);
        } else {
            long i = Long.parseLong(str);
            ret = formatter.format(i);
        }
        return ret;
    }

    public static byte[] int2Binary(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        String srcData = StringTools.getString(_srcData);
        int baseNum = Integer.parseInt(StringTools.getString(paras.get(BASE_NUM)));
        String direction = StringTools.getString(paras.get(DIRECTION));
        int len = Integer.parseInt(StringTools.getString(paras.get(LENGTH)));
        int srcInt = Integer.parseInt(srcData);
        if (srcInt < 0 || baseNum <= 0 || len <= 0) {
            throw new IllegalArgumentException("Wrong parameter");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        do {
            bout.write((byte)(srcInt % baseNum));
        } while ((srcInt /= baseNum) > 0);
        try {
            bout.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bdata = bout.toByteArray();
        if (bdata.length > len) {
            throw new IllegalArgumentException("Data [" + srcInt + "] exceeds the specified length");
        }
        byte[] bret = null;
        if (DIR_UP.equals(direction)) {
            if (bdata.length == len) {
                bret = bdata;
            } else {
                bret = new byte[len];
                System.arraycopy(bdata, 0, bret, 0, bdata.length);
            }
        } else if (DIR_DOWN.equals(direction)) {
            bret = new byte[len];
            for (int i = 0; i < bdata.length; ++i) {
                bret[i + len - bdata.length] = bdata[bdata.length - 1 - i];
            }
        } else {
            throw new IllegalArgumentException("Wrong parameter");
        }
        return bret;
    }

    public static long numberCompute(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        String srcData = StringTools.getString(_srcData);
        String op = StringTools.getString(paras.get(OP_SIGN));
        long opNum = StringTools.isEmpty(StringTools.getString(paras.get(OP_NUM))) ? 0L : Long.parseLong(StringTools.getString(paras.get(OP_NUM)));
        long oldNum = Long.parseLong(srcData);
        if (op.equals(OP_ADD)) {
            oldNum += opNum;
        } else if (op.equals(OP_SUB)) {
            oldNum -= opNum;
        } else {
            logger.warn("Operator{} is not supported, no change", (Object)op);
            return oldNum;
        }
        return oldNum;
    }

    public static double decimalCompute(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        double opNum;
        String srcData = StringTools.getString(_srcData);
        String op = StringTools.getString(paras.get(OP_SIGN));
        String opExpr = StringTools.getString(paras.get(OP_NUM));
        if (opExpr == null || opExpr.length() == 0) {
            if (logger.isWarnEnabled()) {
                logger.warn("Parameter 'operand' has no value, default value is 0");
            }
            opNum = 0.0;
        } else {
            String opValue = StringTools.getString(OgnlTools.getValue(opExpr, context));
            if (opValue == null || opValue.length() == 0) {
                throw new Exception("The value of expression " + opExpr + " is null");
            }
            opNum = Double.parseDouble(StringTools.getString(OgnlTools.getValue(opExpr, context)));
        }
        double oldNum = Double.parseDouble(srcData);
        if (op.equals(OP_ADD)) {
            oldNum = ArithUtil.add(oldNum, opNum);
        } else if (op.equals(OP_SUB)) {
            oldNum = ArithUtil.sub(oldNum, opNum);
        } else if (op.equals(OP_MUL)) {
            oldNum = ArithUtil.mul(oldNum, opNum);
        } else if (op.equals(OP_DIV)) {
            oldNum = ArithUtil.div(oldNum, opNum);
        } else {
            logger.warn("Operator{} is not supported, no change", (Object)op);
            return oldNum;
        }
        return oldNum;
    }

    public static byte[] str2Num(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        String srcData = StringTools.getString(_srcData);
        String op = StringTools.getString(paras.get(OP_SIGN));
        byte[] bt = null;
        if (op.equals(STR_SHORT)) {
            short n = Short.parseShort(srcData);
            bt = ByteTools.short2byte(n);
        } else if (op.equals(STR_INT)) {
            int n = Integer.parseInt(new String(srcData));
            bt = ByteTools.int2byte(n);
        } else if (op.equals(STR_LONG)) {
            long n = Long.parseLong(new String(srcData));
            bt = ByteTools.long2byte(n);
        } else if (op.equals(NUM_STR)) {
            Number num = ByteTools.bytes2num(srcData.getBytes());
            long n = num.longValue();
            bt = String.valueOf(n).getBytes();
        }
        return bt;
    }

    public static String rmbSmall2Big(Object num) {
        double number = Double.parseDouble(StringTools.getString(num));
        return CurrencuUtil.rmbSmall2Big(number);
    }

    public static String rmbBig2Small(Object num) {
        return CurrencuUtil.rmbBig2Small(StringTools.getString(num));
    }
}

