/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.filter.service;

import cn.com.yusys.yusp.bsp.filter.service.RateLimitingBase;
import cn.com.yusys.yusp.bsp.filter.vm.RateCase;
import cn.com.yusys.yusp.bsp.filter.vm.RateLimit;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RateLimiting {
    protected static ConcurrentLinkedQueue<RateLimit> qRegQueue = new ConcurrentLinkedQueue();
    private RateLimitingBase rateLimitingBase;

    public RateCase getCounter(String id) {
        return this.rateLimitingBase.getCounter(id);
    }

    public void clearCounter() {
        this.rateLimitingBase.clearCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateCase getQpsCounter(String id, long timeWindow) {
        RateCase c = null;
        RateLimiting rateLimiting = this;
        synchronized (rateLimiting) {
            c = this.getCounter(id);
            if (c.getTimeWindow() != timeWindow && timeWindow > c.getTimeWindow()) {
                c.setTimeWindow(timeWindow);
                this.rateLimitingBase.saveCounter(id, c);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateCase incrementCounter(String id) {
        RateCase c = null;
        RateLimiting rateLimiting = this;
        synchronized (rateLimiting) {
            c = this.getCounter(id);
            c.rateLimitingIncrement();
            this.rateLimitingBase.saveCounter(id, c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateCase reduceCounter(String id) {
        RateCase c = null;
        RateLimiting rateLimiting = this;
        synchronized (rateLimiting) {
            c = this.getCounter(id);
            c.rateLimitingReduce();
            this.rateLimitingBase.saveCounter(id, c);
        }
        return c;
    }

    public void registerRequest(RateLimit vm) {
        qRegQueue.offer(vm);
    }

    public void tokenRecovery() {
        RateLimit limit = null;
        while ((limit = qRegQueue.peek()) != null && System.currentTimeMillis() - limit.getRequestTime() > limit.getTimeWindow() * 1000L) {
            qRegQueue.poll();
            this.reduceCounter(limit.getControlId());
        }
    }

    public RateLimitingBase getRateLimitingBase() {
        return this.rateLimitingBase;
    }

    @Lazy
    @Autowired
    public void setRateLimitingBase(RateLimitingBase rateLimitingBase) {
        this.rateLimitingBase = rateLimitingBase;
    }
}

