/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.impl.SuperXmlExecutor;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXMLNode;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SoapExecutor
extends SuperXmlExecutor {
    private static final String DATA_FORMAT_NAME = "SOAP";
    public static final String DATA_FORMAT_SOAP_ACTION = "soapOperation";
    private static final String DATA_FORMAT_SOAP_ACTION_NAMESPACE = "soapActionNamespace";
    private static final String DATA_FORMAT_SOAP_ACTION_NAMESPACE_VALUE = "soapActionNamespaceValue";
    private static final String DATA_FORMAT_SOAP_ENTITY = "soapEntity";
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private String soapEntity;
    private String soapNamespace = "soapenv";
    private String soapNamespaceValue = "http://schemas.xmlsoap.org/soap/envelope/";
    private String soapAction;
    private String soapActionNamespace;
    private String soapActionNamespaceValue;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        Object[] temp;
        String str = null;
        str = property.get("sign");
        if (StringTools.isEmpty(str)) {
            this.signList = null;
        } else {
            this.signList = new ArrayList();
            for (char c : temp = str.toCharArray()) {
                this.signList.add(String.valueOf(c));
            }
        }
        this.xmlTools = new SuperXmlTools(this.getEncoding());
        if (this.getPackType() == DATAFORMAT_UNPACK) {
            str = property.get("loopNodes");
            if (StringTools.isEmpty(str)) {
                this.loopNodes = null;
            } else {
                this.loopNodes = new ArrayList();
                for (char string : temp = (Object[])str.split("[,]")) {
                    this.loopNodes.add(this.convertPathToList((String)string));
                }
            }
        } else {
            this.soapAction = this.parseExpressStringValue(property.get(DATA_FORMAT_SOAP_ACTION));
            this.soapActionNamespace = this.parseExpressStringValue(property.get(DATA_FORMAT_SOAP_ACTION_NAMESPACE));
            this.soapActionNamespaceValue = this.parseExpressStringValue(property.get(DATA_FORMAT_SOAP_ACTION_NAMESPACE_VALUE));
            this.soapEntity = this.parseExpressStringValue(property.get(DATA_FORMAT_SOAP_ENTITY));
            str = property.get("packXml");
            Boolean packXml = true;
            if ("false".equals(str)) {
                packXml = false;
            }
            str = property.get("packSimple");
            this.packSimple = true;
            if ("false".equals(str)) {
                this.packSimple = false;
            }
            this.xmlTools.setPackSimple(this.packSimple);
            this.xmlTools.writeStartDocument(packXml);
        }
    }

    @Override
    protected byte[] autoPack(Map<String, Object> map) throws Exception {
        this.autoPackEnvelope(map);
        return this.xmlTools.writeEndDocument();
    }

    private void autoPackEnvelope(Map<String, Object> entityValue) throws Exception {
        LinkedHashMap<String, Object> envelopeMap = new LinkedHashMap<String, Object>();
        this.updateEnvelopeMap();
        LinkedHashMap<String, Object> envelopeValue = new LinkedHashMap<String, Object>();
        envelopeValue.put(this.soapNamespace, this.soapNamespaceValue);
        envelopeValue.put(this.soapActionNamespace, this.soapActionNamespaceValue);
        envelopeValue.put(SOAP_HEADER, null);
        LinkedHashMap bodyValue = new LinkedHashMap();
        LinkedHashMap<String, Map<String, Object>> soapActionValue = new LinkedHashMap<String, Map<String, Object>>();
        soapActionValue.put(this.soapEntity, entityValue);
        bodyValue.put(this.soapAction, soapActionValue);
        envelopeValue.put(SOAP_BODY, bodyValue);
        envelopeMap.put(SOAP_ENVELOPE, envelopeValue);
        this.autoPackMap(envelopeMap, new ArrayList<String>());
    }

    private void updateEnvelopeMap() throws Exception {
        ArrayList<String> tag = new ArrayList<String>();
        if (StringTools.isNullOrEmpty(this.soapEntity)) {
            tag.add(DATA_FORMAT_SOAP_ENTITY);
        }
        if (StringTools.isNullOrEmpty(this.soapAction)) {
            tag.add(DATA_FORMAT_SOAP_ACTION);
        }
        if (StringTools.isNullOrEmpty(this.soapActionNamespace)) {
            tag.add(DATA_FORMAT_SOAP_ACTION_NAMESPACE);
        }
        if (StringTools.isNullOrEmpty(this.soapActionNamespaceValue)) {
            tag.add(DATA_FORMAT_SOAP_ACTION_NAMESPACE_VALUE);
        }
        Object object = this.getCurrentContext().get("__COMMHEAD");
        Map tmp = null;
        if (!tag.isEmpty()) {
            tmp = object == null || !(object instanceof Map) ? this.getCurrentContext() : (Map)object;
        }
        for (String key : tag) {
            Object obj = tmp.get(key);
            if (StringTools.isNullOrEmpty(obj)) {
                throw new Exception("Exception occurred in [" + this.getExecutorName() + "] auto packaging: parameter [" + key + "] is not configured, auto packaging is not supported");
            }
            String value = StringTools.getString(obj);
            if (DATA_FORMAT_SOAP_ENTITY.equals(key)) {
                this.soapEntity = value;
                continue;
            }
            if (DATA_FORMAT_SOAP_ACTION.equals(key)) {
                this.soapAction = value;
                continue;
            }
            if (DATA_FORMAT_SOAP_ACTION_NAMESPACE.equals(key)) {
                this.soapActionNamespace = value;
                continue;
            }
            if (!DATA_FORMAT_SOAP_ACTION_NAMESPACE_VALUE.equals(key)) continue;
            this.soapActionNamespaceValue = value;
        }
    }

    protected void autoPackMap(Map<String, Object> map, List<String> path) throws Exception {
        Object obj = null;
        for (String key : map.keySet()) {
            obj = map.get(key);
            String prefix = null;
            int oldState = this.state;
            if (this.state == -2) {
                this.state = 1;
                oldState = 0;
            }
            if (!key.equals(this.soapActionNamespace) && !key.equals(this.soapNamespace)) {
                prefix = SOAP_ENVELOPE.equals(key) || SOAP_HEADER.equals(key) || SOAP_BODY.equals(key) ? this.soapNamespace : (key.equals(this.soapAction) ? this.soapActionNamespace : null);
                this.xmlTools.writeStartElement(prefix, key);
                ++this.state;
            }
            if (obj instanceof Map) {
                path.add(key);
                this.autoPackMap((Map)obj, path);
                path.remove(path.size() - 1);
            } else if (obj instanceof List) {
                this.autoPackList(key, (List)obj, path);
            } else {
                this.autoPackValue(key, obj, path);
            }
            if (key.equals(this.soapActionNamespace) || key.equals(this.soapNamespace)) continue;
            prefix = SOAP_ENVELOPE.equals(key) || SOAP_HEADER.equals(key) || SOAP_BODY.equals(key) ? this.soapNamespace : (key.equals(this.soapAction) ? this.soapActionNamespace : null);
            this.xmlTools.writeEndElement(prefix, key, ++oldState < this.state);
            if (this.state <= oldState) continue;
            this.state = oldState == 1 ? -1 : oldState;
        }
    }

    protected void autoPackList(String key, List<Object> list, List<String> path) throws Exception {
        String prefix = null;
        int nCount = list.size();
        int oldState = this.state;
        for (int i = 0; i < nCount; ++i) {
            Object object;
            path.add(key + "[" + i + "]");
            if (i != 0 && !StringTools.isEmpty(key)) {
                prefix = SOAP_ENVELOPE.equals(key) || SOAP_HEADER.equals(key) || SOAP_BODY.equals(key) ? this.soapNamespace : (key.equals(this.soapAction) ? this.soapActionNamespace : null);
                this.xmlTools.writeStartElement(prefix, key);
                ++this.state;
            }
            if ((object = list.get(i)) instanceof Map) {
                this.autoPackMap((Map)object, path);
            } else if (object instanceof List) {
                this.autoPackList(null, (List)object, path);
            } else {
                this.autoPackValue(null, object, path);
            }
            int j = ++oldState;
            if (i != nCount - 1) {
                prefix = SOAP_ENVELOPE.equals(key) || SOAP_HEADER.equals(key) || SOAP_BODY.equals(key) ? this.soapNamespace : (key.equals(this.soapAction) ? this.soapActionNamespace : null);
                this.xmlTools.writeEndElement(prefix, key, j < this.state);
            }
            if (this.state > oldState) {
                this.state = oldState == 1 ? -1 : oldState;
            }
            path.remove(path.size() - 1);
        }
    }

    protected void autoPackValue(String key, Object value, List<String> path) throws Exception {
        byte[] valueByte;
        if (value instanceof byte[] || value instanceof String) {
            valueByte = ByteTools.getBytes(value, this.getEncoding());
            if (this.isFilterEmpty() && valueByte.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ Auto packing: {}, filtering empty string", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
                }
                return;
            }
        } else if (value != null) {
            valueByte = ByteTools.getBytes(value, this.getEncoding());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ Auto packing: {}, ignore(value is null)", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
            }
            return;
        }
        if (this.packSimple && valueByte.length == 0) {
            return;
        }
        valueByte = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), valueByte, 1);
        if (this.soapActionNamespace.equals(key) || this.soapNamespace.equals(key)) {
            this.xmlTools.writeNamespace(key, valueByte);
        } else {
            this.xmlTools.writeCharacters(valueByte);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} @ Auto packing: {}=[{}]", new Object[]{this.getExecutorName(), this.pathToString(path, key), StringTools.getString(value, this.getEncoding())});
        }
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        HashMap autoUnpack = new HashMap();
        this.xmlNode2Map(this.xmlNode, autoUnpack, this.useValue);
        this.getCurrentContext().putAll(autoUnpack);
        this.getSoapNamespace(this.xmlNode);
        Map soapMap = (Map)autoUnpack.get(SOAP_ENVELOPE);
        HashMap<String, Object> soapEntity = new HashMap<String, Object>();
        if (!soapMap.isEmpty()) {
            soapEntity.putAll(this.getSoapEntity((Map)soapMap.get(SOAP_BODY)));
        }
        return soapEntity;
    }

    private void getSoapNamespace(SuperXMLNode envelope) {
        String name = envelope.getName();
        if (!SOAP_ENVELOPE.equals(name)) {
            return;
        }
        HashMap<String, String> soapMap = new HashMap<String, String>();
        this.getCurrentContext().put("__COMMHEAD", soapMap);
        Map<String, Namespace> namespaces = envelope.getNamespaces();
        int namespaceSize = namespaces.size();
        if (namespaceSize != 0) {
            String prefix = null;
            for (Namespace namespace : namespaces.values()) {
                prefix = StringTools.isEmpty(namespace.getPrefix()) ? "xmlns" : namespace.getPrefix();
                if (prefix.equals(envelope.getPrefix())) continue;
                soapMap.put(DATA_FORMAT_SOAP_ACTION_NAMESPACE, prefix);
                soapMap.put(DATA_FORMAT_SOAP_ACTION_NAMESPACE_VALUE, namespace.getUri());
            }
        }
    }

    private Map<String, Object> getSoapEntity(Map<String, Object> body) {
        HashMap<String, String> soapMap = new HashMap<String, String>();
        Object object = this.getCurrentContext().get("__COMMHEAD");
        for (String action : body.keySet()) {
            soapMap.put(DATA_FORMAT_SOAP_ACTION, action);
            Map actionMap = (Map)body.get(action);
            for (String entity : actionMap.keySet()) {
                Object obj = actionMap.get(entity);
                soapMap.put(DATA_FORMAT_SOAP_ENTITY, entity);
                if (object != null && object instanceof Map) {
                    ((Map)object).putAll(soapMap);
                }
                if (obj == null || !(obj instanceof Map)) continue;
                return (Map)obj;
            }
        }
        return null;
    }

    @Override
    protected boolean validateLoop(LinkedList<String> nodeList, String key) {
        if (this.loopNodes == null) {
            return false;
        }
        boolean res = false;
        nodeList.add(key);
        for (List list : this.loopNodes) {
            if (list.isEmpty() || !list.contains(key)) continue;
            res = true;
            break;
        }
        nodeList.removeLast();
        return res;
    }

    public String getSoapEntity() {
        return this.soapEntity;
    }

    public void setSoapEntity(String soapEntity) {
        this.soapEntity = soapEntity;
    }

    public String getSoapNamespace() {
        return this.soapNamespace;
    }

    public void setSoapNamespace(String soapNamespace) {
        this.soapNamespace = soapNamespace;
    }

    public String getSoapNamespaceValue() {
        return this.soapNamespaceValue;
    }

    public void setSoapNamespaceValue(String soapNamespaceValue) {
        this.soapNamespaceValue = soapNamespaceValue;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getSoapActionNamespace() {
        return this.soapActionNamespace;
    }

    public void setSoapActionNamespace(String soapActionNamespace) {
        this.soapActionNamespace = soapActionNamespace;
    }

    public String getSoapActionNamespaceValue() {
        return this.soapActionNamespaceValue;
    }

    public void setSoapActionNamespaceValue(String soapActionNamespaceValue) {
        this.soapActionNamespaceValue = soapActionNamespaceValue;
    }
}

