/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SeparatorExecutor
extends AbstractExecutor<byte[]> {
    public static final String DATA_FORMAT_NAME = "\u5206\u9694\u7b26";
    private static final String DATA_FORMAT_DEFAULT_SIGN = "defaultSign";
    private static final String DATA_FORMAT_VALUE_TYPE = "valueType";
    private static final String DATA_FORMAT_SIGN = "sign";
    private static final String DATA_FORMAT_IS_HAVE = "isHave";
    private static final String IS_HAVE_LEFT = "left";
    private static final String IS_HAVE_RIGHT = "right";
    private static final String IS_HAVE_BOTH = "both";
    private byte[] defaultSign = new byte[]{124};
    private boolean leftHave = false;
    private boolean rightHave = false;
    private int endSignLen = 0;
    private int defaultSignLen = 1;
    private int searchIndex = 0;
    private int dataLen = 0;
    private boolean isStr;
    private ByteArrayOutputStream buildStream;
    private static final String LEN = "len";

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        String temp = property.get(DATA_FORMAT_DEFAULT_SIGN);
        if (!StringTools.isEmpty(temp)) {
            this.defaultSign = StringTools.escString2Byte(temp);
            this.defaultSignLen = this.defaultSign.length;
        }
        if (IS_HAVE_LEFT.equals(temp = property.get(DATA_FORMAT_IS_HAVE))) {
            this.leftHave = true;
        } else if (IS_HAVE_RIGHT.equals(temp)) {
            this.rightHave = true;
        } else if (IS_HAVE_BOTH.equals(temp)) {
            this.leftHave = true;
            this.rightHave = true;
        } else {
            this.leftHave = false;
            this.rightHave = false;
        }
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.buildStream = new ByteArrayOutputStream();
            if (this.leftHave) {
                this.buildStream.write(this.defaultSign);
            }
        } else {
            String attr = property.get(DATA_FORMAT_VALUE_TYPE);
            if ("string".equals(attr)) {
                this.isStr = true;
            }
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        boolean start;
        this.searchIndex = 0;
        this.dataLen = inputData.length;
        if (this.leftHave && (start = ExecutorHelper.contrastBytes(inputData, 0, this.defaultSign))) {
            this.searchIndex = this.defaultSignLen;
        }
        super.inputData(inputData);
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.buildStream.toByteArray();
        this.buildStream.close();
        if (this.rightHave) {
            return data;
        }
        byte[] ret = new byte[data.length - this.endSignLen];
        System.arraycopy(data, 0, ret, 0, ret.length);
        return ret;
    }

    @Override
    public void packItem(Item field, byte[] data, Map<String, String> paras) throws Exception {
        this.buildStream.write(data);
        String sign = paras.get(DATA_FORMAT_SIGN);
        if (StringTools.isEmpty(sign)) {
            if (!this.rightHave) {
                this.endSignLen = this.defaultSignLen;
            }
            this.buildStream.write(this.defaultSign);
        } else {
            byte[] signBytes = StringTools.escString2Byte(sign);
            if (!this.rightHave) {
                this.endSignLen = signBytes.length;
            }
            this.buildStream.write(signBytes);
        }
    }

    @Override
    public byte[] autoPack(List<Object> list) throws Exception {
        int endIndex = list.size() - 1;
        Object obj = null;
        byte[] value = null;
        for (int i = 0; i < list.size(); ++i) {
            obj = list.get(i);
            if (this.isSimpleType(obj)) {
                value = ByteTools.getBytes(list.get(i), this.getEncoding());
                value = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), value, 1);
                this.buildStream.write(value);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ Auto packaging:{}=[{}]", new Object[]{this.getExecutorName(), i, StringTools.getString(obj, this.getEncoding())});
                }
                if (i == endIndex && !this.rightHave) break;
                this.buildStream.write(this.defaultSign);
                continue;
            }
            if (obj != null) {
                this.logger.warn("{} @ Auto packing: {}, type [{}] is not supported", new Object[]{this.getExecutorName(), i, obj.getClass().getName()});
                continue;
            }
            this.logger.warn("{} @ Auto packing: {}, ignore(value is null)", new Object[]{this.getExecutorName(), i});
        }
        byte[] data = this.buildStream.toByteArray();
        this.buildStream.close();
        return data;
    }

    @Override
    public byte[] unPackItem(Item field, Map<String, String> paras) throws Exception {
        int index;
        String str = paras.get(DATA_FORMAT_SIGN);
        byte[] sign = StringTools.isEmpty(str) ? this.defaultSign : StringTools.escString2Byte(str);
        int signLen = sign.length;
        String fieldlen = paras.get(LEN);
        if (!StringTools.isEmpty(fieldlen)) {
            int nLength = ExecutorHelper.parseItemLen(this.getExecutorName(), field, fieldlen, this.getRootContext(), this.dataLen, this.searchIndex);
            index = ExecutorHelper.searchSeparatorPosition(this.searchIndex + nLength, (byte[])this.getInputData(), sign, this.getEncoding());
        } else {
            index = ExecutorHelper.searchSeparatorPosition(this.searchIndex, (byte[])this.getInputData(), sign, this.getEncoding());
        }
        int len = index - this.searchIndex;
        if (index == this.searchIndex || this.searchIndex > this.dataLen) {
            this.searchIndex += signLen;
            return new byte[0];
        }
        if (index >= this.dataLen - signLen) {
            this.setDataFormatEnd();
        }
        byte[] result = new byte[len];
        System.arraycopy(this.getInputData(), this.searchIndex, result, 0, len);
        this.searchIndex += len + signLen;
        return result;
    }

    @Override
    public List<Object> autoUnpack() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        if (((byte[])this.getInputData()).length == 0) {
            return list;
        }
        boolean boo = true;
        do {
            int index = ExecutorHelper.searchSeparatorPosition(this.searchIndex, (byte[])this.getInputData(), this.defaultSign, this.getEncoding());
            int len = index - this.searchIndex;
            if (index >= this.dataLen - this.defaultSignLen) {
                boo = false;
            }
            byte[] result = new byte[len];
            System.arraycopy(this.getInputData(), this.searchIndex, result, 0, len);
            this.searchIndex += len + this.defaultSignLen;
            result = (byte[])this.invokeMethods(this.getGlobalParseMethod(), result, 1);
            if (this.isStr) {
                list.add(StringTools.getString(result, this.getEncoding()));
                continue;
            }
            list.add(result);
        } while (boo);
        return list;
    }

    @Override
    public int getSearchIndex() {
        if (this.searchIndex >= this.dataLen) {
            return -1;
        }
        return this.searchIndex;
    }
}

