/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DataFormatTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgConvertUtil {
    protected static Logger logger = LoggerFactory.getLogger(MsgConvertUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] packMsg(Map<String, Object> context, String msgpath, String msgtype, String encode) throws Exception {
        AbstractExecutor messageExecutor;
        DataFormat dataFormat = null;
        if (StringTools.isEmpty(msgpath)) {
            if (StringTools.isEmpty(msgtype)) throw new Exception("Message format is not configured");
            if (StringTools.isEmpty(encode)) throw new Exception("Message format is not configured");
            Class<?> clazz = DataFormatRegistry._simpleDataformatRegistry.get(msgtype);
            if (clazz == null) {
                throw new Exception("Message parser [" + msgtype + "] does not exist");
            }
            messageExecutor = (AbstractExecutor)clazz.newInstance();
            messageExecutor.setEncoding(encode);
            dataFormat = DataFormatRegistry.getDataformat(msgtype, encode);
        } else {
            dataFormat = DataFormatTools.loadDataFormat(msgpath);
            if (dataFormat == null) {
                throw new ComponentException("Message format is not configured");
            }
            messageExecutor = DataFormatRegistry.getDataFormatExecutor(dataFormat.getImplClass());
            messageExecutor.setEncoding(dataFormat.getEncoding());
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} @ Packaging, message=[{}]", (Object)messageExecutor.getExecutorName(), (Object)(StringTools.isEmpty(msgpath) ? "Message profile not used" : msgpath));
        }
        messageExecutor.setRootContext(context);
        messageExecutor.setCurrentContext(context);
        messageExecutor.setAutoContext((Map)context.get("__T_AUTOPACK"));
        messageExecutor.pack(dataFormat);
        Object ret = messageExecutor.outputData();
        return ByteTools.getBytes(ret, dataFormat.getEncoding());
    }

    public static Map<String, Object> unpackMsg(byte[] data, Map<String, Object> context, String msgpath, String msgtype, String encode) throws Exception {
        AbstractExecutor messageExecutor;
        DataFormat dataFormat = null;
        if (StringTools.isEmpty(msgpath)) {
            if (StringTools.isEmpty(encode)) {
                throw new Exception("Message ecoding of message format [" + msgtype + "] is not configured");
            }
            Class<?> clazz = DataFormatRegistry._simpleDataformatRegistry.get(msgtype);
            if (clazz == null) {
                if (msgtype.equals("OTHER")) {
                    throw new Exception("Complex message must be configured");
                }
                throw new Exception("Message format [" + msgtype + "] is not configured");
            }
            messageExecutor = (AbstractExecutor)clazz.newInstance();
            messageExecutor.setEncoding(encode);
            dataFormat = DataFormatRegistry.getDataformat(msgtype, encode);
        } else {
            dataFormat = DataFormatTools.loadDataFormat(msgpath);
            if (dataFormat == null) {
                throw new ComponentException("Message definition file [" + msgpath + "] does not exist");
            }
            messageExecutor = DataFormatRegistry.getDataFormatExecutor(dataFormat.getImplClass());
            messageExecutor.setEncoding(dataFormat.getEncoding());
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} @ Unpacking,message=[{}]", (Object)messageExecutor.getExecutorName(), (Object)(StringTools.isEmpty(msgpath) ? "Message profile not used" : msgpath));
        }
        messageExecutor.setRootContext(context);
        messageExecutor.setCurrentContext(context);
        messageExecutor.unPack(dataFormat, data);
        int searchIndex = messageExecutor.getSearchIndex();
        context.put("__T_SEARCHINDEX", searchIndex);
        return messageExecutor.getAutoContext();
    }
}

