/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.out.tcp.TcpOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LongClientOutAdapter
extends TcpOutAdapter {
    private static final String OUT_ADAPTER_NAME = "\u957f\u8fde\u63a5\u5ba2\u6237\u7aef\u63a5\u51fa\u9002\u914d\u5668";
    private static final String beatFromString = "string";
    private static final String beatFromFile = "file";
    protected List<SocketWrapper> requestPool = Collections.synchronizedList(new ArrayList());
    protected String localIP;
    protected String localPort;
    protected String actionType;
    private static final String ONLY_READ = "ONLY_READ";
    protected static final String ONLY_WRITE = "ONLY_WRITE";
    private static final String READ_WRITE = "READ_WRITE";
    private long sessionTimeout = 60000L;
    private boolean heartManageConnection = false;
    private int maxConnection;
    private int interval = 30000;
    private long sessionTime = 0L;
    private boolean connectionProducerFlag = false;
    private boolean autoHeartBeat = false;
    private String heartBeatSrc = "file";
    private String heartBeatMsgFile;
    private byte[] heartBeatMsg = null;
    private int beatInterval;
    private Thread connectionProducerThread = null;
    private Thread heartBeatThread = null;
    protected Thread socketReadThread;
    protected AtomicInteger currentConnection = new AtomicInteger(0);
    private Object mutex = new Object();
    protected Semaphore semaphore;

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (StringTools.isEmpty(this.actionType)) {
            this.actionType = READ_WRITE;
        }
        if (this.maxConnection <= 0) {
            throw new Exception(this.getAdapterName() + " @ Illegal maximum connections [" + this.maxConnection + "]");
        }
        this.semaphore = new Semaphore(this.maxConnection, true);
        this.semaphore.drainPermits();
        this.sessionTime = this.sessionTimeout - 1000L;
        if (this.sessionTime <= 0L) {
            this.sessionTime = 60000L;
        }
        if (this.connectionProducerFlag) {
            this.connectionProducerThread = new Thread((Runnable)new ConnectionProducer(), "ConnectionProducer");
            this.connectionProducerThread.setDaemon(true);
            this.connectionProducerThread.start();
        }
        if (this.autoHeartBeat) {
            if (this.beatInterval <= 0) {
                throw new Exception(this.getAdapterName() + " @ Heartbeat interval [" + this.beatInterval + "] must be greater than 0");
            }
            if (beatFromString.equals(this.heartBeatSrc)) {
                String dataInfo = StringTools.getString(this.heartBeatMsgFile);
                if (dataInfo.startsWith("0x") || dataInfo.startsWith("0X")) {
                    dataInfo = dataInfo.substring(2);
                    this.heartBeatMsg = StringTools.string2Byte(dataInfo);
                } else {
                    this.heartBeatMsg = dataInfo.getBytes();
                }
            } else {
                File file = FileTools.fetchFile(this.heartBeatMsgFile);
                if (file == null || !file.exists()) {
                    this.logger.error("{} @ Heartbeat does not exists: {}", (Object)this.getAdapterName(), (Object)this.heartBeatMsgFile);
                    throw new FileNotFoundException(this.getAdapterName() + " @ Heartbeat does not exists\uff1a" + this.heartBeatMsgFile);
                }
                this.heartBeatMsg = FileTools.readHexFile(this.heartBeatMsgFile);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ The length of heartbeat message to be sent is {} bytes, and the content is:\n{}", new Object[]{this.getAdapterName(), this.heartBeatMsg.length, StringTools.toHexTable(this.heartBeatMsg)});
            }
            this.heartBeatThread = new HeartBeatThread(this.beatInterval);
            this.heartBeatThread.setName(this.getSid() + "-HeartBeatThread");
            this.heartBeatThread.start();
        }
        this.logger.debug("{} @ Start dial-out adapter", (Object)this.getAdapterName());
    }

    @Override
    public IRequest makeRequest(Session session) throws Exception {
        this.initConnection();
        if (!this.alive) {
            throw new Exception("Adapter has already closed");
        }
        boolean acquireFlag = this.semaphore.tryAcquire(this.sessionTime, TimeUnit.MILLISECONDS);
        if (acquireFlag) {
            SocketWrapper wrapper = this.requestPool.remove(0);
            StreamRequest createdRequest = new StreamRequest();
            try {
                createdRequest.setDatasourceWrapper(wrapper);
                if (wrapper.isClose()) {
                    throw new Exception("Connection has already closed");
                }
                createdRequest.setOutAdapter(this);
                if (ONLY_WRITE.equals(this.actionType)) {
                    wrapper.setBis(null);
                } else if (ONLY_READ.equals(this.actionType)) {
                    wrapper.setBos(null);
                } else if (!READ_WRITE.equals(this.actionType)) {
                    throw new Exception("Connection type is not supported [" + this.actionType + "]");
                }
            }
            catch (Throwable e) {
                createdRequest.setCloseFlag(true);
                this.unmakeRequest(createdRequest);
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Exception("Exceprion in creating request", e);
            }
            return createdRequest;
        }
        throw new Exception("Get connection timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() throws Exception {
        while (this.alive && this.currentConnection.get() < this.maxConnection) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.currentConnection.get() >= this.maxConnection) {
                    break;
                }
                try {
                    this.createConnection();
                }
                catch (NullPointerException e) {
                    throw new Exception("Failed to establish the  " + (this.requestPool.size() + 1) + "th  connection", e);
                }
                catch (Exception e) {
                    throw e;
                }
            }
        }
    }

    public SocketWrapper createConnection() throws Exception {
        SocketWrapper wrapper = null;
        try {
            Socket socket = this.createSocket();
            wrapper = new SocketWrapper(socket);
            if (ONLY_WRITE.equals(this.actionType)) {
                this.socketReadThread = new Thread(new SocketReader(wrapper));
                this.socketReadThread.start();
            } else {
                socket.setSoTimeout(this.getTimeout());
            }
            this.requestPool.add(wrapper);
            this.semaphore.release();
            this.currentConnection.incrementAndGet();
        }
        catch (NumberFormatException e) {
            throw new Exception("Host [" + this.getHost() + ":" + this.getPort() + "] parsing exception while creating new connection", e);
        }
        catch (UnknownHostException e) {
            throw new Exception("Unknown host name [" + this.getHost() + "] while creating new connection", e);
        }
        catch (IOException e) {
            throw new Exception("Error communication with host [" + this.getHost() + ":" + this.getPort() + "] when creating new connection", e);
        }
        return wrapper;
    }

    public Socket createSocket() throws Exception {
        Socket socket = new Socket();
        InetSocketAddress socketAddr = new InetSocketAddress(InetAddress.getByName(this.getHost()), Integer.parseInt(this.getPort()));
        if (!StringTools.isEmpty(this.localIP) && !StringTools.isEmpty(this.localPort)) {
            InetSocketAddress localSocketAddr = new InetSocketAddress(InetAddress.getByName(this.localIP), Integer.parseInt(this.localPort));
            socket.bind(localSocketAddr);
        }
        socket.connect(socketAddr, 10000);
        socket.setKeepAlive(true);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        StreamRequest returnRequest = (StreamRequest)request;
        SocketWrapper wrapper = (SocketWrapper)returnRequest.getDatasourceWrapper();
        if (this.isAvalible(returnRequest) && !wrapper.isClose()) {
            this.requestPool.add(wrapper);
            this.semaphore.release();
            this.logger.debug("{} @ Number of licenses after returning the connection: {}, number of connections: {}", new Object[]{this.getAdapterName(), this.semaphore.availablePermits(), this.requestPool.size()});
            this.logger.debug("{} @ return connection [{}] ", (Object)this.getAdapterName(), (Object)wrapper.getSocket());
        } else {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    returnRequest.close();
                    this.currentConnection.decrementAndGet();
                }
                catch (IOException e) {
                    this.logger.error(this.getAdapterName() + " @ Close connection exception :" + wrapper.getSocket(), (Throwable)e);
                }
            }
            this.logger.debug("{} @ Clear unexpected connection [{}] ", (Object)this.getAdapterName(), (Object)wrapper.getSocket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.currentConnection.set(0);
        this.semaphore.drainPermits();
        if (this.connectionProducerFlag && this.connectionProducerThread != null) {
            this.connectionProducerThread.interrupt();
            this.connectionProducerThread = null;
        }
        if (this.autoHeartBeat && this.heartBeatThread != null) {
            this.heartBeatThread.interrupt();
            this.heartBeatMsg = null;
        }
        if (this.socketReadThread != null) {
            this.socketReadThread.interrupt();
            this.socketReadThread = null;
        }
        Object object = this.mutex;
        synchronized (object) {
            for (SocketWrapper wrapper : this.requestPool) {
                Socket socket = wrapper.getSocket();
                try {
                    if (socket == null || socket.isClosed()) continue;
                    socket.close();
                }
                catch (IOException e) {
                    this.logger.error(this.getAdapterName() + " @ Closing remaining connections in connection pool [" + socket + "] exception", (Throwable)e);
                }
            }
            this.requestPool.clear();
        }
        this.logger.debug("{} @ Long connection client dial-out closed", (Object)this.getAdapterName());
    }

    @Override
    public String getAdapterTypeName() {
        return OUT_ADAPTER_NAME;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(long sessionTime) {
        this.sessionTime = sessionTime;
    }

    public boolean isConnectionProducerFlag() {
        return this.connectionProducerFlag;
    }

    public void setConnectionProducerFlag(boolean connectionProducerFlag) {
        this.connectionProducerFlag = connectionProducerFlag;
    }

    public boolean isAutoHeartBeat() {
        return this.autoHeartBeat;
    }

    public void setAutoHeartBeat(boolean autoHeartBeat) {
        this.autoHeartBeat = autoHeartBeat;
    }

    public String getHeartBeatSrc() {
        return this.heartBeatSrc;
    }

    public void setHeartBeatSrc(String heartBeatSrc) {
        this.heartBeatSrc = heartBeatSrc;
    }

    public String getHeartBeatMsgFile() {
        return this.heartBeatMsgFile;
    }

    public void setHeartBeatMsgFile(String heartBeatMsgFile) {
        this.heartBeatMsgFile = heartBeatMsgFile;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public void setLocalIP(String localIP) {
        this.localIP = localIP;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(String localPort) {
        this.localPort = localPort;
    }

    public int getBeatInterval() {
        return this.beatInterval;
    }

    public void setBeatInterval(int beatInterval) {
        this.beatInterval = beatInterval;
    }

    public boolean isHeartManageConnection() {
        return this.heartManageConnection;
    }

    public void setHeartManageConnection(boolean heartManageConnection) {
        this.heartManageConnection = heartManageConnection;
    }

    public class SocketReader
    implements Runnable {
        private SocketWrapper wrapper;

        public SocketReader(SocketWrapper wrapper) {
            this.wrapper = wrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String moduleLog = LongClientOutAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongClientOutAdapter.this.bundlerId, LongClientOutAdapter.this.moduleId, moduleLog, "", "        ", null);
            Socket socket = this.wrapper.getSocket();
            try {
                InputStream in = socket.getInputStream();
                int readCount = in.read();
                while (readCount >= 0) {
                    readCount = in.read();
                }
                this.removeRequest(this.wrapper);
            }
            catch (Exception e) {
                LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Opposite connection closed:" + socket, (Throwable)e);
                this.removeRequest(this.wrapper);
            }
            finally {
                LogbackUtil.removeLogInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRequest(SocketWrapper wrapper) {
            Socket socket = wrapper.getSocket();
            try {
                wrapper.setClose(true);
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (Exception e) {
                LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Close connection [" + socket + "] exception ", (Throwable)e);
            }
            Object object = LongClientOutAdapter.this.mutex;
            synchronized (object) {
                boolean flag = LongClientOutAdapter.this.semaphore.tryAcquire();
                if (flag) {
                    boolean remove = LongClientOutAdapter.this.requestPool.remove(wrapper);
                    if (remove) {
                        LongClientOutAdapter.this.currentConnection.decrementAndGet();
                    } else {
                        LongClientOutAdapter.this.semaphore.release();
                    }
                }
            }
            if (wrapper.getSessionId() != null) {
                LongClientOutAdapter.this.usedRequest.remove(wrapper.getSessionId());
            }
            LongClientOutAdapter.this.logger.debug("{} @ SocketReader clear exception connection [{}]", new Object[]{LongClientOutAdapter.this.getAdapterName(), socket});
        }
    }

    public class HeartBeatThread
    extends Thread {
        private int intervalTime;

        public HeartBeatThread(int intervalTime) {
            this.intervalTime = intervalTime;
        }

        @Override
        public void run() {
            String moduleLog = LongClientOutAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongClientOutAdapter.this.bundlerId, LongClientOutAdapter.this.moduleId, moduleLog, "", "        ", null);
            while (LongClientOutAdapter.this.alive) {
                try {
                    Thread.sleep(this.intervalTime);
                    int count = LongClientOutAdapter.this.semaphore.availablePermits();
                    for (int i = 0; i < count && LongClientOutAdapter.this.semaphore.tryAcquire(); ++i) {
                        SocketWrapper wrapper = LongClientOutAdapter.this.requestPool.remove(0);
                        boolean result = this.sendHeartMessage(wrapper);
                        if (result) {
                            LongClientOutAdapter.this.requestPool.add(wrapper);
                            LongClientOutAdapter.this.semaphore.release();
                            continue;
                        }
                        try {
                            LongClientOutAdapter.this.currentConnection.decrementAndGet();
                            wrapper.getSocket().close();
                            continue;
                        }
                        catch (Throwable e1) {
                            LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Failed to send heartbeat, exception in closing connection [" + wrapper.getSocket() + "] :", e1);
                        }
                    }
                    if (!LongClientOutAdapter.this.isHeartManageConnection()) continue;
                    try {
                        LongClientOutAdapter.this.initConnection();
                    }
                    catch (Exception e) {
                        LongClientOutAdapter.this.logger.error("{} @ Heartbeat attempt to reestablish connection exception: {}", (Object)LongClientOutAdapter.this.getAdapterName(), (Object)e.getMessage());
                    }
                }
                catch (InterruptedException e) {
                    LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Send heartbeat thread interrupt exception ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            LogbackUtil.removeLogInfo();
        }

        private boolean sendHeartMessage(SocketWrapper wrapper) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - wrapper.getLastUsedTime() >= (long)this.intervalTime) {
                wrapper.setLastUsedTime(currentTime);
                Socket socket = wrapper.getSocket();
                try {
                    OutputStream out = socket.getOutputStream();
                    out.write(LongClientOutAdapter.this.heartBeatMsg);
                    out.flush();
                    LongClientOutAdapter.this.logger.debug("{} @ Connect to [{}], heartbeat sending successfully", new Object[]{LongClientOutAdapter.this.getAdapterName(), socket});
                    return true;
                }
                catch (Throwable e) {
                    LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Connect to [" + socket + "], heartbeat sending failed:", e);
                    return false;
                }
            }
            return true;
        }
    }

    public class ConnectionProducer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String moduleLog = LongClientOutAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongClientOutAdapter.this.bundlerId, LongClientOutAdapter.this.moduleId, moduleLog, "", "        ", null);
            String sessionId = "AutoGeneratorID";
            HashMap<String, Object> context = new HashMap<String, Object>();
            Session session = new Session();
            session.setSessionId(sessionId);
            session.setContext(context);
            IRequest request = null;
            try {
                request = LongClientOutAdapter.this.makeRequest(session);
                SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
                request.setSessionId(sessionId);
                wrapper.setSessionId(sessionId);
                LongClientOutAdapter.this.getUsedRequest().put(sessionId, request);
            }
            catch (Exception e) {
                LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Failed to establish connection at startup: ", (Throwable)e);
            }
            finally {
                try {
                    if (request != null) {
                        LongClientOutAdapter.this.returnRequest(request);
                    }
                }
                catch (Exception e) {
                    SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
                    LongClientOutAdapter.this.logger.error(LongClientOutAdapter.this.getAdapterName() + " @ Exception in return connection [" + wrapper.getSocket() + "] :", (Throwable)e);
                }
                LogbackUtil.removeLogInfo();
            }
        }
    }
}

