/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.tcp.TCPInAdapter;
import java.net.Socket;

public class ShortServerInAdapter
extends TCPInAdapter {
    private String IN_ADAPTER_NAME = "\u77ed\u8fde\u63a5\u670d\u52a1\u7aef\u63a5\u5165\u9002\u914d\u5668";
    protected Thread listenerThread;

    @Override
    public IRequest makeRequest() throws Exception {
        Socket socket = this.server.accept();
        if (this.getTimeout() > 0) {
            socket.setSoTimeout(this.timeout);
        }
        SocketWrapper wrapper = new SocketWrapper(socket);
        StreamRequest request = new StreamRequest();
        request.setInAdapter(this);
        request.setDatasourceWrapper(wrapper);
        return request;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.createServerSocket();
        this.listenerThread = new Thread((Runnable)this, this.getSid() + "-" + this.getClass().getSimpleName() + ":" + this.getPort());
        this.listenerThread.start();
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        request.close();
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            if (this.listenerThread != null) {
                this.listenerThread.interrupt();
                this.listenerThread = null;
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ Exception in closing application", (Object)this.getAdapterTypeName(), (Object)e);
        }
        super.doStop();
    }

    @Override
    public String getAdapterTypeName() {
        return this.IN_ADAPTER_NAME;
    }
}

