/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.filter.service.RateLimiting;
import cn.com.yusys.yusp.bsp.resources.spring.CustomPropertyEditorRegistrar;
import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import cn.com.yusys.yusp.bsp.workflow.comm.out.annotation.EnableCommFeign;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={BspBoot.class})
@ConditionalOnProperty(name={"common.bsp.enable"}, matchIfMissing=true)
@EnableCommFeign(basePackages={"cn.com.yusys.yusp"})
public class BspAutoConfiguration {
    public static ApplicationContext applicationContext;
    private static RestTemplate restTemplate;
    private static StringRedisTemplate stringRedisTemplate;
    private static RateLimiting rateLimiting;
    private static CustomEditorConfigurer customEditorConfigurer;

    @Bean(initMethod="startServer", destroyMethod="stopServer")
    public BspBoot registryBspBoot(ApplicationContext applicationContext) {
        FileChecker.getDefaultInstance();
        return new BspBoot(applicationContext);
    }

    @LoadBalanced
    @Bean(value={"restTemplate"})
    public RestTemplate restTemplate() {
        restTemplate = new RestTemplate();
        return restTemplate;
    }

    public static RestTemplate getRestTemplateInstance() {
        return restTemplate;
    }

    @LoadBalanced
    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory factory) {
        stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(factory);
        return stringRedisTemplate;
    }

    public static StringRedisTemplate getStringRedisTemplate() {
        return stringRedisTemplate;
    }

    @LoadBalanced
    @Bean(value={"rateLimiting"})
    public RateLimiting rateLimiting() {
        rateLimiting = new RateLimiting();
        return rateLimiting;
    }

    public static RateLimiting getRateLimiting() {
        return rateLimiting;
    }

    @LoadBalanced
    @Bean(value={"customEditorConfigurer"})
    public CustomEditorConfigurer customEditorConfigurer() {
        customEditorConfigurer = new CustomEditorConfigurer();
        customEditorConfigurer.setPropertyEditorRegistrars(new PropertyEditorRegistrar[]{new CustomPropertyEditorRegistrar()});
        return customEditorConfigurer;
    }

    public static CustomEditorConfigurer getCustomEditorConfigurer() {
        return customEditorConfigurer;
    }
}

