/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.worker;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.dataformat.MsgConvertUtil;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.filter.BspFilterResult;
import cn.com.yusys.yusp.bsp.filter.ExecutionStatus;
import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.reflect.BeanMapUtil;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractWorker;
import cn.com.yusys.yusp.bsp.workflow.worker.IServiceUrl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.TreeSet;
import javax.net.ssl.SSLException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class BizWorker
extends AbstractWorker {
    private RestTemplate restTemplate = BspAutoConfiguration.getRestTemplateInstance();

    @Override
    protected boolean executeJob() throws Throwable {
        Map inMap;
        String tradeValue;
        int remainLen;
        BeanMapUtil util = new BeanMapUtil();
        Map context = this.session.getContext();
        IServiceUrl serviceUrlProcess = this.msgConfig.getServiceUrl();
        AbstractDataProcess dataProcess = this.msgConfig.getDataProcess();
        byte[] recvData = this.processRecv(this.session);
        if (dataProcess != null) {
            recvData = dataProcess.processRecvData(recvData, context);
        }
        Map<String, Object> unpackMap = null;
        int searchIndex = 0;
        if (!StringTools.isEmpty(this.msgConfig.getInputMsgType()) && !this.msgConfig.getInputMsgType().equals("NONE")) {
            unpackMap = MsgConvertUtil.unpackMsg(recvData, context, this.msgConfig.getInputMsgPath(), this.msgConfig.getInputMsgType(), this.msgConfig.getMsgEncode());
            searchIndex = (Integer)context.remove("__T_SEARCHINDEX");
        }
        if (searchIndex > 0 && (remainLen = recvData.length - searchIndex) > 0) {
            byte[] remainData = new byte[remainLen];
            System.arraycopy(recvData, searchIndex, remainData, 0, remainLen);
            recvData = remainData;
        }
        String tradeCode = tradeValue = ExpressTools.getStringValue(this.serviceConfig.getTradeCodeVar(), context);
        ServiceEntity entity = null;
        if ("local".equals(this.serviceConfig.getServiceType())) {
            if (StringTools.isEmpty(tradeValue)) {
                throw new Exception("\u672c\u5730\u670d\u52a1\u8c03\u7528\u65f6\u4ea4\u6613\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            entity = AppStartAssist.get_serviceEntityMap().get(tradeValue);
            if (entity == null) {
                throw new Exception("\u4ea4\u6613[" + tradeValue + "]\u5bf9\u5e94\u5728\u6ce8\u89e3\u4e0d\u5b58\u5728");
            }
            if (!StringTools.isEmpty(entity.getCode())) {
                tradeCode = entity.getCode();
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u83b7\u53d6\u4ea4\u6613\u8bc6\u522b\u7801\uff1a[{}]", (Object)tradeCode);
        }
        String reqMsgType = this.msgConfig.getReqMsgType();
        if (!(searchIndex < 0 || StringTools.isEmpty(tradeCode) || StringTools.isEmpty(reqMsgType) || reqMsgType.equals("NONE"))) {
            String reqMfd = this.msgConfig.getInServicePath() + tradeCode + "_in_req.mfd";
            Map<String, Object> unpackMapBody = MsgConvertUtil.unpackMsg(recvData, context, FileTools.isExist(reqMfd) ? reqMfd : null, this.msgConfig.getReqMsgType(), this.msgConfig.getMsgEncode());
            if (unpackMap == null) {
                unpackMap = unpackMapBody;
            } else {
                unpackMap.putAll(unpackMapBody);
            }
        }
        context.put((String)"__T_AUTOPACK", unpackMap);
        BspFilterResult result = this.executeBspFilter(this.msgConfig.getPreFilter(), context);
        if (result != null) {
            throw result.getException();
        }
        String serviceType = this.serviceConfig.getServiceType();
        if ("local".equals(serviceType)) {
            Object inPara = null;
            inMap = (Map)context.get("__T_AUTOPACK");
            if (inMap == null) {
                inMap = context;
            }
            inPara = util.mapToBean(inMap, entity.getParaType(), entity.getParameterType());
            Object outPara = entity.getMethod().invoke(entity.getBean(), inPara);
            Map<String, Object> outMap = util.beanToMap(outPara);
            context.put((String)"__T_AUTOPACK", outMap);
            context.putAll(outMap);
        } else if ("remote".equals(serviceType)) {
            inMap = (Map)context.get("__T_AUTOPACK");
            if (inMap == null) {
                inMap = context;
            }
            String reqData = util.mapToJson(inMap);
            String url = "";
            url = serviceUrlProcess != null ? serviceUrlProcess.processServiceUrl(context, this.serviceConfig) : (String)OgnlTools.getValue(this.serviceConfig.getServiceName(), context);
            String retData = this.msInvoke(reqData, url);
            Map<String, Object> outMap = util.jsonToMap(retData);
            context.put((String)"__T_AUTOPACK", outMap);
            context.putAll(outMap);
        } else {
            throw new Exception("\u670d\u52a1\u7c7b\u578b[" + serviceType + "]\u4e0d\u652f\u6301");
        }
        result = this.executeBspFilter(this.msgConfig.getPostFilter(), context);
        if (result != null) {
            throw result.getException();
        }
        String respMfd = this.msgConfig.getInServicePath() + tradeCode + "_in_resp.mfd";
        byte[] retData = MsgConvertUtil.packMsg(context, FileTools.isExist(respMfd) ? respMfd : null, this.msgConfig.getRespMsgType(), this.msgConfig.getMsgEncode());
        if (dataProcess != null) {
            retData = dataProcess.processSendData(retData, context);
        }
        this.processSend(this.session, retData);
        return true;
    }

    private BspFilterResult executeBspFilter(TreeSet<BspFilter> preFilter, Map<String, Object> context) {
        for (BspFilter bspFilter : preFilter) {
            try {
                BspFilterResult result = bspFilter.runFilter(context);
                if (result.getResult()) continue;
                return result;
            }
            catch (Exception e) {
                BspFilterResult result = new BspFilterResult(ExecutionStatus.FAILED);
                result.setException(e);
                return result;
            }
        }
        return null;
    }

    private String msInvoke(String reqData, String url) throws Exception {
        if (StringTools.isEmpty(url)) {
            throw new Exception("\u5fae\u670d\u52a1\u8c03\u7528 @ \u8bf7\u6c42URL\u4e3a\u7a7a");
        }
        if (!url.startsWith("http://")) {
            url = "http://" + url;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("Accept", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)reqData, (MultiValueMap)headers);
        logger.info("\u5fae\u670d\u52a1\u8c03\u7528 @ \u8bf7\u6c42URL[{}]", (Object)url);
        logger.info("\u5fae\u670d\u52a1\u8c03\u7528 @ \u53d1\u9001\u6570\u636e:\n{}", (Object)reqData);
        ResponseEntity ret = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        logger.info("\u5fae\u670d\u52a1\u8c03\u7528 @ \u63a5\u6536\u6570\u636e:\n{}", ret.getBody());
        return (String)ret.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] processRecv(Session session) throws Exception {
        Map<String, Object> context = session.getContext();
        StreamRequest srt = (StreamRequest)session.getInRequest();
        Socket socket = this.parseDatasourceWrapper(srt);
        IComm comm = session.getComm();
        if (socket != null && comm != null) {
            try {
                byte[] byArray = comm.processRecv(context, srt);
                return byArray;
            }
            finally {
                if (!srt.isTimeStart()) {
                    srt.setTimeStart(true);
                    session.setTradeStartTime(System.currentTimeMillis());
                }
            }
        }
        throw new ComponentException("\u901a\u8baf\u914d\u7f6e\u672a\u5b9a\u4e49");
    }

    protected Socket parseDatasourceWrapper(StreamRequest srt) throws Exception {
        Object o = srt.getDatasourceWrapper();
        Socket socket = null;
        if (o instanceof SocketWrapper) {
            socket = ((SocketWrapper)o).getSocket();
        } else if (o instanceof Socket) {
            socket = (Socket)o;
        } else {
            throw new Exception("StreamRequest\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u7c7b\u578b[" + o.getClass().getName() + "]");
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean f5Check() {
        IRequest request = this.session.getInRequest();
        if (request.getRequestType() == 1) {
            StreamRequest streamRequest = (StreamRequest)request;
            Object datasourceWrapper = streamRequest.getDatasourceWrapper();
            SocketWrapper socketWrapper = null;
            if (datasourceWrapper instanceof SocketWrapper) {
                socketWrapper = (SocketWrapper)datasourceWrapper;
                if (!socketWrapper.isFirst()) {
                    return false;
                }
            } else {
                return false;
            }
            socketWrapper.setFirst(false);
            Socket socket = socketWrapper.getSocket();
            int timeout = -1;
            try {
                timeout = socket.getSoTimeout();
                socket.setSoTimeout(10000);
                if (this.f5Check(socketWrapper)) {
                    request.setCloseFlag(true);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.setSoTimeout(timeout);
                }
                catch (SocketException socketException) {}
            }
        }
        return false;
    }

    private boolean f5Check(SocketWrapper socketWrapper) throws IOException {
        BufferedInputStream bis = socketWrapper.getBis();
        bis.mark(1);
        int c = -1;
        try {
            c = bis.read();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        if (c == -1) {
            logger.debug("\u63a2\u6d4b\u5305\u68c0\u6d4b:{}", (Object)socketWrapper.getSocket());
            return true;
        }
        bis.reset();
        return false;
    }
}

