/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.worker;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.dataformat.MsgConvertUtil;
import cn.com.yusys.yusp.bsp.resources.ExceptionAnalyzer;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.log.Slf4jSpanLogger;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.config.ServiceConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.IWorker;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorker
implements IWorker {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWorker.class);
    private static final Logger f5Logger = LoggerFactory.getLogger((String)"cn.com.yusys.yusp.bsp.workflow.worker.F5Logger");
    protected Session session;
    protected MsgConfig msgConfig;
    protected ServiceConfig serviceConfig;
    protected String publicIn;
    protected String publicOut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Slf4jSpanLogger spanLogger = new Slf4jSpanLogger();
        spanLogger.logStartedSpan(this.session.getSpan(), this.session.getSpan());
        if (this.session.getInRequest().isTimeStart()) {
            this.session.setTradeStartTime(System.currentTimeMillis());
        }
        try {
            if (this.session.isF5Check() && this.f5Check()) {
                return;
            }
            logger.info("\u4ea4\u6613\u5f00\u59cb");
            this.executeJob();
        }
        catch (IOException e) {
            logger.error("\u4ea4\u6613\u5f02\u5e38", (Throwable)e);
            this.session.getInRequest().setCloseFlag(true);
        }
        catch (Throwable t) {
            logger.error("\u4ea4\u6613\u5f02\u5e38", t);
            this.session.getInRequest().setCloseFlag(true);
            ExceptionAnalyzer.setContextExceptionInfos(this.session, t, null);
            if (!StringTools.isEmpty(this.msgConfig.getInErrorPath())) {
                try {
                    this.session.getContext().remove("__T_AUTOPACK");
                    byte[] retData = MsgConvertUtil.packMsg(this.session.getContext(), this.msgConfig.getInErrorPath(), this.msgConfig.getRespMsgType(), this.msgConfig.getMsgEncode());
                    this.processSend(this.session, retData);
                }
                catch (Exception e) {
                    logger.warn("\u9519\u8bef\u5904\u7406\u5f02\u5e38", (Object)e.getMessage());
                }
            }
        }
        finally {
            if (this.session != null) {
                this.session.destory();
            }
        }
        long endtime = System.currentTimeMillis();
        this.session.setTradeEndTime(endtime);
        logger.info("\u4ea4\u6613\u7ed3\u675f,\u7528\u65f6[{}]\u6beb\u79d2", (Object)(endtime - this.session.getTradeStartTime()));
        spanLogger.logStoppedSpan();
    }

    protected void processSend(Session session, byte[] data) throws Exception {
        Map<String, Object> context = session.getContext();
        StreamRequest srt = (StreamRequest)session.getInRequest();
        IComm comm = session.getComm();
        comm.processSend(context, data, srt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean f5Check() {
        IRequest request = this.session.getInRequest();
        if (request.getRequestType() == 1) {
            StreamRequest streamRequest = (StreamRequest)request;
            Object datasourceWrapper = streamRequest.getDatasourceWrapper();
            SocketWrapper socketWrapper = null;
            if (datasourceWrapper instanceof SocketWrapper) {
                socketWrapper = (SocketWrapper)datasourceWrapper;
                if (!socketWrapper.isFirst()) {
                    return false;
                }
            } else {
                return false;
            }
            socketWrapper.setFirst(false);
            Socket socket = socketWrapper.getSocket();
            int timeout = -1;
            try {
                timeout = socket.getSoTimeout();
                socket.setSoTimeout(10000);
                if (this.f5Check(socketWrapper)) {
                    request.setCloseFlag(true);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.setSoTimeout(timeout);
                }
                catch (SocketException socketException) {}
            }
        }
        return false;
    }

    private boolean f5Check(SocketWrapper socketWrapper) throws IOException {
        BufferedInputStream bis = socketWrapper.getBis();
        bis.mark(1);
        int c = bis.read();
        if (c == -1) {
            f5Logger.debug("\u63a2\u6d4b\u5305\u68c0\u6d4b:{}", (Object)socketWrapper.getSocket());
            return true;
        }
        bis.reset();
        return false;
    }

    protected abstract boolean executeJob() throws Throwable;

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void setPublicIn(String publicIn) {
        this.publicIn = publicIn;
    }

    @Override
    public String getPublicIn() {
        return this.publicIn;
    }

    @Override
    public String getPublicOut() {
        return this.publicOut;
    }

    @Override
    public void setPublicOut(String publicOut) {
        this.publicOut = publicOut;
    }

    public MsgConfig getMsgConfig() {
        return this.msgConfig;
    }

    public void setMsgConfig(MsgConfig msgConfig) {
        this.msgConfig = msgConfig;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }
}

