/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FixCommOut
extends AbstractCommOut {
    protected String unitName = "\u5b9a\u957f\u901a\u8baf\u63a5\u51fa";
    protected static final String HEADER_DATA_INT = "Integer";
    protected static final String HEADER_DATA_SHORT = "Short";
    protected static final String HEADER_DATA_STR = "String";
    protected static final String HEADER_DATA_BYTE = "Byte";
    private String headerType;
    private String containSelf;
    private String headerLenStr;

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        int startLen;
        StreamRequest streamRequest = (StreamRequest)request;
        DataOutputStream dos = new DataOutputStream(streamRequest.getSocketWrapper().getBos());
        String headerType = this.getInExpressStringValue(this.headerType, "headerType", context);
        boolean containSelf = this.getInExpressBooleanValue(this.containSelf, "containSelf", context);
        int tempLen = startLen = bsend.length;
        try {
            if (HEADER_DATA_SHORT.equals(headerType)) {
                if (containSelf) {
                    tempLen += 2;
                }
                dos.writeShort(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ \u53d1\u9001\u5305\u5934\u6570\u636e[2]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 4))});
                }
            } else if (HEADER_DATA_INT.equals(headerType)) {
                if (containSelf) {
                    tempLen += 4;
                }
                dos.writeInt(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ \u53d1\u9001\u5305\u5934\u6570\u636e[4]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 8))});
                }
            } else if (HEADER_DATA_BYTE.equals(headerType)) {
                if (containSelf) {
                    ++tempLen;
                }
                dos.writeByte(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ \u53d1\u9001\u5305\u5934\u6570\u636e[1]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 2))});
                }
            } else if (HEADER_DATA_STR.equals(headerType)) {
                String headerLenStr = this.getInExpressStringValue(this.headerLenStr, "headerLenStr", context);
                if (StringUtils.isEmpty((CharSequence)headerLenStr)) {
                    throw new ComponentException("\u5305\u5934\u957f\u5ea6\u4e3a\u7a7a");
                }
                int headerLen = 0;
                try {
                    headerLen = Integer.parseInt(headerLenStr);
                }
                catch (Exception e) {
                    throw new ComponentException("\u5305\u5934\u957f\u5ea6:" + headerLenStr + "\u4e0d\u662f\u6570\u5b57");
                }
                if (headerLen <= 0) {
                    throw new ComponentException("\u5305\u5934\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0");
                }
                if (containSelf) {
                    tempLen += headerLen;
                }
                String sLen = String.valueOf(tempLen);
                StringBuilder sHeaderLen = new StringBuilder();
                int fillLen = headerLen - sLen.length();
                for (int i = 0; i < fillLen; ++i) {
                    sHeaderLen.append('0');
                }
                sHeaderLen.append(sLen);
                dos.write(sHeaderLen.toString().getBytes());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ \u53d1\u9001\u5305\u5934\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), headerLen, StringTools.toHexTable(sHeaderLen.toString().getBytes())});
                }
            } else {
                throw new Exception(this.getUnitName() + " @ \u53d1\u9001\u6570\u636e,\u5305\u5934\u6570\u636e\u7c7b\u578b[" + headerType + "]\u4e0d\u6b63\u786e!");
            }
            this.sendMessageData(dos, bsend);
            dos.flush();
        }
        catch (Exception e) {
            throw new Exception(this.getUnitName() + " @ \u53d1\u9001\u6570\u636e\u5f02\u5e38", e);
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataInputStream dis = new DataInputStream(streamRequest.getSocketWrapper().getBis());
        int nHeaderLen = 0;
        String headerType = this.getInExpressStringValue(this.headerType, "headerType", context);
        boolean containSelf = this.getInExpressBooleanValue(this.containSelf, "containSelf", context);
        if (HEADER_DATA_SHORT.equals(headerType)) {
            nHeaderLen = dis.readShort();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ \u63a5\u6536\u5305\u5934\u6570\u636e[2]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 4))});
            }
            if (containSelf) {
                nHeaderLen -= 2;
            }
        } else if (HEADER_DATA_INT.equals(headerType)) {
            nHeaderLen = dis.readInt();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ \u63a5\u6536\u5305\u5934\u6570\u636e[4]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 8))});
            }
            if (containSelf) {
                nHeaderLen -= 4;
            }
        } else if (HEADER_DATA_BYTE.equals(headerType)) {
            nHeaderLen = dis.readByte();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ \u63a5\u6536\u5305\u5934\u6570\u636e[1]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 2))});
            }
            if (containSelf) {
                --nHeaderLen;
            }
        } else if (HEADER_DATA_STR.equals(headerType)) {
            String headerLenStr = this.getInExpressStringValue(this.headerLenStr, "headerLenStr", context);
            if (StringUtils.isEmpty((CharSequence)headerLenStr)) {
                throw new ComponentException("\u5305\u5934\u957f\u5ea6\u4e3a\u7a7a");
            }
            int headerLen = 0;
            try {
                headerLen = Integer.parseInt(headerLenStr);
            }
            catch (Exception e) {
                throw new ComponentException("\u5305\u5934\u957f\u5ea6:" + headerLenStr + "\u4e0d\u662f\u6570\u5b57");
            }
            if (headerLen <= 0) {
                throw new ComponentException("\u5305\u5934\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0");
            }
            byte[] dataLen = new byte[headerLen];
            dis.readFully(dataLen);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ \u63a5\u6536\u5305\u5934\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), headerLen, StringTools.toHexTable(dataLen)});
            }
            nHeaderLen = Integer.parseInt(new String(dataLen).trim());
            if (containSelf) {
                nHeaderLen -= headerLen;
            }
        } else {
            throw new ComponentException("\u63a5\u6536\u6570\u636e,\u5305\u5934\u6570\u636e\u7c7b\u578b[" + headerType + "]\u4e0d\u6b63\u786e!");
        }
        if ((long)nHeaderLen > 0xA00000L) {
            throw new ComponentException("\u7533\u8bf7\u7f13\u51b2\u533a\u8fc7\u5927:" + nHeaderLen + " recv failed");
        }
        if (nHeaderLen < 0) {
            throw new ComponentException("\u5305\u5934\u957f\u5ea6\u975e\u6cd5:" + nHeaderLen);
        }
        byte[] recv = new byte[nHeaderLen];
        if (nHeaderLen > 0) {
            this.recvMessageData(dis, recv);
        }
        return recv;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public String getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public String getContainSelf() {
        return this.containSelf;
    }

    public void setContainSelf(String containSelf) {
        this.containSelf = containSelf;
    }

    public String getHeaderLenStr() {
        return this.headerLenStr;
    }

    public void setHeaderLenStr(String headerLenStr) {
        this.headerLenStr = headerLenStr;
    }
}

