/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.el.ognl;

import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ASTChain;
import ognl.ASTProperty;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlEnhanceUtils {
    private static Logger logger = LoggerFactory.getLogger(OgnlEnhanceUtils.class);
    private static Map<String, Boolean> exprResultMap = new ConcurrentHashMap<String, Boolean>();

    public static Object getValue(String expr, Node ac, Map<String, Object> contextRoot) throws Exception {
        Boolean isSimpleExpr = true;
        int childrenCount = ac.jjtGetNumChildren();
        Boolean bSimple = exprResultMap.get(expr);
        if (bSimple != null) {
            isSimpleExpr = bSimple;
        } else {
            if (!(ac instanceof ASTProperty) && !(ac instanceof ASTChain)) {
                isSimpleExpr = false;
            } else if (childrenCount > 0) {
                for (int i = 0; i < childrenCount; ++i) {
                    if (ac.jjtGetChild(i) instanceof ASTProperty) continue;
                    isSimpleExpr = false;
                    break;
                }
            } else if (!(ac instanceof ASTProperty)) {
                isSimpleExpr = false;
            }
            exprResultMap.put(expr, isSimpleExpr);
        }
        if (!isSimpleExpr.booleanValue()) {
            OgnlContext ognlContext = OgnlTools.getOgnlContext(contextRoot);
            return Ognl.getValue((Object)ac, (Map)ognlContext, contextRoot);
        }
        if (ac instanceof ASTProperty) {
            return contextRoot.get(expr);
        }
        Map context = contextRoot;
        int lastIndex = OgnlEnhanceUtils.getLastNonArrayIndex(ac);
        boolean lastIsArray = lastIndex != childrenCount - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            boolean isVar = i == lastIndex;
            Node n = ac.jjtGetChild(i);
            Node nn = isVar && !lastIsArray ? null : ac.jjtGetChild(i + 1);
            String cName = n.toString();
            ASTProperty np = (ASTProperty)nn;
            Object obj = context.get(cName);
            if (obj == null) {
                return null;
            }
            if (nn == null || !np.isIndexedAccess()) {
                if (isVar) {
                    return obj;
                }
                if (!(obj instanceof Map)) {
                    isSimpleExpr = false;
                    break;
                }
                context = (Map)obj;
                continue;
            }
            ASTProperty na = np;
            Object objArr = obj;
            int ai = 1;
            while (i <= childrenCount - 2) {
                Node nt;
                ++i;
                boolean isList = true;
                if (objArr instanceof List) {
                    isList = true;
                } else if (objArr instanceof byte[] || objArr instanceof short[] || objArr instanceof char[] || objArr instanceof int[] || objArr instanceof long[] || objArr instanceof float[] || objArr instanceof double[] || objArr instanceof Object[]) {
                    isList = false;
                } else {
                    throw new Exception("\u53d8\u91cf [" + cName + "] \u5e76\u975e\u5408\u6cd5\u7684\u6570\u7ec4\u7c7b\u578b\uff08\u7b2c" + ai + "\u7ef4\u5e76\u975e\u6570\u7ec4\uff09\uff1a" + obj.getClass().getName());
                }
                int index = 0;
                try {
                    String idxExpr = na.jjtGetChild(0).toString();
                    Object value = OgnlTools.getValue(idxExpr, contextRoot);
                    index = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new Exception("\u6307\u5b9a\u7684\u6570\u7ec4\u7b2c " + ai + " \u4e0b\u6807\u4e0d\u662f\u6574\u578b\u503c\uff1a" + na.jjtGetChild(0).toString());
                }
                if (isList) {
                    List list = (List)objArr;
                    if (list.size() <= index) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("\u6570\u7ec4 [" + cName + "] \u7684\u7b2c " + ai + "\u7ef4\u4e0b\u6807\u8d8a\u754c\uff0c\u6700\u5927\uff1a" + (list.size() - 1) + "\uff0c\u5b9e\u9645index\uff1a" + index);
                        }
                        return null;
                    }
                    objArr = list.get(index);
                } else {
                    int al = Array.getLength(objArr);
                    if (al <= index) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("\u6570\u7ec4 [" + cName + "] \u7684\u7b2c " + ai + "\u7ef4\u4e0b\u6807\u8d8a\u754c\uff0c\u6700\u5927\uff1a" + (al - 1) + "\uff0c\u5b9e\u9645index\uff1a" + index);
                        }
                        return null;
                    }
                    objArr = Array.get(objArr, index);
                }
                if (i > childrenCount - 2 || (nt = ac.jjtGetChild(i + 1)) == null || !((ASTProperty)nt).isIndexedAccess()) break;
                ++ai;
                na = (ASTProperty)nt;
            }
            if (isVar) {
                return objArr;
            }
            if (!(objArr instanceof Map)) {
                isSimpleExpr = false;
                break;
            }
            context = (Map)objArr;
        }
        if (isSimpleExpr.booleanValue()) {
            return null;
        }
        OgnlContext ognlContext = OgnlTools.getOgnlContext(contextRoot);
        return Ognl.getValue((Object)ac, (Map)ognlContext, contextRoot);
    }

    public static void setValue(String expr, Node ac, Object value, Map<String, Object> contextRoot) throws Exception {
        if (ac instanceof ASTChain) {
            OgnlEnhanceUtils.setValue(contextRoot, (ASTChain)ac, value);
        } else if (ac instanceof ASTProperty) {
            OgnlEnhanceUtils.setValue(contextRoot, expr, value);
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684ognl\u8d4b\u503c\u7c7b\u578b\uff1a" + ac.getClass().getName());
        }
    }

    private static void setValue(Map<String, Object> contextRoot, String expr, Object value) throws Exception {
        contextRoot.put(expr, value);
    }

    private static void setValue(Map<String, Object> contextRoot, ASTChain ac, Object value) throws Exception {
        Map<String, Object> context = contextRoot;
        int childrenCount = ac.jjtGetNumChildren();
        int lastIndex = OgnlEnhanceUtils.getLastNonArrayIndex((Node)ac);
        boolean lastIsArray = lastIndex != childrenCount - 1;
        block2: for (int i = 0; i <= lastIndex; ++i) {
            boolean isVar = i == lastIndex;
            Node n = ac.jjtGetChild(i);
            Node nn = isVar && !lastIsArray ? null : ac.jjtGetChild(i + 1);
            String cName = n.toString();
            if (!(n instanceof ASTProperty) || nn != null && !(nn instanceof ASTProperty)) break;
            ASTProperty np = (ASTProperty)nn;
            if (nn == null || !np.isIndexedAccess()) {
                if (isVar) {
                    context.put(cName, value);
                    continue;
                }
                HashMap obj = context.get(cName);
                if (obj == null || !(obj instanceof Map)) {
                    obj = new HashMap();
                    context.put(cName, obj);
                }
                context = obj;
                continue;
            }
            ASTProperty na = np;
            ArrayList objArr = context.get(cName);
            int ai = 1;
            while (i <= childrenCount - 2) {
                HashMap<String, Object> next;
                List<ArrayList<Object>> list;
                boolean nextIsArray = false;
                Node nt = null;
                if (++i <= childrenCount - 2) {
                    nt = ac.jjtGetChild(i + 1);
                    nextIsArray = nt != null && ((ASTProperty)nt).isIndexedAccess();
                }
                int index = 0;
                try {
                    String idxExpr = na.jjtGetChild(0).toString();
                    Object v = OgnlTools.getValue(idxExpr, (Map<String, Object>)contextRoot);
                    index = v instanceof Number ? ((Number)v).intValue() : Integer.parseInt(v.toString());
                }
                catch (NumberFormatException e) {
                    throw new Exception("\u6307\u5b9a\u7684\u6570\u7ec4\u4e0b\u6807\u4e0d\u662f\u6574\u578b\u503c\uff1a" + np.jjtGetChild(0).toString());
                }
                if (objArr == null) {
                    if (index != 0) {
                        throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a0\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                    }
                    if (nextIsArray) {
                        list = new ArrayList<Object>();
                        context.put(cName, list);
                        ArrayList list2 = new ArrayList();
                        list.add(index, list2);
                        objArr = list2;
                    } else if (isVar) {
                        list = new ArrayList();
                        list.add((ArrayList<Object>)value);
                        context.put(cName, list);
                    } else {
                        list = new ArrayList();
                        next = new HashMap<String, Object>();
                        list.add((ArrayList<Object>)((Object)next));
                        context.put(cName, list);
                        context = next;
                    }
                } else if (nextIsArray) {
                    List l = new ArrayList();
                    ArrayList list2 = null;
                    if (objArr instanceof List) {
                        list2 = objArr;
                        if (index > list2.size()) {
                            throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a" + list2.size() + "\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                        }
                        if (index <= list2.size() - 1) {
                            Object o = list2.get(index);
                            if (o instanceof List) {
                                l = (List)o;
                            } else {
                                l.add(list2.remove(index));
                                list2.add(index, l);
                            }
                        } else {
                            list2.add(index, l);
                        }
                    } else {
                        if (index > 1) {
                            throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a0\u62161\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                        }
                        list2 = new ArrayList();
                        list2.add(objArr);
                        if (ai != 1) {
                            throw new Exception("\u6570\u7ec4[" + cName + "]\u7684\u7b2c" + (ai - 1) + "\u7ef4\u5143\u7d20\u4e0d\u662f\u6570\u7ec4\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u7c7b\u578b");
                        }
                        context.put(cName, list2);
                        list2.add(index, l);
                    }
                    objArr = l;
                } else if (isVar) {
                    list = null;
                    if (objArr instanceof List) {
                        list = objArr;
                        if (index > list.size()) {
                            throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a" + list.size() + "\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                        }
                    } else {
                        if (index > 1) {
                            throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a0\u62161\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                        }
                        list = new ArrayList();
                        list.add(objArr);
                        if (ai == 1) {
                            context.put(cName, list);
                        } else {
                            ((List)objArr).add(list);
                        }
                    }
                    list.add(index, (ArrayList<Object>)value);
                } else if (objArr instanceof Map) {
                    if (index > 1) {
                        throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a0\u62161\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                    }
                    list = new ArrayList();
                    list.add((ArrayList<Object>)((Object)((Map)((Object)objArr))));
                    if (ai == 1) {
                        context.put(cName, list);
                    } else {
                        ((List)objArr).add(list);
                    }
                    if (index == 0) {
                        context = (Map)((Object)objArr);
                    } else if (index == 1) {
                        next = new HashMap();
                        list.add((ArrayList<Object>)((Object)next));
                        context = next;
                    }
                } else if (objArr instanceof List) {
                    list = objArr;
                    if (index > list.size()) {
                        throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u4e0b\u6807\u5fc5\u987b\u8fde\u7eed\uff08\u671f\u671b\u503c\u4e3a" + list.size() + "\uff0c\u5b9e\u9645\u503c\u4e3a" + index + "\uff09");
                    }
                    if (index == list.size()) {
                        next = new HashMap();
                        list.add((ArrayList<Object>)((Object)next));
                        context = next;
                    } else {
                        Object obj = list.get(index);
                        if (!(obj instanceof Map)) {
                            throw new Exception("\u6570\u7ec4[" + cName + "]\u7b2c" + ai + "\u7ef4\u7684\u503c\u5e76\u4e0d\u662f\u5408\u6cd5\u7684\u53d8\u91cf\u7ec4");
                        }
                        context = (Map)obj;
                    }
                } else {
                    throw new Exception("\u4e0d\u5141\u8bb8\u5c06 [" + objArr.getClass().getName() + "] \u7c7b\u578b\u7684\u53d8\u91cf [" + cName + " \u7b2c" + ai + "\u7ef4] \u8f6c\u6362\u4e3a\u6570\u7ec4");
                }
                if (i > childrenCount - 2 || !nextIsArray) continue block2;
                ++ai;
                na = (ASTProperty)nt;
            }
        }
    }

    private static int getLastNonArrayIndex(Node ac) {
        int childrenCount = ac.jjtGetNumChildren();
        int lastIndex = childrenCount - 1;
        Node node = null;
        for (int i = childrenCount - 1; i >= 0 && (node = ac.jjtGetChild(i)) instanceof ASTProperty && ((ASTProperty)node).isIndexedAccess(); --i) {
            lastIndex = i - 1;
        }
        return lastIndex;
    }
}

