/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.sn;

import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.resources.sn.AbstractSnGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnGenerator
extends AbstractSnGenerator {
    private static final long serialVersionUID = 410808082875719635L;
    private static final Logger logger = LoggerFactory.getLogger(FileSnGenerator.class);
    protected File snFile;
    protected String fileName = "key.ser";

    @Override
    public void saveSn() throws ResourceException {
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(this.snFile));
            fos.write(String.valueOf(this.nextSaveSn).getBytes());
            fos.flush();
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("\u6d41\u6c34\u53f7\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        catch (IOException e) {
            throw new ResourceException("\u4fdd\u5b58\u6d41\u6c34\u53f7\u5230\u6587\u4ef6\u5931\u8d25", e);
        }
        catch (Throwable e) {
            throw new ResourceException("\u4fdd\u5b58\u6d41\u6c34\u53f7\u5230\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.init(Thread.currentThread().getName());
    }

    @Override
    public void doStop() throws Exception {
        this.nextSaveSn = this.currentSn;
        this.saveSn();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String bundlerId) throws Exception {
        String rootPath = VarDef.BSP_WORKSPACE_COMMONCONFIG + "/sn/";
        String snPath = rootPath + this.getBundlerId().replaceAll("[.]", "/");
        File snDir = new File(snPath);
        if (!snDir.isDirectory()) {
            snDir.mkdirs();
        }
        this.snFile = new File(snPath + "/" + this.fileName);
        if (this.formatStr == null || this.formatStr.length() == 0) {
            this.formatStr = "00000000";
        }
        this.format = new DecimalFormat(this.formatStr);
        if (this.snFile.exists()) {
            try (FileInputStream fis = null;){
                fis = new FileInputStream(this.snFile);
                byte[] bsn = new byte[fis.available()];
                fis.read(bsn);
                this.currentSn = Long.parseLong(new String(bsn).trim());
            }
        } else {
            this.currentSn = this.minValue;
        }
        if (this.currentSn >= this.maxValue) {
            this.currentSn = this.minValue;
        }
        this.nextSaveSn = this.currentSn + (long)this.interval;
        if (this.nextSaveSn > this.maxValue) {
            this.nextSaveSn = this.maxValue;
        }
        this.saveSn();
    }
}

