/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.sn;

import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.core.AbstractBean;
import cn.com.yusys.yusp.bsp.resources.sn.ISnGenerator;
import java.text.DecimalFormat;

public abstract class AbstractSnGenerator
extends AbstractBean
implements ISnGenerator {
    private static final long serialVersionUID = 5951485943811051889L;
    protected String formatStr = "00000000";
    protected DecimalFormat format = new DecimalFormat(this.formatStr);
    protected int interval = 100;
    protected long currentSn;
    protected long nextSaveSn;
    protected long maxValue;
    protected long minValue;

    @Override
    public synchronized String getNextSn() throws ResourceException {
        String ret = this.format.format(this.currentSn);
        if (this.currentSn >= this.maxValue) {
            this.currentSn = this.minValue;
            this.nextSaveSn = this.currentSn + (long)this.interval;
            this.saveSn();
        } else if (this.currentSn == this.nextSaveSn) {
            this.nextSaveSn += (long)this.interval;
            if (this.nextSaveSn > this.maxValue) {
                this.nextSaveSn = this.maxValue;
            }
            this.saveSn();
        }
        ++this.currentSn;
        return ret;
    }

    @Override
    public synchronized void resetSn() throws ResourceException {
        this.currentSn = this.minValue;
        this.nextSaveSn = this.currentSn + (long)this.interval;
        this.saveSn();
    }

    @Override
    public void doStart() throws Exception {
        this.setBundlerId(Thread.currentThread().getName());
    }

    @Override
    public synchronized String getCurrentSn() throws ResourceException {
        return this.format.format(this.currentSn);
    }

    public String getFormatStr() {
        return this.formatStr;
    }

    public void setFormatStr(String formatStr) {
        this.formatStr = formatStr;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }
}

