/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.creator.IResourceCreator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ResourceCreator {
    private static Map<String, IResourceCreator> _creatorRegistry = new HashMap<String, IResourceCreator>();

    public static void addCreator(IResourceCreator creator) {
        _creatorRegistry.put(creator.getResourceType(), creator);
    }

    public static Object createResource(String fileType, String resource) throws ResourceException {
        if (fileType == null) {
            throw new ResourceException("\u53c2\u6570\u975e\u6cd5\uff0c\u53c2\u6570\u540d\u79f0\uff1afileType\uff0c\u53c2\u6570\u503c\uff1a" + fileType);
        }
        if (resource == null) {
            throw new ResourceException("\u53c2\u6570\u975e\u6cd5\uff0c\u53c2\u6570\u540d\u79f0\uff1aresource\uff0c\u53c2\u6570\u503c\uff1a" + resource);
        }
        try {
            IResourceCreator creator = _creatorRegistry.get(fileType);
            if (creator == null) {
                throw new ResourceException("\u672a\u627e\u5230\u5408\u9002\u7684\u8d44\u6e90\u52a0\u8f7d\u5668\uff1a" + fileType);
            }
            if ("mpd".equals(fileType)) {
                return creator.createResource(resource);
            }
            if ("mfd".equals(fileType)) {
                return creator.createResource(resource);
            }
            File resourceFile = new File(resource);
            if (!resourceFile.isFile()) {
                throw new ResourceException("\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + resource);
            }
            return creator.createResource(resourceFile);
        }
        catch (Exception e) {
            throw new ResourceException("\u521b\u5efa\u8d44\u6e90\u5f02\u5e38\uff0c\u8d44\u6e90\u7c7b\u578b\uff1a" + fileType + "\uff0c\u8d44\u6e90\uff1a" + resource, e);
        }
    }
}

