/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.filter.impl;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class IdempotencyVerifyFilter
extends BspFilter {
    private static final long REDIS_ACTIVE = 1000L;
    private String redisActive;
    private String keyVar;

    @Override
    public boolean run(Map<String, Object> context) throws Exception {
        String keyVarStr = (String)ExpressTools.getValue(this.keyVar, context);
        String redisActiveStr = (String)ExpressTools.getValue(this.redisActive, context);
        long timeout = 1000L;
        try {
            timeout = Long.parseLong(redisActiveStr);
        }
        catch (NumberFormatException e) {
            this.logger.warn("\u95f4\u9694\u65f6\u95f4[{}]\u8bbe\u7f6e\u65e0\u6548,\u4f7f\u7528\u9ed8\u8ba4\u503c[{}]", new Object[]{redisActiveStr, timeout, e});
        }
        if (!StringTools.isEmpty(keyVarStr)) {
            StringRedisTemplate stringRedisTemplate = BspAutoConfiguration.getStringRedisTemplate();
            if (stringRedisTemplate == null) {
                context.put("G_EXCEPTION_CODE", "9001");
                this.logger.error("REDIS\u521d\u59cb\u5316\u5f02\u5e38");
                throw new ComponentException("REDIS\u521d\u59cb\u5316\u5f02\u5e38");
            }
            if (stringRedisTemplate.hasKey((Object)keyVarStr).booleanValue()) {
                context.put("G_EXCEPTION_CODE", "9000");
                this.logger.error("\u91cd\u590d\u53d1\u9001\u4ea4\u6613[{}]", (Object)keyVarStr);
                throw new ComponentException("\u91cd\u590d\u53d1\u9001\u4ea4\u6613[" + keyVarStr + "]");
            }
            stringRedisTemplate.opsForValue().set((Object)keyVarStr, (Object)keyVarStr, timeout, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public String getFilterType() {
        return "PRE";
    }

    @Override
    public int filterOrder() {
        return 0;
    }

    public String getRedisActive() {
        return this.redisActive;
    }

    public void setRedisActive(String redisActive) {
        this.redisActive = redisActive;
    }

    public String getKeyVar() {
        return this.keyVar;
    }

    public void setKeyVar(String keyVar) {
        this.keyVar = keyVar;
    }
}

