/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.filter.impl;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.filter.service.RateLimiting;
import cn.com.yusys.yusp.bsp.filter.vm.RateLimit;
import cn.com.yusys.yusp.bsp.resources.core.BeanLifeCycle;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BspRateLimitingFilter
extends BspFilter
implements BeanLifeCycle {
    private static final String SERVICE_NAME = "BSP_SERVICE";
    private static final String RATE_TYPE_IP = "IP";
    private static final String RATE_TYPE_URI = "URI";
    private static final String RATE_TYPE_QPS = "QPS";
    private static final String RATE_TYPE_TPS = "TPS";
    private static final String REGEX = "(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})";
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("bsp-rate-limiting-filter-schedule-pool-%d").daemon(true).build());
    private Set<String> rangeSet = new HashSet<String>();
    private RateLimiting rateLimiting;
    private String rateType;
    private String rataRange;
    private String timeWindow;
    private String rateLimit;
    private long o_timeWindow = 1L;
    private int o_ratelimit = -1;

    @Override
    public void start() throws Exception {
        this.rateLimiting = BspAutoConfiguration.getRateLimiting();
        if (!StringTools.isEmpty(this.rataRange) && !"-1".equals(this.rataRange)) {
            ArrayList<String> list = new ArrayList<String>();
            this.split(list, this.rataRange, ',');
            if (RATE_TYPE_IP.equals(this.rateType)) {
                Pattern pattern = Pattern.compile(REGEX);
                for (String entry : list) {
                    int index = entry.indexOf(45);
                    if (index == 0 && entry.length() > 1) {
                        String end = entry.substring(1).trim();
                        Matcher matcher = pattern.matcher(end);
                        if (!matcher.find()) continue;
                        this.rangeSet.addAll(this.getInterval(null, matcher));
                        continue;
                    }
                    if (index != -1) {
                        String from = entry.substring(0, index).trim();
                        String end = entry.substring(index + 1).trim();
                        Matcher fromMatcher = pattern.matcher(from);
                        Matcher endMatcher = pattern.matcher(end);
                        if (!fromMatcher.find() || !endMatcher.find()) continue;
                        this.rangeSet.addAll(this.getInterval(fromMatcher, endMatcher));
                        continue;
                    }
                    this.rangeSet.add(entry.trim());
                }
            } else if (RATE_TYPE_URI.equals(this.rateType)) {
                this.rangeSet.addAll(list);
            }
        }
        if (!StringTools.isEmpty(this.timeWindow)) {
            try {
                this.o_timeWindow = Long.valueOf(this.timeWindow);
            }
            catch (NumberFormatException e) {
                this.o_timeWindow = 1L;
            }
        }
        if (!StringTools.isEmpty(this.rateLimit) && !"-1".equals(this.rateLimit)) {
            try {
                this.o_ratelimit = Integer.valueOf(this.rateLimit);
            }
            catch (NumberFormatException e) {
                this.o_ratelimit = -1;
            }
        }
        this.initRateLimitingScheduler();
    }

    @Override
    public void stop() throws Exception {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public boolean run(Map<String, Object> context) throws Exception {
        boolean runResult;
        if ("PRE".equals(this.filterType())) {
            runResult = this.executePrepare(context);
        } else if ("POST".equals(this.filterType())) {
            runResult = this.executePost(context);
        } else {
            throw new Exception("\u8fc7\u6ee4\u5668\u7c7b\u578b" + this.filterType() + "\u4e0d\u652f\u6301\uff01");
        }
        return runResult;
    }

    private boolean executePrepare(Map<String, Object> context) throws Exception {
        if ("-1".equals(this.rateLimit)) {
            this.logger.debug("\u6d41\u91cf\u63a7\u5236\u9608\u503c[{}]\uff0c\u4e0d\u63a7\u5236", (Object)this.rateLimit);
            return true;
        }
        if (this.o_ratelimit == -1) {
            this.logger.warn("\u6d41\u91cf\u63a7\u5236\u9608\u503c[{}]\u8bbe\u7f6e\u65e0\u6548\uff0c\u4e0d\u63a7\u5236", (Object)this.rateLimit);
            return true;
        }
        String controlId = null;
        if (RATE_TYPE_IP.equals(this.rateType)) {
            String ip = (String)ExpressTools.getValue("G_CLIENT_IP", context);
            if (ip == null || !this.rangeSet.contains(ip)) {
                this.logger.debug("\u6d41\u91cf\u63a7\u5236\u8303\u56f4-IP[{}]\u4e0d\u5305\u542b\u5728\u63a7\u5236\u8303\u56f4\u5185\uff0c\u4e0d\u63a7\u5236", (Object)ip);
                return true;
            }
            controlId = SERVICE_NAME + ip;
        } else if (RATE_TYPE_URI.equals(this.rateType)) {
            String requestUri = (String)ExpressTools.getValue("recvHead.uri", context);
            if (requestUri == null || !this.rangeSet.contains(requestUri)) {
                this.logger.debug("\u6d41\u91cf\u63a7\u5236\u8303\u56f4-URI[{}]\u4e0d\u5305\u542b\u5728\u63a7\u5236\u8303\u56f4\u5185\uff0c\u4e0d\u63a7\u5236", (Object)requestUri);
                return true;
            }
            controlId = requestUri;
        } else if (RATE_TYPE_QPS.equals(this.rateType)) {
            controlId = "BSP_SERVICE@QPS";
        } else if (RATE_TYPE_TPS.equals(this.rateType)) {
            controlId = "BSP_SERVICE@Occurs";
        } else {
            this.logger.warn("\u6d41\u91cf\u63a7\u5236\u7c7b\u578b[{}]\u4e0d\u5b58\u5728\uff0c\u4e0d\u63a7\u5236", (Object)this.rateType);
        }
        if (controlId != null) {
            long count;
            if (RATE_TYPE_QPS.equals(this.rateType)) {
                count = this.rateLimiting.getQpsCounter(controlId, this.getQpsTime()).getCount();
            } else {
                count = this.rateLimiting.getCounter(controlId).getCount();
                if (RATE_TYPE_TPS.equals(this.rateType)) {
                    context.put("@Occurs", controlId);
                } else {
                    this.rateLimiting.registerRequest(new RateLimit(this.rateType, controlId, System.currentTimeMillis(), this.o_timeWindow));
                }
            }
            if (count > (long)this.o_ratelimit || !RATE_TYPE_QPS.equals(this.rateType) && count == (long)this.o_ratelimit) {
                context.put("G_EXCEPTION_CODE", "9002");
                this.logger.warn("\u5df2\u8d85\u8fc7\u6d41\u91cf\u63a7\u5236[{}]\u8bbe\u5b9a\u9608\u503c[{}]\uff0c\u8bf7\u6c42\u88ab\u63a7\u5236", (Object)this.rateType, (Object)this.o_ratelimit);
                throw new ComponentException("\u5df2\u8d85\u8fc7\u6d41\u91cf\u63a7\u5236[" + this.rateType + "]\u8bbe\u5b9a\u9608\u503c[" + this.o_ratelimit + "]\uff0c\u8bf7\u6c42\u88ab\u63a7\u5236");
            }
            this.rateLimiting.incrementCounter(controlId);
            return true;
        }
        return false;
    }

    private boolean executePost(Map<String, Object> context) {
        String controlId = (String)context.get("@Occurs");
        if (controlId != null) {
            this.rateLimiting.reduceCounter(controlId);
        }
        return true;
    }

    public void initRateLimitingScheduler() {
        int startTime = 1;
        int each = 10;
        this.rateLimiting.clearCounter();
        this.scheduler.scheduleWithFixedDelay(new ScheduleRecovery(this.rateLimiting), startTime, each, TimeUnit.SECONDS);
    }

    private List<String> getInterval(Matcher fromMatcher, Matcher endMatcher) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer bf = null;
        for (int a = Integer.valueOf(fromMatcher.group(1)).intValue(); a <= Integer.valueOf(endMatcher.group(1)); ++a) {
            for (int b = Integer.valueOf(fromMatcher.group(2)).intValue(); b <= Integer.valueOf(endMatcher.group(2)); ++b) {
                for (int c = Integer.valueOf(fromMatcher.group(3)).intValue(); c <= Integer.valueOf(endMatcher.group(3)); ++c) {
                    for (int d = Integer.valueOf(fromMatcher.group(4)).intValue(); d <= Integer.valueOf(endMatcher.group(4)); ++d) {
                        bf = new StringBuffer();
                        bf.append(a).append('.').append(b).append('.').append(c).append('.').append(d);
                        result.add(bf.toString());
                    }
                }
            }
        }
        return result;
    }

    private void split(List<String> list, String source, char regex) {
        if (source == null) {
            return;
        }
        if ((source = source.trim()).length() == 0) {
            return;
        }
        int index = source.indexOf(regex);
        if (index == 0) {
            this.split(list, source.substring(1), regex);
        } else if (index != -1) {
            list.add(source.substring(0, index).trim());
            this.split(list, source.substring(index + 1), regex);
        } else {
            list.add(source);
        }
    }

    private long getQpsTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear(14);
        return calendar.getTime().getTime();
    }

    @Override
    public String getFilterType() {
        return "BOTH";
    }

    @Override
    public int filterOrder() {
        return 0;
    }

    public String getRateType() {
        return this.rateType;
    }

    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    public String getRataRange() {
        return this.rataRange;
    }

    public void setRataRange(String rataRange) {
        this.rataRange = rataRange;
    }

    public String getTimeWindow() {
        return this.timeWindow;
    }

    public void setTimeWindow(String timeWindow) {
        this.timeWindow = timeWindow;
    }

    public String getRateLimit() {
        return this.rateLimit;
    }

    public void setRateLimit(String rateLimit) {
        this.rateLimit = rateLimit;
    }

    class ScheduleRecovery
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(ScheduleRecovery.class);
        private RateLimiting rateLimiting;

        public ScheduleRecovery(RateLimiting rateLimiting) {
            this.rateLimiting = rateLimiting;
        }

        @Override
        public void run() {
            try {
                this.rateLimiting.tokenRecovery();
            }
            catch (Exception e) {
                this.log.error("\u56de\u6536\u6d41\u91cf\u63a7\u5236\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

