/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXMLNode;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SimpleXmlExecutor
extends AbstractExecutor<byte[]> {
    protected static final String DATA_FORMAT_NAME = "\u7b80\u5355XML";
    protected static final String DATA_FORMAT_PACK_XML = "packXml";
    protected static final String DATA_FORMAT_PACK_SIMPLE = "packSimple";
    protected static final String DATA_FORMAT_LOOPNODES = "loopNodes";
    protected static final String DATA_FORMAT_SIGN = "sign";
    protected static final String ITEM_ATRRIBUTE_PATH = "path";
    protected static final String ITEM_ATRRIBUTE_VARNAME = "varName";
    protected static final String ITEM_ATRRIBUTE_EMPTYWHILE = "emptyWhile";
    protected static final String SOAP_DEFAULT_SIGN = "_";
    protected List<List<String>> loopNodes;
    protected List<String> signList;
    protected SuperXmlTools xmlTools;
    protected int state = -2;
    protected SuperXMLNode xmlNode;
    protected boolean packNode;
    protected String nodePrefix;
    protected String nodeName;
    protected boolean packSimple = false;
    protected static final String V_SIZE = ".size()";
    protected LinkedList<String> nodeList = new LinkedList();

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        Object[] temp;
        String str = null;
        str = property.get(DATA_FORMAT_SIGN);
        if (StringTools.isEmpty(str)) {
            this.signList = null;
        } else {
            this.signList = new ArrayList<String>();
            for (char c : temp = str.toCharArray()) {
                this.signList.add(String.valueOf(c));
            }
        }
        this.xmlTools = new SuperXmlTools(this.getEncoding());
        if (this.getPackType() == DATAFORMAT_UNPACK) {
            str = property.get(DATA_FORMAT_LOOPNODES);
            if (StringTools.isEmpty(str)) {
                this.loopNodes = null;
            } else {
                this.loopNodes = new ArrayList<List<String>>();
                for (char string : temp = (Object[])str.split("[,]")) {
                    this.loopNodes.add(this.convertPathToList((String)string));
                }
            }
        } else {
            str = property.get(DATA_FORMAT_PACK_XML);
            Boolean packXml = true;
            if ("false".equals(str)) {
                packXml = false;
            }
            if ("true".equals(str = property.get(DATA_FORMAT_PACK_SIMPLE))) {
                this.packSimple = true;
            }
            this.xmlTools.setPackSimple(this.packSimple);
            this.xmlTools.writeStartDocument(packXml);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        try {
            this.xmlNode = this.xmlTools.readerXML(inputData);
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u89e3\u6790\u62c6\u5305\u65f6\u5f02\u5e38", e);
        }
    }

    @Override
    protected byte[] autoPack(Map<String, Object> map) throws Exception {
        byte[] data = null;
        try {
            this.autoPackMap(map, new ArrayList<String>());
            data = this.xmlTools.writeEndDocument();
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u81ea\u52a8\u62fc\u5305\u5f02\u5e38", e);
        }
        return data;
    }

    protected void autoPackMap(Map<String, Object> map, List<String> path) throws Exception {
        Object obj = null;
        for (String key : map.keySet()) {
            obj = map.get(key);
            int oldState = this.state;
            if (this.state == -2) {
                this.state = 1;
                oldState = 0;
            }
            this.xmlTools.writeStartElement(null, key);
            if (obj instanceof Map) {
                path.add(key);
                this.autoPackMap((Map)obj, path);
                path.remove(path.size() - 1);
            } else if (obj instanceof List) {
                this.autoPackList(key, (List)obj, path);
            } else {
                this.autoPackValue(key, obj, path);
            }
            this.xmlTools.writeEndElement(null, key, ++oldState < this.state);
            if (this.state <= oldState) continue;
            this.state = oldState == 1 ? -1 : oldState;
        }
    }

    protected void autoPackList(String key, List<Object> list, List<String> path) throws Exception {
        int nCount = list.size();
        int oldState = this.state;
        for (int i = 0; i < nCount; ++i) {
            Object object;
            path.add(key + "[" + i + "]");
            if (i != 0 && !StringTools.isEmpty(key)) {
                this.xmlTools.writeStartElement(null, key);
                ++this.state;
            }
            if ((object = list.get(i)) instanceof Map) {
                this.autoPackMap((Map)object, path);
            } else if (object instanceof List) {
                this.autoPackList(null, (List)object, path);
            } else {
                this.autoPackValue(null, object, path);
            }
            int j = ++oldState;
            if (i != nCount - 1) {
                this.xmlTools.writeEndElement(null, key, j < this.state);
            }
            path.remove(path.size() - 1);
        }
    }

    protected void autoPackValue(String key, Object value, List<String> path) throws Exception {
        byte[] valueByte;
        ++this.state;
        if (value instanceof byte[] || value instanceof String) {
            valueByte = ByteTools.getBytes(value, this.getEncoding());
            if (this.isFilterEmpty() && valueByte.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ \u81ea\u62fc:{},\u8fc7\u6ee4\u7a7a\u4e32", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
                }
                return;
            }
        } else if (value != null) {
            valueByte = ByteTools.getBytes(value, this.getEncoding());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ \u81ea\u62fc:{},\u5ffd\u7565(\u503c\u4e3anull)", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
            }
            return;
        }
        if (this.packSimple && valueByte.length == 0) {
            return;
        }
        valueByte = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), valueByte, 1);
        this.xmlTools.writeCharacters(valueByte);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} @ \u81ea\u62fc:{}=[{}]", new Object[]{this.getExecutorName(), this.pathToString(path, key), StringTools.getString(value, this.getEncoding())});
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = null;
        try {
            data = this.xmlTools.writeEndDocument();
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u62fc\u5305\u5f02\u5e38", e);
        }
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String name = item.getName();
        if (this.state < 0) {
            throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + name + "]\u5fc5\u987b\u5728\u5206\u7c7b\u6216\u8005\u5faa\u73af\u4e0b\u3002");
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        this.xmlTools.writeStartElement(this.nodePrefix, name);
        ++this.state;
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        if (StringTools.isEmpty(path)) {
            path = name;
        }
        if (this.packSimple && data.length == 0) {
            return;
        }
        this.xmlTools.writeCharacters(data);
        this.xmlTools.writeEndElement(this.nodePrefix, name, false);
    }

    @Override
    public void packGroup(Group group) throws Exception {
        if (this.state == -1) {
            throw new Exception("[" + this.getExecutorName() + "]\u5206\u7c7b[" + group.getName() + "]\u5fc5\u987b\u5728\u5206\u7c7b\u6216\u8005\u5faa\u73af\u4e0b\u3002");
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String prefix = null;
        String name = null;
        Head head = group.getHead();
        if (!(head instanceof CacheHead)) {
            throw new Exception("group\u5934\u4e0d\u5408\u6cd5");
        }
        CacheHead cacheHead = (CacheHead)head;
        name = cacheHead.getParas().get(ITEM_ATRRIBUTE_VARNAME);
        if (StringTools.isEmpty(name)) {
            name = group.getName();
        }
        int oldState = this.state;
        if (this.state == -2) {
            this.xmlTools.writeStartElement(prefix, name);
            this.packNode = false;
            this.state = 1;
            oldState = 0;
        } else {
            this.packNode = true;
            this.nodePrefix = prefix;
            this.nodeName = name;
        }
        this.packBody(group.getBody());
        if (this.packNode) {
            this.packNode = false;
        } else {
            this.xmlTools.writeEndElement(prefix, name, ++oldState < this.state);
        }
        if (this.state > oldState) {
            this.state = oldState == 1 ? -1 : oldState;
        }
    }

    @Override
    public void packWhile(While _while) throws Exception {
        if (this.state < 0) {
            throw new Exception("[" + this.getExecutorName() + "]\u5faa\u73af[" + _while.getName() + "]\u5fc5\u987b\u5728\u5206\u7c7b\u6216\u8005\u5faa\u73af\u4e0b\u3002");
        }
        Head head = _while.getHead();
        String name = null;
        String prefix = null;
        boolean emptyWhile = false;
        if (head instanceof CacheHead) {
            CacheHead cacheHead = (CacheHead)head;
            name = cacheHead.getParas().get(ITEM_ATRRIBUTE_VARNAME);
            String empty = cacheHead.getParas().get(ITEM_ATRRIBUTE_EMPTYWHILE);
            if (empty != null) {
                emptyWhile = new Boolean(empty);
            }
        } else {
            throw new Exception("\u5faa\u73af\u5934\u4e0d\u5408\u6cd5");
        }
        boolean nodeExpr = false;
        if (StringTools.isEmpty(name)) {
            name = _while.getName();
        } else if (name.indexOf(34) != -1) {
            nodeExpr = true;
        }
        String tmpNodeName = this.nodeName;
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String varname = _while.getVar();
        int nCount = this.parseLoopCount(_while);
        int oldState = this.state;
        for (int i = 0; i < nCount; ++i) {
            if (!emptyWhile) {
                this.packNode = true;
            }
            this.nodePrefix = prefix;
            this.rootContext.put(varname, new Integer(i));
            this.nodeName = nodeExpr ? StringTools.getString(OgnlTools.getValue(name, this.getRootContext())) : name;
            tmpNodeName = this.nodeName;
            this.packBody(_while.getBody());
            if (this.packNode) {
                this.packNode = false;
            } else if (!emptyWhile) {
                this.xmlTools.writeEndElement(prefix, tmpNodeName, ++oldState < this.state);
            }
            if (this.state <= oldState) continue;
            this.state = oldState == 1 ? -1 : oldState;
        }
        this.rootContext.remove(varname);
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        HashMap<String, Object> soapMap = new HashMap<String, Object>();
        this.xmlNode2Map(this.xmlNode, soapMap, false);
        return soapMap;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        SuperXMLNode node;
        List<String> list;
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        boolean isPath = false;
        if (StringTools.isEmpty(path)) {
            path = this.getRealItemPath(item);
            isPath = true;
        }
        if (!(list = this.convertPathToList(path)).get(0).equals(this.xmlNode.getName())) {
            return null;
        }
        if (isPath) {
            list.remove(list.size() - 1);
        }
        if ((node = this.getXmlNode(list)) == null) {
            return null;
        }
        String value = node.getValue();
        return value.getBytes(this.getEncoding());
    }

    @Override
    protected void unPackWhile(While _while) throws Exception {
        String count = _while.getMaxNum();
        String name = _while.getName();
        String varname = _while.getVar();
        String sCount = null;
        int nCount = -1;
        if (StringTools.isEmpty(count)) {
            count = this.getRealWhilePath(_while);
            List<String> list = this.convertLoopCountExprToList(count);
            nCount = this.getLoopSize(list);
            if (nCount == -1) {
                this.logger.warn("{} @ \u5faa\u73af[{}]\u5bf9\u5e94\u7684\u7ed3\u6784\u4e0d\u5b58\u5728\uff0c\u5faa\u73af\u5ffd\u7565", new Object[]{this.getExecutorName(), count});
                return;
            }
        } else {
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
            }
            catch (Exception e1) {
                if (count.endsWith(V_SIZE)) {
                    List<String> list = this.convertLoopCountExprToList(count);
                    list.remove(list.size() - 1);
                    nCount = this.getLoopSize(list);
                    if (nCount == -1) {
                        throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u7684\u5faa\u73af\u6b21\u6570[" + count + "]\u5bf9\u5e94\u7684\u503c\u4e0d\u5b58\u5728");
                    }
                }
                throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u7684\u5faa\u73af\u6b21\u6570[" + count + "]\u5bf9\u5e94\u7684\u503c\u4e0d\u5b58\u5728");
            }
            if (nCount == -1) {
                if (StringTools.isEmpty(sCount)) {
                    throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u7684\u5faa\u73af\u6b21\u6570[" + count + "]\u53d8\u91cf\u503c\u4e0d\u5b58\u5728");
                }
                try {
                    nCount = Integer.parseInt(sCount);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u7684\u5faa\u73af\u6b21\u6570\u5faa\u73af\u6b21\u6570\u5fc5\u987b\u662f\u6570\u5b57, \u76ee\u524d=" + sCount, e);
                }
            }
        }
        super.unPackWhile(nCount, name, varname, _while);
    }

    protected SuperXMLNode getXmlNode(List<String> list) throws Exception {
        Object obj = null;
        String tempName = null;
        int start = -1;
        int index = -1;
        int end = -1;
        SuperXMLNode tempNode = this.xmlNode;
        List tempList = null;
        for (int i = 1; i < list.size(); ++i) {
            index = -1;
            tempName = list.get(i);
            start = tempName.indexOf("[");
            end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                obj = OgnlTools.getValue(tempName.substring(start + 1, end), this.getRootContext());
                index = Integer.valueOf(obj.toString());
                tempName = tempName.substring(0, start);
            }
            if ((obj = tempNode.getChildren().get(tempName)) == null) {
                return null;
            }
            if (obj instanceof SuperXMLNode) {
                if (index > 0) {
                    return null;
                }
                tempNode = (SuperXMLNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            tempList = (List)obj;
            if (index == -1 || index >= tempList.size()) {
                return null;
            }
            tempNode = (SuperXMLNode)tempList.get(index);
        }
        return tempNode;
    }

    protected int getLoopSize(List<String> list) throws Exception {
        Object obj = null;
        String tempName = null;
        int start = -1;
        int index = -1;
        int end = -1;
        SuperXMLNode tempNode = this.xmlNode;
        int size = list.size() - 1;
        if (!list.get(0).equals(this.xmlNode.getName())) {
            return -1;
        }
        List tempList = null;
        for (int i = 1; i <= size; ++i) {
            index = -1;
            tempName = list.get(i);
            start = tempName.indexOf("[");
            end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                obj = OgnlTools.getValue(tempName.substring(start + 1, end), this.getRootContext());
                index = Integer.valueOf(obj.toString());
                tempName = tempName.substring(0, start);
            }
            if ((obj = tempNode.getChildren().get(tempName)) instanceof SuperXMLNode) {
                if (index > 0) {
                    return -1;
                }
                tempNode = (SuperXMLNode)obj;
                continue;
            }
            if (obj instanceof List) {
                tempList = (List)obj;
                if (i == size) {
                    return tempList.size();
                }
                if (index == -1 || index >= tempList.size()) {
                    return -1;
                }
                tempNode = (SuperXMLNode)tempList.get(index);
                continue;
            }
            return -1;
        }
        return 1;
    }

    protected String convertSign(String str) {
        if (this.signList == null || StringTools.isEmpty(str)) {
            return str;
        }
        for (String temp : this.signList) {
            if (str.indexOf(temp) == -1) continue;
            str = str.replace(temp, SOAP_DEFAULT_SIGN);
        }
        return str;
    }

    protected List<String> convertPathToList(String path) {
        String[] loopNode;
        ArrayList<String> loop = new ArrayList<String>();
        path = StringUtils.replace((String)path, (String)"/", (String)".");
        for (String s : loopNode = StringUtils.split((String)path, (String)".")) {
            if (StringTools.isEmpty(s)) continue;
            loop.add(s);
        }
        return loop;
    }

    protected List<String> convertLoopCountExprToList(String path) {
        ArrayList<String> loop = new ArrayList<String>();
        path = StringUtils.replace((String)path, (String)"/", (String)".");
        String[] loopNode = StringUtils.split((String)path, (String)".");
        for (int i = 0; i < loopNode.length; ++i) {
            if (StringTools.isEmpty(loopNode[i])) continue;
            loop.add(loopNode[i]);
        }
        return loop;
    }

    protected void xmlNode2Map(SuperXMLNode xml, Object root, boolean _useValue) throws Exception {
        String name = xml.getName();
        this.nodeList.add(name);
        String value = xml.getValue().trim();
        Map<String, Object> children = xml.getChildren();
        int childSize = children.size();
        if (!_useValue && childSize == 0) {
            String text = "";
            if (!StringTools.isEmpty(value)) {
                text = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), value, 1));
            }
            if (root instanceof List) {
                ((List)root).add(text);
            } else if (root instanceof Map) {
                String tempName = this.convertSign(name);
                ((Map)root).put(tempName, text);
            }
            this.nodeList.removeLast();
            return;
        }
        HashMap nodeMap = new HashMap();
        String tempName = this.convertSign(name);
        if (root instanceof List) {
            ((List)root).add(nodeMap);
        } else if (root instanceof Map) {
            ((Map)root).put(tempName, nodeMap);
        }
        Object obj = null;
        for (String key : children.keySet()) {
            LinkedList childrenList;
            obj = children.get(key);
            if (obj instanceof SuperXMLNode) {
                if (this.validateLoop(this.nodeList, key)) {
                    childrenList = new LinkedList();
                    nodeMap.put(key, childrenList);
                    this.xmlNode2Map((SuperXMLNode)obj, childrenList, _useValue);
                    continue;
                }
                this.xmlNode2Map((SuperXMLNode)obj, nodeMap, _useValue);
                continue;
            }
            if (obj instanceof List) {
                childrenList = new LinkedList();
                nodeMap.put(key, childrenList);
                for (SuperXMLNode tempNode : (List)obj) {
                    this.xmlNode2Map(tempNode, childrenList, _useValue);
                }
                continue;
            }
            throw new Exception("\u7c7b\u578b\u4e0d\u652f\u6301:" + obj);
        }
        this.nodeList.removeLast();
    }

    protected boolean validateLoop(LinkedList<String> nodeList, String key) {
        if (this.loopNodes == null) {
            return false;
        }
        boolean res = false;
        nodeList.add(key);
        for (List<String> list : this.loopNodes) {
            if (list.size() != nodeList.size() || !list.equals(nodeList)) continue;
            res = true;
            break;
        }
        nodeList.removeLast();
        return res;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

