/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public class LenExecutor
extends AbstractExecutor<byte[]> {
    private int totalLen = 0;
    public static final String DATA_FORMAT_NAME = "\u5b9a\u957f";
    private static final String DATA_FORMAT_PARA_LEN = "msgLen";
    private static final String ITEM_PARA_LEN = "itemLen";
    private ByteArrayOutputStream buildStream;
    private int msgLen = -1;
    private int searchIndex;
    private static final String DATA_FORMAT_DEFAULT_FILL_STYLE = "defFillStyle";
    private static final String DATA_FORMAT_DEFAULT_FILLER = "defFiller";
    private String defDataFillStyle;
    private byte[] defDataFiller;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        String len = property.get(DATA_FORMAT_PARA_LEN);
        this.totalLen = StringTools.isEmpty(len) ? -1 : Integer.parseInt(len);
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.buildStream = new ByteArrayOutputStream(256);
        }
        this.defDataFillStyle = property.get(DATA_FORMAT_DEFAULT_FILL_STYLE);
        String fillchar = property.get(DATA_FORMAT_DEFAULT_FILLER);
        this.defDataFiller = ExecutorHelper.parserFiller(fillchar);
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        this.msgLen = ((byte[])this.getInputData()).length;
        if (this.totalLen > 0 && this.msgLen != this.totalLen) {
            throw new Exception("[" + this.getExecutorName() + "]\u62c6\u5305\u65f6\u5b9e\u9645\u6570\u636e\u957f\u5ea6[" + this.msgLen + "]\u4e0e\u914d\u7f6e\u7684\u6570\u636e\u6700\u5927\u957f\u5ea6[" + this.totalLen + "]\u4e0d\u7b49");
        }
        this.searchIndex = 0;
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.buildStream.toByteArray();
        this.buildStream.reset();
        int len = data.length;
        if (this.totalLen > 0 && len != this.totalLen) {
            throw new Exception("[" + this.getExecutorName() + "]\u62fc\u5305\u540e\u7684\u5b9e\u9645\u6570\u636e\u957f\u5ea6[" + len + "]\u4e0e\u914d\u7f6e\u7684\u6570\u636e\u6700\u5927\u957f\u5ea6[" + this.totalLen + "]\u4e0d\u7b49");
        }
        return data;
    }

    @Override
    protected byte[] prePackItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String fLen = paras.get(ITEM_PARA_LEN);
        return ExecutorHelper.defFillData(this.getExecutorName(), item, data, fLen, this.defDataFillStyle, this.defDataFiller, this.getRootContext(), true);
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        this.buildStream.write(data);
    }

    @Override
    public byte[] unPackItem(Item field, Map<String, String> paras) throws Exception {
        String fLen = paras.get(ITEM_PARA_LEN);
        int len = ExecutorHelper.parseItemLen(this.getExecutorName(), field, fLen, this.getRootContext(), this.msgLen, this.searchIndex);
        if (this.searchIndex >= this.msgLen) {
            if (this.totalLen >= 0) {
                throw new DataFormatException("\u6570\u636e\u683c\u5f0f\u914d\u7f6e\u957f\u5ea6\u8d85\u957f \uff1a" + (this.searchIndex + len) + ">" + this.msgLen);
            }
            this.setDataFormatEnd();
            return new byte[0];
        }
        if (this.searchIndex + len > this.msgLen) {
            this.setDataFormatEnd();
            throw new DataFormatException("\u6570\u636e\u683c\u5f0f\u914d\u7f6e\u957f\u5ea6\u8d85\u957f:" + (this.searchIndex + len) + ">" + this.msgLen);
        }
        byte[] data = new byte[len];
        System.arraycopy(this.getInputData(), this.searchIndex, data, 0, len);
        this.searchIndex += len;
        if (this.searchIndex >= this.msgLen) {
            this.setDataFormatEnd();
        }
        return data;
    }

    @Override
    public int getSearchIndex() {
        if (this.isDataFormatEnd()) {
            return -1;
        }
        return this.searchIndex;
    }
}

