/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;

public class FieldLenExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "\u57df\u5b9a\u957f";
    private static final String ITEM_FIELD_TYPE = "fieldType";
    private static final String ITEM_FIELD_LEN = "fieldLen";
    private static final String FILL_CHAR = "fillChar";
    private static final String IS_INCLUDE = "isInclude";
    private static final String ITEM_DATA_MAX_LEN = "maxLen";
    private static final String FIELD_TYPE_BYTE = "byte";
    private static final String FIELD_TYPE_SHORT = "short";
    private static final String FIELD_TYPE_INT = "int";
    private static final String FIELD_TYPE_STRING = "string";
    private int searchIndex;
    private int dataLength;
    private DataInputStream inputStream;
    private ByteArrayOutputStream byteOut;
    private DataOutputStream outputStream;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.byteOut = new ByteArrayOutputStream(256);
            this.outputStream = new DataOutputStream(this.byteOut);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        this.dataLength = inputData.length;
        this.inputStream = new DataInputStream(new ByteArrayInputStream(inputData));
        this.searchIndex = 0;
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.byteOut.toByteArray();
        this.byteOut.close();
        this.outputStream.close();
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String itemFieldType = paras.get(ITEM_FIELD_TYPE);
        String itemFillChar = paras.get(FILL_CHAR);
        String isIn = paras.get(IS_INCLUDE);
        byte fillByte = 48;
        if (StringTools.isEmpty(itemFieldType)) {
            throw new Exception("[\u57df\u5b9a\u957f]\u5b57\u6bb5[" + item.getName() + "]\u7684\u957f\u5ea6\u57df\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringTools.isEmpty(itemFillChar)) {
            byte[] sign = StringTools.escString2Byte(itemFillChar);
            fillByte = sign[0];
        }
        int maxLen = -1;
        String str = paras.get(ITEM_DATA_MAX_LEN);
        if (!StringTools.isEmpty(str)) {
            try {
                maxLen = Integer.parseInt(str);
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ \u5b57\u6bb5[" + this.getRealItemPath(item) + "]\u7684\u6570\u636e\u6700\u5927\u957f\u5ea6[" + str + "]\u8f6c\u6210\u6570\u5b57\u5f02\u5e38", e);
            }
        }
        if (maxLen > 0 && data.length > maxLen) {
            throw new Exception(this.getExecutorName() + " @ \u5b57\u6bb5[" + this.getRealItemPath(item) + "]\u7684\u5b9e\u9645\u6570\u636e\u957f\u5ea6[" + data.length + "]\u8d85\u51fa\u6570\u636e\u6700\u5927\u957f\u5ea6[" + maxLen + "]");
        }
        int len = data.length;
        if (FIELD_TYPE_STRING.equals(itemFieldType)) {
            byte[] byteLen;
            int itemFieldLen = 0;
            str = paras.get(ITEM_FIELD_LEN);
            if (!StringTools.isEmpty(str)) {
                try {
                    itemFieldLen = Integer.parseInt(str);
                }
                catch (Exception e) {
                    throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + item.getName() + "]\u7684\u957f\u5ea6\u57df\u7c7b\u578b\u4e3a\u5b57\u7b26\u578b\uff0c\u9700\u8981\u586b\u5199\u957f\u5ea6\u57df\u957f\u5ea6\u3002");
                }
            }
            if ("true".equals(isIn)) {
                len += itemFieldLen;
            }
            if ((byteLen = ByteTools.int2DecAsciiByte(len)).length > itemFieldLen) {
                throw new Exception("[" + this.getExecutorName() + "]\u5b57\u6bb5[" + this.getRealItemPath(item) + "]\u7684\u957f\u5ea6\u57df\u6570\u636e\u5b9e\u9645\u957f\u5ea6[" + byteLen.length + "]\u5927\u4e8e\u914d\u7f6e\u7684\u957f\u5ea6[" + itemFieldLen + "]");
            }
            byteLen = ByteTools.leftPad(byteLen, itemFieldLen, fillByte);
            this.outputStream.write(byteLen);
        } else if (FIELD_TYPE_BYTE.equals(itemFieldType)) {
            if (len > 127) {
                throw new Exception("[\u57df\u5b9a\u957f]\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u503c\u7684\u957f\u5ea6[" + len + "]\u5df2\u7ecf\u8d85\u51fa\u957f\u5ea6\u57df\u7684\u957f\u5ea6[" + 127 + "]");
            }
            this.outputStream.writeByte(len);
        } else if (FIELD_TYPE_SHORT.equals(itemFieldType)) {
            if (len > Short.MAX_VALUE) {
                throw new Exception("[\u57df\u5b9a\u957f]\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u503c\u7684\u957f\u5ea6[" + len + "]\u5df2\u7ecf\u8d85\u51fa\u957f\u5ea6\u57df\u7684\u957f\u5ea6[" + Short.MAX_VALUE + "]");
            }
            this.outputStream.writeShort(len);
        } else if (FIELD_TYPE_INT.equals(itemFieldType)) {
            this.outputStream.writeInt(len);
        }
        this.outputStream.write(data);
    }

    @Override
    public byte[] unPackItem(Item field, Map<String, String> paras) throws Exception {
        if (this.searchIndex >= this.dataLength) {
            return new byte[0];
        }
        String itemFieldType = paras.get(ITEM_FIELD_TYPE);
        String isIn = paras.get(IS_INCLUDE);
        if (StringTools.isEmpty(itemFieldType)) {
            throw new Exception("[\u57df\u5b9a\u957f]\u5b57\u6bb5[" + field.getName() + "]\u7684\u957f\u5ea6\u57df\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int dataLen = 0;
        if (FIELD_TYPE_STRING.equals(itemFieldType)) {
            int itemFieldLen = 0;
            String str = paras.get(ITEM_FIELD_LEN);
            if (StringTools.isEmpty(str)) {
                throw new Exception(this.getExecutorName() + " @ \u5b57\u6bb5[" + this.getRealItemPath(field) + "]\u7684\u957f\u5ea6\u57df\u957f\u5ea6\u4e3a\u7a7a");
            }
            try {
                itemFieldLen = Integer.parseInt(str);
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ \u5b57\u6bb5[" + this.getRealItemPath(field) + "]\u7684\u957f\u5ea6\u57df\u7c7b\u578b\u4e3a\u5b57\u7b26\u578b\uff0c\u9700\u8981\u586b\u5199\u957f\u5ea6\u57df\u957f\u5ea6\u3002");
            }
            if (itemFieldLen == 0) {
                return new byte[0];
            }
            byte[] byteField = new byte[itemFieldLen];
            this.inputStream.readFully(byteField);
            this.searchIndex += itemFieldLen;
            String itemFillChar = paras.get(FILL_CHAR);
            byte fillByte = 48;
            if (!StringTools.isEmpty(itemFillChar)) {
                byte[] sign = StringTools.escString2Byte(itemFillChar);
                fillByte = sign[0];
            }
            if ((byteField = ByteTools.stripStart(byteField, fillByte)).length == 0) {
                return new byte[0];
            }
            dataLen = ByteTools.decAsciiByte2int(byteField);
            if ("true".equals(isIn)) {
                dataLen -= itemFieldLen;
            }
        } else if (FIELD_TYPE_BYTE.equals(itemFieldType)) {
            dataLen = this.inputStream.read();
            ++this.searchIndex;
        } else if (FIELD_TYPE_SHORT.equals(itemFieldType)) {
            dataLen = this.inputStream.readShort();
            this.searchIndex += 2;
        } else if (FIELD_TYPE_INT.equals(itemFieldType)) {
            dataLen = this.inputStream.readInt();
            this.searchIndex += 4;
        }
        byte[] data = new byte[dataLen];
        this.inputStream.readFully(data);
        this.searchIndex += dataLen;
        if (this.searchIndex >= this.dataLength) {
            this.setDataFormatEnd();
        }
        return data;
    }

    @Override
    public int getSearchIndex() {
        if (this.searchIndex >= this.dataLength) {
            return -1;
        }
        return this.searchIndex;
    }
}

