/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.exe;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.exe.IDataFormatExecutor;
import cn.com.yusys.yusp.bsp.method.FastMethodInvoker;
import cn.com.yusys.yusp.bsp.resources.core.BspTools;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheBody;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheBuild;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheMethod;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheParse;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Body;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.BodyItem;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Build;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Case;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormatRef;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Default;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.ItemRef;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Method;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Parse;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Property;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.SubRefDataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Switch;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DataFormatTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutor<S>
implements IDataFormatExecutor<S> {
    public static int DATAFORMAT_PACK = 0;
    public static int DATAFORMAT_UNPACK = 1;
    private String encoding;
    private boolean autoUnpack;
    private boolean autoPack;
    private String currentPath;
    private String currentPathUnpack;
    private boolean parseExpr = true;
    protected static final String PROPERTY_FILTER_EMPTY = "filterEmpty";
    protected static final String PROPERTY_AUTO_PACK = "autoPack";
    protected static final String PROPERTY_AUTO_PACK_VAR = "autoPackVar";
    protected static final String PROPERTY_AUTO_UNPACK = "isAuto";
    protected static final String PROPERTY_AUTO_UNPACK_VAR = "varName";
    protected static final String PROPERTY_AUTO_UNPACK_SAVE = "autoSave";
    public static final String MESSAGE_TYPE_BYTEBUFFER = "ByteBuffer";
    public static final String MESSAGE_TYPE_MAP = "Map";
    public static final String MESSAGE_TYPE_OTHERS = "Others";
    private String autoPackVar;
    private String autoUnpackVar;
    private boolean autoUnpackSave;
    private boolean filterEmpty = false;
    private boolean dataMessage = true;
    private boolean unpackEmptyCheck = true;
    private boolean subObjectType = false;
    protected Method[] globalBuildMethod;
    private Method[] globalParseMethod;
    protected Map<String, Object> currentContext;
    protected Map<String, Object> autoContext = new HashMap<String, Object>();
    protected boolean end = false;
    private boolean hiddenInfo;
    private S inputData;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Logger loggerWarn = LoggerFactory.getLogger(AbstractExecutor.class);
    protected int packType;
    protected Map<String, Object> rootContext;
    protected static final String V_TRUE = "true";
    protected static final String V_FALSE = "false";
    protected static final String V_DOT = ".";
    protected static final String V_STRING = "string";
    protected static final String V_HEX_STRING = "hexString";
    protected static final String V_BRACKET_LEFT = "[";
    protected static final String V_BRACKET_RIGHT = "]";
    protected static final String V_EMPTY = "";
    protected static final String V_0_STRING = "0";
    protected static final String V_SLASH = "/";
    protected static final String V_REGEX_COMMA = "[,]";
    protected static final byte V_0_BYTE = 0;
    protected static final String V_LT_STRING = "<";
    protected static final String V_GT_STRING = ">";
    protected static final String V_PACK_STRING = "\u62fc\u5305";
    protected static final String V_UNPACK_STRING = "\u62c6\u5305";
    protected static final String HEXPREFIX_UPPER = "0X";
    protected static final String HEXPREFIX_LOWER = "0x";

    public Object itemTypeConvert(String dataType, byte[] byField) throws Exception {
        if (dataType.equals("String")) {
            return StringTools.getString(byField, this.getEncoding());
        }
        if (dataType.equals("Bytes")) {
            return byField;
        }
        if (dataType.equals("Integer")) {
            try {
                return new Integer(StringTools.getString(byField).trim());
            }
            catch (NumberFormatException e) {
                throw new Exception("\u8f6c\u6362\u6570\u636e[" + StringTools.getString(byField).trim() + "]\u4e3a\u6574\u578b\u5f02\u5e38", e);
            }
        }
        if (dataType.equals("Long")) {
            try {
                return new Long(StringTools.getString(byField).trim());
            }
            catch (NumberFormatException e) {
                throw new Exception("\u8f6c\u6362\u6570\u636e[" + StringTools.getString(byField).trim() + "]\u4e3a\u957f\u6574\u578b\u5f02\u5e38", e);
            }
        }
        if (dataType.equals("Float")) {
            try {
                return new Float(StringTools.getString(byField).trim());
            }
            catch (NumberFormatException e) {
                throw new Exception("\u8f6c\u6362\u6570\u636e[" + StringTools.getString(byField).trim() + "]\u4e3a\u6d6e\u70b9\u578b\u5f02\u5e38", e);
            }
        }
        if (dataType.equals("Double")) {
            try {
                return new Double(StringTools.getString(byField).trim());
            }
            catch (NumberFormatException e) {
                throw new Exception("\u8f6c\u6362\u6570\u636e[" + StringTools.getString(byField).trim() + "]\u4e3aDouble\u578b\u5f02\u5e38", e);
            }
        }
        throw new Exception("\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b[" + dataType + V_BRACKET_RIGHT);
    }

    @Override
    public Map<String, Object> getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(Map<String, Object> currentContext) {
        this.currentContext = currentContext;
    }

    public Map<String, Object> getAutoContext() {
        return this.autoContext;
    }

    public void setAutoContext(Map<String, Object> autoContext) {
        this.autoContext = autoContext;
    }

    @Override
    public S getInputData() {
        return this.inputData;
    }

    public int getPackType() {
        return this.packType;
    }

    @Override
    public Map<String, Object> getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(Map<String, Object> rootContext) {
        this.rootContext = rootContext;
    }

    @Override
    public void inputData(S inputData) throws Exception {
        this.inputData = inputData;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isAutoUnpack() {
        return this.autoUnpack;
    }

    public void setAutoUnPack(boolean autoUnpack) {
        this.autoUnpack = autoUnpack;
    }

    protected Object invokeMethods(Method[] methods, Item item, Object data, int returnType) throws Exception {
        if (methods == null) {
            return data;
        }
        Object o = data;
        for (int i = 0; i < methods.length; ++i) {
            Map<Object, Object> paras;
            if (methods[i] instanceof CacheMethod) {
                paras = ((CacheMethod)methods[i]).getParas();
            } else {
                paras = new HashMap();
                Property[] properties = methods[i].getProperty();
                for (int j = 0; j < properties.length; ++j) {
                    paras.put(properties[j].getName(), properties[j].getValue());
                }
            }
            if (item != null && !StringTools.isEmpty(item.getName())) {
                paras.put("ItemName", item.getName());
                paras.put("ItemDesc", item.getDescription());
            }
            o = FastMethodInvoker.getInstance().invokeFormatMethod(methods[i].getClazzName(), methods[i].getMethod(), paras, o, this.getRootContext());
        }
        if (returnType == 1) {
            return ByteTools.getBytes(o);
        }
        if (returnType == 2) {
            return StringTools.getString(o, this.getEncoding());
        }
        return o;
    }

    protected Object invokeMethods(Method[] methods, Object data, int returnType) throws Exception {
        if (methods == null) {
            return data;
        }
        Object o = data;
        for (int i = 0; i < methods.length; ++i) {
            HashMap<String, String> paras;
            if (methods[i] instanceof CacheMethod) {
                paras = ((CacheMethod)methods[i]).getParas();
            } else {
                paras = new HashMap();
                Property[] properties = methods[i].getProperty();
                for (int j = 0; j < properties.length; ++j) {
                    paras.put(properties[j].getName(), properties[j].getValue());
                }
            }
            o = FastMethodInvoker.getInstance().invokeFormatMethod(methods[i].getClazzName(), methods[i].getMethod(), paras, o, this.getRootContext());
        }
        if (returnType == 1) {
            return ByteTools.getBytes(o);
        }
        if (returnType == 2) {
            return StringTools.getString(o, this.getEncoding());
        }
        return o;
    }

    public boolean isHiddenInfo() {
        return this.hiddenInfo;
    }

    public void log(int logLevel, Item item, String value, Map<String, String> params, String appendStr) throws Exception {
        String logStr = null;
        Object[] logParams = null;
        String packTypeStr = null;
        if (this.packType == DATAFORMAT_PACK) {
            packTypeStr = V_PACK_STRING;
            if (value == null) {
                logStr = "{} @ {}:{},\u5ffd\u7565 {}";
                logParams = new String[]{this.getExecutorName(), packTypeStr, OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext), appendStr};
                this.log(logLevel, logStr, logParams);
                return;
            }
        } else {
            packTypeStr = V_UNPACK_STRING;
        }
        if (item.isPwd() && value != null) {
            this.setHiddenInfo(true);
            value = BspTools.pwdTransfer(value);
        }
        logStr = "{} @ {}:{}=[{}] {}";
        logParams = new String[]{this.getExecutorName(), packTypeStr, OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext), value, appendStr};
        this.log(logLevel, logStr, logParams);
    }

    protected void log(int logLevel, String logStr, Object[] logParams) {
        if (logLevel == 1) {
            this.logger.debug(logStr, logParams);
        } else if (logLevel == 3) {
            this.logger.warn(logStr, logParams);
        } else if (logLevel == 2) {
            this.logger.info(logStr, logParams);
        } else if (logLevel == 4) {
            this.logger.error(logStr, logParams);
        }
    }

    @Override
    public S outputData() throws Exception {
        if (this.isAutoPack()) {
            return this.autoPackInner();
        }
        return this.outputInner();
    }

    public abstract S outputInner() throws Exception;

    @Override
    public void pack(DataFormat dataformat) throws Exception {
        this.packType = DATAFORMAT_PACK;
        Map<String, String> pro = this.packHead(dataformat.getHead());
        this.setFilterEmpty(V_TRUE.equals(pro.get(PROPERTY_FILTER_EMPTY)));
        this.setAutoPack(V_TRUE.equals(pro.get(PROPERTY_AUTO_PACK)));
        this.setAutoPackVar(pro.get(PROPERTY_AUTO_PACK_VAR));
        this.initDataformat(dataformat, pro);
        if (!this.isAutoPack()) {
            this.packBody(dataformat.getBody());
        }
    }

    private S autoPackInner() throws Exception {
        Object obj = null;
        obj = StringTools.isEmpty(this.getAutoPackVar()) || this.getAutoPackVar().equals("ctx") || this.getAutoPackVar().equals("context") ? this.getAutoContext() : OgnlTools.getValue(this.getAutoPackVar(), this.getAutoContext());
        if (obj == null) {
            throw new Exception(this.getExecutorName() + " @ \u81ea\u52a8\u62fc\u5305\u53d8\u91cf[" + this.getAutoPackVar() + "]\u7684\u503c\u4e3anull");
        }
        if (obj instanceof Map) {
            try {
                S ret = this.autoPack((Map<String, Object>)obj);
                return ret;
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ \u81ea\u52a8\u62fc\u5305\u5f02\u5e38", e);
            }
        }
        if (obj instanceof List) {
            try {
                S ret = this.autoPack((List)obj);
                return ret;
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ \u81ea\u52a8\u62fc\u5305\u5f02\u5e38", e);
            }
        }
        throw new Exception(this.getExecutorName() + " @ \u81ea\u52a8\u62fc\u5305\u53d8\u91cf[" + this.getAutoPackVar() + "]\u7684\u503c\u5fc5\u987b\u4e3aMAP\u7c7b\u578b");
    }

    protected S autoPack(Map<String, Object> map) throws Exception {
        throw new Exception(this.getExecutorName() + " @ \u4e0d\u652f\u6301Map\u7c7b\u578b\u81ea\u52a8\u62fc\u5305");
    }

    protected S autoPack(List<Object> list) throws Exception {
        throw new Exception(this.getExecutorName() + " @ \u4e0d\u652f\u6301List\u7c7b\u578b\u81ea\u52a8\u62fc\u5305");
    }

    protected String pathToString(List<String> path, String key) {
        if (path.size() == 0) {
            return key;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : path) {
            if (buf.length() > 0) {
                buf.append(V_DOT);
            }
            buf.append(str);
        }
        if (!StringTools.isEmpty(key)) {
            buf.append(V_DOT);
            buf.append(key);
        }
        return buf.toString();
    }

    protected void packBody(Body body) throws Exception {
        BodyItem[] item;
        if (body != null && (item = body instanceof CacheBody ? ((CacheBody)body).getBodyItemArr() : body.getBodyItem()) != null) {
            for (int i = 0; i < item.length; ++i) {
                this.packBodyItem(item[i].getChoiceValue());
            }
        }
    }

    protected boolean packBodyItem(Object choiceValue) throws Exception {
        if (choiceValue instanceof Item) {
            return this.packItem((Item)choiceValue);
        }
        if (choiceValue instanceof Group) {
            this.packGroup((Group)choiceValue);
        } else if (choiceValue instanceof While) {
            this.packWhile((While)choiceValue);
        } else {
            if (choiceValue instanceof Switch) {
                return this.packSwitch((Switch)choiceValue);
            }
            if (choiceValue instanceof DataFormatRef) {
                this.packDataFormatRef((DataFormatRef)choiceValue);
            } else if (choiceValue instanceof ItemRef) {
                this.packItemRef((ItemRef)choiceValue);
            } else {
                throw new DataFormatException(this.getExecutorName() + " @ \u7c7b\u578b\u4e0d\u652f\u6301:" + choiceValue);
            }
        }
        return true;
    }

    private void packCase(Case _case) throws Exception {
        this.packBody(_case.getBody());
    }

    protected void packDataFormatRef(DataFormatRef dataFormatRef) throws Exception {
        String refName = dataFormatRef.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(dataFormatRef.getFileName(), this.getRootContext()));
        this.logger.debug("{} @ \u62fc\u5f15\u7528\u62a5\u6587,\u5f15\u7528\u540d:{},\u62a5\u6587:{}", new Object[]{this.getExecutorName(), refName, messageName});
        String oldPath = this.currentPath;
        if (StringTools.isEmpty(this.currentPath)) {
            this.currentPath = dataFormatRef.getPath();
        } else if (!StringTools.isEmpty(dataFormatRef.getPath())) {
            this.currentPath = this.currentPath + V_DOT + dataFormatRef.getPath();
        }
        DataFormat dataFormat = this.getMfdDataFormat(messageName);
        this.packBody(dataFormat.getBody());
        this.currentPath = oldPath;
    }

    protected DataFormat getMfdDataFormat(String messageName) throws Exception {
        return DataFormatTools.loadDataFormat(messageName);
    }

    protected byte[] packSubRefDataFormat(SubRefDataFormat dataFormatRef) throws Exception {
        String oldPath = this.currentPath;
        this.currentPath = StringTools.isEmpty(this.currentPath) ? dataFormatRef.getPath() : this.currentPath + V_DOT + dataFormatRef.getPath();
        String refName = dataFormatRef.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(dataFormatRef.getFileName(), this.getRootContext()));
        this.logger.debug("{} @ \u62fc\u5b50\u5f15\u7528\u62a5\u6587,\u5b50\u5f15\u7528\u540d:{},\u62a5\u6587:{}", new Object[]{this.getExecutorName(), refName, messageName});
        DataFormat dataFormat = this.getMfdDataFormat(messageName);
        byte[] data = ByteTools.getBytes(this.packSubDataFormat(dataFormat));
        this.currentPath = oldPath;
        return data;
    }

    private void packDefault(Default _default) throws Exception {
        this.packBody(_default.getBody());
    }

    protected void packGroup(Group group) throws Exception {
        this.packBody(group.getBody());
    }

    protected Map<String, String> packHead(Head head) {
        Property[] property;
        if (head instanceof CacheHead) {
            return ((CacheHead)head).getParas();
        }
        HashMap<String, String> para = new HashMap<String, String>();
        if (head != null && (property = head.getProperty()) != null) {
            for (int i = 0; i < property.length; ++i) {
                para.put(property[i].getName(), property[i].getValue());
            }
        }
        return para;
    }

    protected boolean packItem(Item item) throws Exception {
        String buildExpr;
        Map<String, String> params = this.packHead(item.getHead());
        Object ret = null;
        DataFormat dataformat = item.getDataFormat();
        SubRefDataFormat subRefDataFormat = item.getSubRefDataFormat();
        boolean invokeMethod = true;
        if (dataformat != null) {
            ret = this.packSubDataFormat(dataformat);
        } else if (subRefDataFormat != null) {
            ret = this.packSubRefDataFormat(subRefDataFormat);
        } else if (this.parseExpr) {
            buildExpr = item.getBuildExpr();
            ret = this.parseItemExpress(buildExpr, item);
        } else {
            buildExpr = item.getBuildExpr();
            if (!StringTools.isEmpty(buildExpr)) {
                if (buildExpr.startsWith("\"")) {
                    ret = buildExpr.substring(1, buildExpr.length() - 1);
                } else {
                    ret = "(" + buildExpr + ")";
                    this.logger.debug(this.getClass().getSimpleName());
                    if (this.getClass().getSimpleName().equals("LenExecutor")) {
                        invokeMethod = false;
                    }
                }
            }
        }
        if (!this.isSubObjectType()) {
            byte[] data = null;
            int valueState = 0;
            if (ret != null) {
                data = ByteTools.getBytes(ret, this.getEncoding());
                if (this.isFilterEmpty() && data != null && data.length == 0) {
                    valueState |= 1;
                    ret = null;
                }
            }
            if (ret == null) {
                data = this.parseDefaultValue(item);
                valueState |= 2;
            }
            if (data == null) {
                if (valueState & true) {
                    if (!this.supportItemMust() || item.getMust()) {
                        throw new DataFormatException("\u5b57\u6bb5[" + OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext) + "]\u8fc7\u6ee4\u7a7a\u4e32\u540e\u503c\u4e3aNULL\uff0c\u8be5\u5b57\u6bb5\u4e3a\u5fc5\u9700\u5b57\u6bb5");
                    }
                    if (this.loggerWarn.isWarnEnabled()) {
                        this.log(3, item, null, params, "(\u8fc7\u6ee4\u7a7a\u4e32\u540e\u503c\u4e3anull)");
                    }
                    return false;
                }
                if (!this.supportItemMust() || item.getMust()) {
                    throw new DataFormatException("\u5b57\u6bb5[" + OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext) + "]\u7684\u503c\u4e3aNULL\uff0c\u8be5\u5b57\u6bb5\u4e3a\u5fc5\u9700\u5b57\u6bb5");
                }
                if (this.loggerWarn.isWarnEnabled()) {
                    this.log(3, item, null, params, "(\u503c\u4e3anull)");
                }
                return false;
            }
            if (invokeMethod) {
                Build build;
                Method[] methodList = null;
                if (item.getMethods() != null && (build = item.getMethods().getBuild()) != null) {
                    methodList = build instanceof CacheBuild ? ((CacheBuild)build).getMethodArr() : build.getMethod();
                }
                data = (byte[])this.invokeMethods(methodList, item, data, 1);
                data = (byte[])this.invokeMethods(this.globalBuildMethod, data, 1);
                data = this.prePackItem(item, data, params);
            }
            if (this.logger.isDebugEnabled()) {
                String tempStr = V_EMPTY;
                if (valueState != 0) {
                    if (valueState == 2) {
                        tempStr = "(\u9ed8\u8ba4\u503c)";
                    } else if (valueState == 3) {
                        tempStr = "(\u8fc7\u6ee4\u7a7a\u4e32\u540e\u53d6\u9ed8\u8ba4\u503c)";
                    }
                }
                this.log(1, item, StringTools.getString(data, this.getEncoding()), params, tempStr);
            }
            this.packItem(item, data, params);
        } else {
            this.log(1, item, StringTools.getString(ret, this.getEncoding()), params, V_EMPTY);
            this.packObjectItem(item, ret, params);
        }
        return true;
    }

    protected byte[] parseDefaultValue(Item item) throws Exception {
        byte[] data = null;
        String defaultExpress = item.getDefaultValue();
        if (!StringTools.isEmpty(defaultExpress)) {
            if (defaultExpress.startsWith(HEXPREFIX_LOWER) || defaultExpress.startsWith(HEXPREFIX_UPPER)) {
                defaultExpress = defaultExpress.substring(2);
                data = StringTools.string2Byte(defaultExpress);
            } else {
                data = ByteTools.getBytes(OgnlTools.getValue(defaultExpress, this.getRootContext()), this.getEncoding());
            }
        }
        return data;
    }

    protected String getRealItemPath(Item item) {
        if (StringTools.isEmpty(this.currentPath)) {
            return item.getPath();
        }
        return this.currentPath + V_DOT + item.getPath();
    }

    protected String getRealWhilePath(While _while) {
        if (StringTools.isEmpty(this.currentPath)) {
            return _while.getPath();
        }
        return this.currentPath + V_DOT + _while.getPath();
    }

    protected byte[] prePackItem(Item item, byte[] data, Map<String, String> params) throws Exception {
        return data;
    }

    public abstract void packItem(Item var1, byte[] var2, Map<String, String> var3) throws Exception;

    public void packObjectItem(Item field, Object data, Map<String, String> paras) throws Exception {
    }

    private void packItemRef(ItemRef itemRef) {
    }

    protected Object packSubDataFormat(DataFormat subDataFormat) throws Exception {
        String clazzName = subDataFormat.getImplClass();
        AbstractExecutor sub = DataFormatRegistry.getDataFormatExecutor(clazzName);
        this.logger.debug("{} @ \u62fc\u5b50\u62a5\u6587:{}", new Object[]{this.getExecutorName(), sub.getExecutorName()});
        sub.setEncoding(subDataFormat.getEncoding());
        sub.setRootContext(this.getRootContext());
        sub.setCurrentContext(this.getCurrentContext());
        sub.setAutoContext(this.getAutoContext());
        sub.setCurrentPath(this.currentPath);
        sub.pack(subDataFormat);
        this.setSubObjectType(sub.isObjectType());
        this.setHiddenInfo(sub.isHiddenInfo());
        return sub.outputData();
    }

    private boolean packSwitch(Switch _switch) throws Exception {
        boolean defaultBranch = true;
        Case[] _case = _switch.getCase();
        for (int i = 0; i < _case.length; ++i) {
            String expression = _case[i].getExpression();
            boolean ret = OgnlTools.getBooleanValue(expression, this.rootContext);
            if (!ret) continue;
            this.logger.debug("{} @ \u5206\u652f\u5165\u53e3,\u6761\u4ef6:{}", new Object[]{this.getExecutorName(), expression});
            this.packCase(_case[i]);
            defaultBranch = false;
            break;
        }
        if (defaultBranch) {
            Default _default = _switch.getDefault();
            if (_default != null) {
                this.logger.debug("{} @ \u5206\u652f\u5165\u53e3,\u7f3a\u7701\u5206\u652f", (Object)this.getExecutorName());
                this.packDefault(_default);
            } else {
                this.logger.warn("{} @ \u672a\u914d\u7f6e\u7f3a\u7701\u5206\u652f", (Object)this.getExecutorName());
                return false;
            }
        }
        return true;
    }

    protected int parseLoopCount(While _while) throws Exception {
        String count = _while.getMaxNum();
        int nCount = 0;
        String sCount = null;
        if (StringTools.isEmpty(count)) {
            sCount = this.getRealWhilePath(_while);
            Object o = OgnlTools.getValue(sCount, this.rootContext);
            if (o != null && o instanceof List) {
                List list = (List)o;
                nCount = list.size();
            } else {
                nCount = 0;
                this.logger.warn("{} @ \u5faa\u73af[{}]\u5bf9\u5e94\u7684\u7ed3\u6784\u4e0d\u5b58\u5728", new Object[]{this.getExecutorName(), sCount});
            }
        } else {
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
            }
            catch (Exception e1) {
                throw new Exception(this.getExecutorName() + " @ \u5faa\u73af\u6b21\u6570\u53d8\u91cf[" + count + "]\u53d6\u503c\u5f02\u5e38:", e1);
            }
            if (StringTools.isEmpty(sCount)) {
                throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u7684\u5faa\u73af\u6b21\u6570[" + count + "]\u53d8\u91cf\u503c\u4e0d\u5b58\u5728");
            }
            try {
                nCount = Integer.parseInt(sCount);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u5faa\u73af\u6b21\u6570\u5fc5\u987b\u662f\u6570\u5b57, \u76ee\u524d=" + sCount, e);
            }
        }
        return nCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int parseLoopCount(While _while, Map<String, Object> context) throws Exception {
        String count = _while.getMaxNum();
        int nCount = 0;
        String sCount = null;
        if (StringTools.isEmpty(count)) {
            sCount = this.getRealWhilePath(_while);
            Object o = OgnlTools.getValue(sCount = OgnlTools.parseXPath(sCount, this.getRootContext()), context);
            if (o == null) throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u83b7\u53d6\u5faa\u73af\u6b21\u6570\u5f02\u5e38");
            if (!(o instanceof List)) throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u83b7\u53d6\u5faa\u73af\u6b21\u6570\u5f02\u5e38");
            List list = (List)o;
            return list.size();
        }
        try {
            sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
        }
        catch (Exception e) {
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, context));
            }
            catch (Exception e1) {
                throw new Exception(this.getExecutorName() + " @ \u5faa\u73af\u6b21\u6570\u53d8\u91cf[" + count + "]\u53d6\u503c\u5f02\u5e38:", e1);
            }
        }
        if (StringTools.isEmpty(sCount)) {
            throw new Exception(this.getExecutorName() + " @ \u5faa\u73af[" + this.getRealWhilePath(_while) + "]\u7684\u5faa\u73af\u6b21\u6570[" + count + "]\u53d8\u91cf\u503c\u4e0d\u5b58\u5728");
        }
        try {
            return Integer.parseInt(sCount);
        }
        catch (Exception e) {
            throw new Exception(this.getExecutorName() + " @ \u5faa\u73af\u6b21\u6570\u5fc5\u987b\u662f\u6570\u5b57, \u76ee\u524d=" + sCount, e);
        }
    }

    protected void packWhile(While _while) throws Exception {
        String varname = _while.getVar();
        int nCount = this.parseLoopCount(_while);
        for (int i = 0; i < nCount; ++i) {
            this.rootContext.put(varname, new Integer(i));
            this.packBody(_while.getBody());
        }
        this.rootContext.remove(varname);
    }

    protected String parseExpressStringValue(String expr) throws Exception {
        String result = null;
        if (!StringTools.isEmpty(expr)) {
            result = StringTools.getString(this.parseExpress(expr));
        }
        return result;
    }

    protected Object parseExpress(String expr) throws Exception {
        Object ret;
        block2: {
            ret = null;
            try {
                ret = OgnlTools.getValue(expr, this.rootContext);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("\u89e3\u6790\u8868\u8fbe\u5f0f[{}]\u5f02\u5e38:{}", new Object[]{expr, e.getMessage()});
            }
        }
        return ret;
    }

    protected Object parseItemExpress(String expr, Item item) throws Exception {
        Object ret;
        block3: {
            ret = null;
            Map<String, Object> map = this.rootContext;
            boolean notlogwarn = false;
            try {
                if (StringTools.isEmpty(expr)) {
                    expr = this.getRealItemPath(item);
                    notlogwarn = true;
                }
                ret = OgnlTools.getValue(expr, map);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled() || notlogwarn) break block3;
                this.logger.warn("{} @ \u62fc\u5305:{},\u89e3\u6790\u8868\u8fbe\u5f0f[{}]\u5f02\u5e38:{}", new Object[]{this.getExecutorName(), OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext), expr, e.getMessage()});
            }
        }
        return ret;
    }

    public void setDataFormatEnd() {
        this.end = true;
    }

    public boolean isDataFormatEnd() {
        return this.end;
    }

    public void setHiddenInfo(boolean hiddenInfo) {
        this.hiddenInfo = hiddenInfo;
    }

    public void setPackType(int packType) {
        this.packType = packType;
    }

    protected boolean supportItemMust() {
        return false;
    }

    public String transferHiddenInfo(String key, String value) {
        return value;
    }

    @Override
    public void unPack(DataFormat dataformat, S data) throws Exception {
        if (dataformat == null) {
            throw new DataFormatException(this.getExecutorName() + " @ \u62a5\u6587\u914d\u7f6e\u4e3a\u7a7a");
        }
        this.unPackInner(dataformat, data);
    }

    private void unPackInner(DataFormat dataformat, S data) throws Exception {
        this.packType = DATAFORMAT_UNPACK;
        Map<String, String> pro = this.packHead(dataformat.getHead());
        this.setAutoUnPack(V_TRUE.equals(pro.get(PROPERTY_AUTO_UNPACK)));
        this.setAutoUnpackSave(V_TRUE.equals(pro.get(PROPERTY_AUTO_UNPACK_SAVE)));
        this.setAutoUnpackVar(pro.get(PROPERTY_AUTO_UNPACK_VAR));
        this.initDataformat(dataformat, pro);
        this.inputData(data);
        if (this.isAutoUnpack()) {
            this.autoUnpackInner();
        } else {
            if (this.isAutoUnpackSave()) {
                this.autoUnpackInner();
            }
            this.unPackBody(dataformat.getBody());
        }
    }

    private void initDataformat(DataFormat dataformat, Map<String, String> pro) throws Exception {
        this.end = false;
        if (dataformat.getMethods() != null) {
            Parse parse;
            Build build = dataformat.getMethods().getBuild();
            if (build != null) {
                this.globalBuildMethod = build instanceof CacheBuild ? ((CacheBuild)build).getMethodArr() : build.getMethod();
            }
            if ((parse = dataformat.getMethods().getParse()) != null) {
                this.globalParseMethod = parse instanceof CacheParse ? ((CacheParse)parse).getMethodArr() : parse.getMethod();
            }
        }
        this.init(pro);
    }

    private void autoUnpackInner() throws Exception {
        Object obj = this.autoUnpack();
        String path = this.getCurrentPathUnpack();
        if (path == null) {
            path = V_EMPTY;
        }
        if (!StringTools.isEmpty(this.getCurrentPath()) && !StringTools.isEmpty(path)) {
            path = this.getCurrentPath() + V_DOT + path;
        }
        if (obj instanceof Map) {
            Map unpackMap = (Map)obj;
            if (StringTools.isEmpty(this.getAutoUnpackVar()) || this.getAutoUnpackVar().equals("ctx") || this.getAutoUnpackVar().equals("context")) {
                this.getAutoContext().putAll(unpackMap);
                this.getRootContext().putAll(unpackMap);
                if (this.logger.isDebugEnabled()) {
                    this.log(unpackMap, path, V_EMPTY, this.logger, 1, this.getExecutorName() + " @ \u81ea\u62c6:");
                }
            } else {
                OgnlTools.setValue(this.getAutoUnpackVar(), unpackMap, this.getRootContext());
                OgnlTools.setValue(this.getAutoUnpackVar(), unpackMap, this.getAutoContext());
                if (this.logger.isDebugEnabled()) {
                    HashMap<String, Map> tempMap = new HashMap<String, Map>();
                    tempMap.put(this.getAutoUnpackVar(), unpackMap);
                    this.log(tempMap, path, V_EMPTY, this.logger, 1, this.getExecutorName() + " @ \u81ea\u62c6:");
                }
            }
        } else if (obj instanceof List) {
            List templist = (List)obj;
            if (StringTools.isEmpty(this.getAutoUnpackVar())) {
                throw new Exception(this.getExecutorName() + " @ \u81ea\u52a8\u62c6\u5305\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OgnlTools.setValue(this.getAutoUnpackVar(), templist, this.getRootContext());
            OgnlTools.setValue(this.getAutoUnpackVar(), templist, this.getAutoContext());
            if (this.logger.isDebugEnabled()) {
                HashMap<String, List> tempMap = new HashMap<String, List>();
                tempMap.put(this.getAutoUnpackVar(), templist);
                this.log(tempMap, path, V_EMPTY, this.logger, 1, this.getExecutorName() + " @ \u81ea\u62c6:");
            }
        }
    }

    protected Object autoUnpack() throws Exception {
        throw new Exception(this.getExecutorName() + " @ \u4e0d\u652f\u6301\u81ea\u52a8\u62c6\u5305");
    }

    protected void unPackBody(Body body) throws Exception {
        BodyItem[] items = body instanceof CacheBody ? ((CacheBody)body).getBodyItemArr() : body.getBodyItem();
        for (int i = 0; i < items.length; ++i) {
            this.unPackBodyItem(items[i].getChoiceValue());
        }
    }

    protected void unPackBodyItem(Object choiceValue) throws Exception {
        if (choiceValue instanceof Item) {
            this.unPackItem((Item)choiceValue);
        } else if (choiceValue instanceof Group) {
            this.unPackGroup((Group)choiceValue);
        } else if (choiceValue instanceof While) {
            this.unPackWhile((While)choiceValue);
        } else if (choiceValue instanceof Switch) {
            this.unPackSwitch((Switch)choiceValue);
        } else if (choiceValue instanceof DataFormatRef) {
            this.unPackDataFormatRef((DataFormatRef)choiceValue);
        } else if (choiceValue instanceof ItemRef) {
            this.unPackItemRef((ItemRef)choiceValue);
        } else {
            throw new DataFormatException(this.getExecutorName() + " @ \u5b57\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301");
        }
    }

    private void unPackCase(Case _case) throws Exception {
        this.unPackBody(_case.getBody());
    }

    protected void unPackDataFormatRef(DataFormatRef _dataformatref) throws Exception {
        String refName = _dataformatref.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(_dataformatref.getFileName(), this.getRootContext()));
        this.logger.debug("{} @ \u62c6\u5f15\u7528\u62a5\u6587,\u5f15\u7528\u540d:{},\u8def\u5f84:{}", new Object[]{this.getExecutorName(), refName, messageName});
        String oldPath = this.currentPath;
        this.currentPath = StringTools.isEmpty(this.currentPath) ? _dataformatref.getPath() : this.currentPath + V_DOT + _dataformatref.getPath();
        DataFormat dataFormat = DataFormatTools.loadDataFormat(messageName);
        this.unPackBody(dataFormat.getBody());
        this.currentPath = oldPath;
    }

    protected void unPackSubRefDataFormat(SubRefDataFormat _dataformatref, Object srcData) throws Exception {
        String oldPath = this.currentPath;
        this.currentPath = StringTools.isEmpty(this.currentPath) ? _dataformatref.getPath() : this.currentPath + V_DOT + _dataformatref.getPath();
        String refName = _dataformatref.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(_dataformatref.getFileName(), this.getRootContext()));
        this.logger.debug("{} @ \u62c6\u5b50\u5f15\u7528\u62a5\u6587,\u5f15\u7528\u540d:{},\u8def\u5f84:{}", new Object[]{this.getExecutorName(), refName, messageName});
        DataFormat dataFormat = DataFormatTools.loadDataFormat(messageName);
        this.unPackBody(dataFormat.getBody());
        this.unPackSubDataFormat(dataFormat, srcData);
        this.currentPath = oldPath;
    }

    private void unPackDefault(Default _default) throws Exception {
        this.unPackBody(_default.getBody());
    }

    protected void unPackGroup(Group group) throws Exception {
        Map cContext;
        String name = group.getName();
        Map<String, Object> oldContext = this.currentContext;
        Map<String, Object> oldUnpackContext = this.autoContext;
        Object o = this.currentContext.get(name);
        if (o != null && o instanceof Map) {
            cContext = (Map)o;
        } else {
            cContext = new HashMap();
            this.currentContext.put(name, cContext);
            this.autoContext.put(name, cContext);
        }
        this.currentContext = cContext;
        this.autoContext = cContext;
        String oldpath = this.getCurrentPathUnpack();
        this.setCurrentPathUnpack(group.getPath());
        this.unPackBody(group.getBody());
        this.setCurrentPathUnpack(oldpath);
        this.currentContext = oldContext;
        this.autoContext = oldUnpackContext;
    }

    protected void unPackItem(Item item) throws Exception {
        String dataType = item.getType();
        Map<String, Object> ctx = this.currentContext;
        Map<String, String> params = this.packHead(item.getHead());
        if (this.isObjectType()) {
            Object objItem = this.unPackObjectItem(item, params);
            String appendStr = V_EMPTY;
            if (this.logger.isDebugEnabled()) {
                String sData = StringTools.getString(objItem, this.getEncoding());
                this.log(1, item, sData, params, appendStr);
            }
            ctx.put(item.getName(), objItem);
            this.autoContext.put(item.getName(), objItem);
            DataFormat subDataFormat = item.getDataFormat();
            SubRefDataFormat subRefDataFormat = item.getSubRefDataFormat();
            if (subDataFormat != null) {
                this.unPackSubDataFormat(subDataFormat, objItem);
            } else if (subRefDataFormat != null) {
                this.unPackSubRefDataFormat(subRefDataFormat, objItem);
            }
        } else {
            Parse parse;
            byte[] byItem = this.unPackItem(item, params);
            String appendStr = V_EMPTY;
            if (byItem == null) {
                if (!this.supportItemMust() || item.getMust()) {
                    throw new DataFormatException(this.getExecutorName() + " @ " + OgnlTools.parseXPath(this.getRealItemPath(item), this.rootContext) + "\u503c\u4e3aNULL");
                }
                String defaultValue = item.getDefaultValue();
                Object o = null;
                if (!StringTools.isEmpty(defaultValue)) {
                    try {
                        o = OgnlTools.getValue(defaultValue, this.rootContext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (o == null) {
                    if (this.loggerWarn.isWarnEnabled()) {
                        this.log(3, item, null, params, V_EMPTY);
                    }
                    return;
                }
                byItem = ByteTools.getBytes(o, this.getEncoding());
                appendStr = "(\u9ed8\u8ba4\u503c)";
            }
            Method[] methodList = null;
            if (item.getMethods() != null && (parse = item.getMethods().getParse()) != null) {
                methodList = parse instanceof CacheParse ? ((CacheParse)parse).getMethodArr() : parse.getMethod();
            }
            byItem = (byte[])this.invokeMethods(methodList, item, byItem, 1);
            byItem = (byte[])this.invokeMethods(this.globalParseMethod, byItem, 1);
            if (this.logger.isDebugEnabled()) {
                String sData = StringTools.getString(byItem, this.getEncoding());
                this.log(1, item, sData, params, appendStr);
            }
            Object v = this.itemTypeConvert(dataType, byItem);
            ctx.put(item.getName(), v);
            this.autoContext.put(item.getName(), v);
            DataFormat subDataFormat = item.getDataFormat();
            SubRefDataFormat subRefDataFormat = item.getSubRefDataFormat();
            if (subDataFormat != null) {
                this.unPackSubDataFormat(subDataFormat, byItem);
            } else if (subRefDataFormat != null) {
                this.unPackSubRefDataFormat(subRefDataFormat, byItem);
            }
        }
    }

    public abstract byte[] unPackItem(Item var1, Map<String, String> var2) throws Exception;

    public Object unPackObjectItem(Item field, Map<String, String> paras) throws Exception {
        return null;
    }

    protected void unPackItemRef(ItemRef itemRef) {
    }

    protected void unPackSubDataFormat(DataFormat subDataFormat, Object subData) throws Exception {
        String clazzName = subDataFormat.getImplClass();
        AbstractExecutor sub = DataFormatRegistry.getDataFormatExecutor(clazzName);
        this.logger.debug("{} @ \u62c6\u5b50\u62a5\u6587:{}", new Object[]{this.getExecutorName(), sub.getExecutorName()});
        sub.setEncoding(subDataFormat.getEncoding());
        sub.setRootContext(this.getRootContext());
        sub.setCurrentContext(this.getCurrentContext());
        sub.setAutoContext(this.getAutoContext());
        sub.setCurrentPath(this.currentPath);
        sub.setCurrentPathUnpack(this.getCurrentPathUnpack());
        sub.unPack(subDataFormat, subData);
    }

    protected void unPackSwitch(Switch _switch) throws Exception {
        Default _default;
        Case[] cases = _switch.getCase();
        boolean flag = true;
        for (int i = 0; i < cases.length; ++i) {
            String expr = cases[i].getExpression();
            if (!OgnlTools.getBooleanValue(expr, this.rootContext).booleanValue()) continue;
            this.logger.debug("{} @ \u6761\u4ef6\u8868\u8fbe\u5f0f\u4e3a:{}", new Object[]{this.getExecutorName(), expr});
            this.unPackCase(cases[i]);
            flag = false;
            break;
        }
        if (flag && (_default = _switch.getDefault()) != null) {
            this.logger.debug("{} @ \u7f3a\u7701\u5206\u652f", (Object)this.getExecutorName());
            this.unPackDefault(_default);
        }
    }

    protected void unPackWhile(While _while) throws Exception {
        String count = _while.getMaxNum();
        String name = _while.getName();
        String varname = _while.getVar();
        String sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
        int nCount = 0;
        try {
            nCount = Integer.parseInt(sCount);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5faa\u73af\u6b21\u6570\u5fc5\u987b\u662f\u6570\u5b57, \u76ee\u524d=" + sCount, e);
        }
        this.unPackWhile(nCount, name, varname, _while);
    }

    protected void unPackWhile(int nCount, String name, String varname, While _while) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(nCount);
        Map<String, Object> oldContext = this.getCurrentContext();
        oldContext.put(name, list);
        String oldPath = this.getCurrentPathUnpack();
        for (int i = 0; i < nCount; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            list.add(map);
            map.put(varname, new Integer(i));
            this.rootContext.put(varname, new Integer(i));
            this.currentContext = map;
            this.setCurrentPathUnpack(OgnlTools.parseXPath(_while.getPath() + V_BRACKET_LEFT + _while.getVar() + V_BRACKET_RIGHT, this.currentContext));
            this.unPackBody(_while.getBody());
            map.remove(varname);
            if (!this.end) continue;
            if (!this.logger.isDebugEnabled()) break;
            this.logger.debug("{} @ \u5faa\u73af\u62a5\u6587,{},\u5df2\u5faa\u73af\u6b21\u6570:{}", new Object[]{this.getExecutorName(), name, String.valueOf(i + 1)});
            break;
        }
        this.setCurrentPathUnpack(oldPath);
        this.rootContext.remove(varname);
        this.currentContext = oldContext;
    }

    public void parserDataByGlobalMethod(Object data, int valueType, Method[] methodList) throws DataFormatException {
        try {
            if (data instanceof Map) {
                Map map = (Map)data;
                Object value = null;
                for (String key : map.keySet()) {
                    value = map.get(key);
                    if (value instanceof byte[] || value instanceof String) {
                        value = this.invokeMethods(methodList, value, valueType);
                        map.put(key, value);
                        continue;
                    }
                    if (value instanceof Map) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                        continue;
                    }
                    if (value instanceof List) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                        continue;
                    }
                    this.logger.debug("{} @ \u5b57\u6bb5:{},\u7c7b\u578b[{}]\u80fd\u4e3a\u65b9\u6cd5\u5165\u53c2\u7c7b\u578b", new Object[]{this.getExecutorName(), key, value.getClass().getName()});
                }
            } else if (data instanceof List) {
                List list = (List)data;
                for (Object value : list) {
                    if (value instanceof byte[] || value instanceof String) {
                        value = this.invokeMethods(methodList, value, valueType);
                        list.add(value);
                        continue;
                    }
                    if (value instanceof Map) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                        continue;
                    }
                    if (value instanceof List) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                        continue;
                    }
                    this.logger.debug("{} @ \u7c7b\u578b[{}]\u80fd\u4e3a\u65b9\u6cd5\u5165\u53c2\u7c7b\u578b", new Object[]{this.getExecutorName(), value.getClass().getName()});
                }
            }
        }
        catch (Exception e) {
            throw new DataFormatException("\u8c03\u7528\u5168\u5c40\u65b9\u6cd5\u6267\u884c\u5f02\u5e38", e);
        }
    }

    public void log(Object map, String path, String key, Logger logger, int level, String info) throws UnsupportedEncodingException {
        if (path.length() > 0 && path.charAt(0) == '.') {
            path = path.substring(1);
        }
        if (map instanceof Map) {
            Map m = (Map)map;
            map.hashCode();
            for (Map.Entry element : m.entrySet()) {
                this.log(element.getValue(), path + V_DOT + (String)element.getKey(), (String)element.getKey(), logger, level, info);
            }
        } else if (map instanceof List) {
            List list = (List)map;
            for (int i = 0; i < list.size(); ++i) {
                this.log(list.get(i), path + V_BRACKET_LEFT + i + V_BRACKET_RIGHT, V_EMPTY, logger, level, info);
            }
        } else {
            String sv = StringTools.getString(map, this.getEncoding());
            StringBuffer buffer = new StringBuffer();
            if (info != null && info.length() > 0) {
                buffer.append(info);
            }
            buffer.append(path);
            buffer.append("=[");
            buffer.append(sv);
            buffer.append(V_BRACKET_RIGHT);
            logger.debug(buffer.toString());
        }
    }

    public boolean isSimpleType(Object obj) {
        return obj instanceof byte[] || obj instanceof String || obj instanceof Number || obj instanceof Character;
    }

    public boolean isAutoPack() {
        return this.autoPack;
    }

    public void setAutoPack(boolean autoPack) {
        this.autoPack = autoPack;
    }

    public boolean isDataMessage() {
        return this.dataMessage;
    }

    public String getMessageType() {
        return MESSAGE_TYPE_OTHERS;
    }

    public boolean isSubObjectType() {
        return this.subObjectType;
    }

    public void setSubObjectType(boolean subObjectType) {
        this.subObjectType = subObjectType;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean subMessageType() {
        return false;
    }

    public void setDataMessage(boolean dataMessage) {
        this.dataMessage = dataMessage;
    }

    protected boolean isFilterEmpty() {
        return this.filterEmpty;
    }

    protected void setFilterEmpty(boolean filterEmpty) {
        this.filterEmpty = filterEmpty;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    public String getCurrentPathUnpack() {
        return this.currentPathUnpack;
    }

    public void setCurrentPathUnpack(String currentPathUnpack) {
        this.currentPathUnpack = currentPathUnpack;
    }

    public String getAutoPackVar() {
        return this.autoPackVar;
    }

    public void setAutoPackVar(String autoPackVar) {
        this.autoPackVar = autoPackVar;
    }

    public String getAutoUnpackVar() {
        return this.autoUnpackVar;
    }

    public void setAutoUnpackVar(String autoUnpackVar) {
        this.autoUnpackVar = autoUnpackVar;
    }

    public boolean isAutoUnpackSave() {
        return this.autoUnpackSave;
    }

    public void setAutoUnpackSave(boolean autoUnpackSave) {
        this.autoUnpackSave = autoUnpackSave;
    }

    public boolean isUnpackEmptyCheck() {
        return this.unpackEmptyCheck;
    }

    public void setUnpackEmptyCheck(boolean unpackEmptyCheck) {
        this.unpackEmptyCheck = unpackEmptyCheck;
    }

    public Method[] getGlobalBuildMethod() {
        return this.globalBuildMethod;
    }

    public void setGlobalBuildMethod(Method[] globalBuildMethod) {
        this.globalBuildMethod = globalBuildMethod;
    }

    public Method[] getGlobalParseMethod() {
        return this.globalParseMethod;
    }

    public void setGlobalParseMethod(Method[] globalParseMethod) {
        this.globalParseMethod = globalParseMethod;
    }

    public boolean isParseExpr() {
        return this.parseExpr;
    }

    public void setParseExpr(boolean parseExpr) {
        this.parseExpr = parseExpr;
    }

    public abstract int getSearchIndex();
}

