/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat;

import cn.com.yusys.yusp.bsp.schema.dataformat.lib.Dataformat;
import cn.com.yusys.yusp.bsp.schema.dataformat.lib.DataformatDefinition;
import cn.com.yusys.yusp.bsp.toolkit.xml.CastorTools;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static String getShortDataformatClassName(String className) {
        if (className.startsWith("cn.com.yusys.yusp.bsp.dataformat.impl")) {
            return className.substring("cn.com.yusys.yusp.bsp.dataformat.impl".length() + 1);
        }
        return className;
    }

    public static String getFullDataformatClassName(String shortClassName) {
        return "cn.com.yusys.yusp.bsp.dataformat.impl." + shortClassName;
    }

    public static String getFullMappingStrategyClassName(String shortClassName) {
        return "cn.com.yusys.yusp.bsp.workflow.mapping." + shortClassName;
    }

    public static DataformatDefinition loadDefinitionFile(String filePath) throws Exception {
        return (DataformatDefinition)CastorTools.unmarshaller(filePath, DataformatDefinition.class, Utils.class.getClassLoader());
    }

    public static DataformatDefinition loadDefinitionFile(InputStream is) throws Exception {
        return (DataformatDefinition)CastorTools.unmarshaller(is, DataformatDefinition.class);
    }

    public static DataformatDefinition loadDefinitionFile(File file) throws Exception {
        return (DataformatDefinition)CastorTools.unmarshaller(file, DataformatDefinition.class, Utils.class.getClassLoader());
    }

    public static List<Dataformat> getAllComponent(DataformatDefinition def) {
        Dataformat[] cs;
        ArrayList<Dataformat> compList = new ArrayList<Dataformat>();
        for (Dataformat c : cs = def.getDataformat()) {
            compList.add(c);
        }
        return compList;
    }

    public static Class<?> loadDataformatClass(ClassLoader classLoader, String shortClassName) throws Exception {
        return classLoader.loadClass(Utils.getFullDataformatClassName(shortClassName));
    }

    public static Class<?> loadMappingStrategyClass(ClassLoader classLoader, String shortClassName) throws Exception {
        return classLoader.loadClass(Utils.getFullMappingStrategyClassName(shortClassName));
    }
}

