/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DataFormatTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgConvertUtil {
    protected static Logger logger = LoggerFactory.getLogger(MsgConvertUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] packMsg(Map<String, Object> context, String msgpath, String msgtype, String encode) throws Exception {
        AbstractExecutor messageExecutor;
        DataFormat dataFormat = null;
        if (StringTools.isEmpty(msgpath)) {
            if (StringTools.isEmpty(msgtype)) throw new Exception("\u62a5\u6587\u683c\u5f0f\u672a\u914d\u7f6e");
            if (StringTools.isEmpty(encode)) throw new Exception("\u62a5\u6587\u683c\u5f0f\u672a\u914d\u7f6e");
            Class<?> clazz = DataFormatRegistry._simpleDataformatRegistry.get(msgtype);
            if (clazz == null) {
                throw new Exception("\u62a5\u6587\u89e3\u6790\u5668[" + msgtype + "]\u4e0d\u5b58\u5728");
            }
            messageExecutor = (AbstractExecutor)clazz.newInstance();
            messageExecutor.setEncoding(encode);
            dataFormat = DataFormatRegistry.getDataformat(msgtype, encode);
        } else {
            dataFormat = DataFormatTools.loadDataFormat(msgpath);
            if (dataFormat == null) {
                throw new ComponentException("\u62a5\u6587\u683c\u5f0f\u672a\u914d\u7f6e");
            }
            messageExecutor = DataFormatRegistry.getDataFormatExecutor(dataFormat.getImplClass());
            messageExecutor.setEncoding(dataFormat.getEncoding());
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} @ \u62fc\u5305\uff0c\u62a5\u6587=[{}]", (Object)messageExecutor.getExecutorName(), (Object)(StringTools.isEmpty(msgpath) ? "\u672a\u4f7f\u7528\u62a5\u6587\u914d\u7f6e\u6587\u4ef6" : msgpath));
        }
        messageExecutor.setRootContext(context);
        messageExecutor.setCurrentContext(context);
        messageExecutor.setAutoContext((Map)context.get("__T_AUTOPACK"));
        messageExecutor.pack(dataFormat);
        Object ret = messageExecutor.outputData();
        return ByteTools.getBytes(ret, dataFormat.getEncoding());
    }

    public static Map<String, Object> unpackMsg(byte[] data, Map<String, Object> context, String msgpath, String msgtype, String encode) throws Exception {
        AbstractExecutor messageExecutor;
        DataFormat dataFormat = null;
        if (StringTools.isEmpty(msgpath)) {
            if (StringTools.isEmpty(encode)) {
                throw new Exception("\u62a5\u6587\u683c\u5f0f[" + msgtype + "]\u7684\u62a5\u6587\u7f16\u7801\u672a\u914d\u7f6e");
            }
            Class<?> clazz = DataFormatRegistry._simpleDataformatRegistry.get(msgtype);
            if (clazz == null) {
                if (msgtype.equals("OTHER")) {
                    throw new Exception("\u590d\u6742\u62a5\u6587\u5fc5\u987b\u914d\u7f6e");
                }
                throw new Exception("\u62a5\u6587\u683c\u5f0f[" + msgtype + "]\u672a\u914d\u7f6e");
            }
            messageExecutor = (AbstractExecutor)clazz.newInstance();
            messageExecutor.setEncoding(encode);
            dataFormat = DataFormatRegistry.getDataformat(msgtype, encode);
        } else {
            dataFormat = DataFormatTools.loadDataFormat(msgpath);
            if (dataFormat == null) {
                throw new ComponentException("\u62a5\u6587\u5b9a\u4e49\u6587\u4ef6[" + msgpath + "]\u4e0d\u5b58\u5728");
            }
            messageExecutor = DataFormatRegistry.getDataFormatExecutor(dataFormat.getImplClass());
            messageExecutor.setEncoding(dataFormat.getEncoding());
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} @ \u62c6\u5305\uff0c\u62a5\u6587=[{}]", (Object)messageExecutor.getExecutorName(), (Object)(StringTools.isEmpty(msgpath) ? "\u672a\u4f7f\u7528\u62a5\u6587\u914d\u7f6e\u6587\u4ef6" : msgpath));
        }
        messageExecutor.setRootContext(context);
        messageExecutor.setCurrentContext(context);
        messageExecutor.unPack(dataFormat, data);
        int searchIndex = messageExecutor.getSearchIndex();
        context.put("__T_SEARCHINDEX", searchIndex);
        return messageExecutor.getAutoContext();
    }
}

