/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.in;

import cn.com.yusys.yusp.bsp.communication.AbstractAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.IInAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.log.BspSpan;
import cn.com.yusys.yusp.bsp.resources.log.Slf4jSpanLogger;
import cn.com.yusys.yusp.bsp.resources.pool.thread.ExecutorWrapper;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.config.ServiceConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.BizWorker;
import cn.com.yusys.yusp.bsp.workflow.worker.IWorker;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractInAdapter
extends AbstractAdapter
implements IInAdapter {
    private ServiceConfig serviceConfig;
    private ExecutorWrapper executorWrapper;
    private IComm comm;
    protected Map<String, IRequest> usedRequestMap = new ConcurrentHashMap<String, IRequest>();

    public Map<String, IRequest> getUsedRequestMap() {
        return this.usedRequestMap;
    }

    public void setUsedRequestMap(Map<String, IRequest> usedRequestMap) {
        this.usedRequestMap = usedRequestMap;
    }

    @Override
    public void putRequest(String sessionId, IRequest request) {
        this.usedRequestMap.put(sessionId, request);
        request.setSessionId(sessionId);
        Object object = request.getDatasourceWrapper();
        if (object instanceof SocketWrapper) {
            SocketWrapper wrapper = (SocketWrapper)object;
            wrapper.setSessionId(sessionId);
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        Iterator<IRequest> iter = this.getUsedRequestMap().values().iterator();
        try {
            while (iter.hasNext()) {
                IRequest req = iter.next();
                req.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getUsedRequestMap().clear();
    }

    @Override
    public void run() {
        try {
            this.beforeAction();
        }
        catch (Exception e1) {
            this.logger.error("{} @ \u52a8\u4f5c\u9884\u5904\u7406\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e1);
        }
        while (this.isAlive()) {
            try {
                IRequest req = this.makeRequest();
                if (req == null) continue;
                this.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                this.logger.error("{} @ \u76d1\u542c\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
            }
        }
        LogbackUtil.removeLogInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerRequest(IRequest request) throws Exception {
        if (request instanceof StreamRequest) {
            Slf4jSpanLogger spanLogger = new Slf4jSpanLogger();
            try {
                Session session = new Session();
                BspSpan span = new BspSpan();
                spanLogger.logStartedSpan(span, span);
                session.setSpan(span);
                String sn = span.getStringTraceId();
                Object o = ((StreamRequest)request).getDatasourceWrapper();
                if (o instanceof SocketWrapper) {
                    session.getContext().put("G_CLIENT_IP", ((SocketWrapper)o).getSocket().getInetAddress().getHostAddress());
                    session.getContext().put("G_CLIENT_PORT", ((SocketWrapper)o).getSocket().getPort());
                    this.logger.info("{} @ \u901a\u8baf\u8fde\u63a5\uff1a{}", new Object[]{this.getAdapterTypeName(), ((SocketWrapper)o).getSocket()});
                } else if (o instanceof Socket) {
                    session.getContext().put("G_CLIENT_IP", ((Socket)o).getInetAddress().getHostAddress());
                    session.getContext().put("G_CLIENT_PORT", ((Socket)o).getPort());
                    this.logger.info("{} @ \u901a\u8baf\u8fde\u63a5\uff1a{}", new Object[]{this.getAdapterTypeName(), o});
                }
                session.setSessionId(sn);
                session.setF5Check(this.getMsgConfig().isF5Check());
                session.setBsn(sn);
                session.setInRequest(request);
                session.getContext().put("G_SN", sn);
                session.getContext().put("G_BSN", session.getBsn());
                session.getContext().put("T_SESSION", session);
                request.getInAdapter().putRequest(session.getSessionId(), request);
                this.comm.setMsgConfig(this.getMsgConfig());
                session.setComm(this.comm);
                IWorker worker = this.createBizWorker(session);
                this.executorWrapper.execute(worker);
            }
            catch (Throwable e) {
                this.logger.error("\u5904\u7406\u63a5\u5165\u9002\u914d\u5668\u8bf7\u6c42\u5f02\u5e38\uff0c\u8be5\u8bf7\u6c42\u4e0d\u5904\u7406:{}", e);
                try {
                    request.setCloseFlag(true);
                    request.returnToInAdapter();
                }
                catch (Exception e1) {
                    this.logger.error("\u5f52\u8fd8\u8fde\u63a5\u5f02\u5e38", (Throwable)e1);
                }
            }
            finally {
                spanLogger.logStoppedSpan();
            }
        } else {
            throw new Exception("\u6d88\u606f\u5206\u53d1\u5668 @ \u4e0d\u652f\u6301\u8bf7\u6c42\u7c7b\u578b:" + request.getRequestType());
        }
    }

    public abstract IRequest makeRequest() throws Exception;

    public abstract void unmakeRequest(IRequest var1) throws Exception;

    public void beforeAction() throws Exception {
    }

    @Override
    public void returnRequest(IRequest request) throws Exception {
        if (request.getSessionId() != null) {
            this.getUsedRequestMap().remove(request.getSessionId());
        }
        this.unmakeRequest(request);
        request.setSessionId(null);
        if (request.getDatasourceWrapper() instanceof SocketWrapper) {
            SocketWrapper wrapper = (SocketWrapper)request.getDatasourceWrapper();
            wrapper.setSessionId(null);
        }
    }

    @Override
    public int getAdapterType() {
        return 0;
    }

    public boolean isAvalible(IRequest request) {
        StreamRequest requestStream = (StreamRequest)request;
        return !requestStream.needToClose();
    }

    protected Object getInParameterValue(String paraName, Map<String, Object> context) throws Exception {
        return this.getInParameterValue(paraName, context, true);
    }

    protected Object getInParameterValue(String paraName, Map<String, Object> context, boolean translate) throws Exception {
        return context.get(paraName);
    }

    protected IWorker createBizWorker(Session session) {
        BizWorker worker = new BizWorker();
        worker.setSession(session);
        worker.setMsgConfig(this.getMsgConfig());
        worker.setServiceConfig(this.serviceConfig);
        return worker;
    }

    public ExecutorWrapper getExecutorWrapper() {
        return this.executorWrapper;
    }

    public void setExecutorWrapper(ExecutorWrapper executorWrapper) {
        this.executorWrapper = executorWrapper;
    }

    public IComm getComm() {
        return this.comm;
    }

    public void setComm(IComm comm) {
        this.comm = comm;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }
}

