/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.BspAutoConfiguration;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.filter.BspFilter;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.workflow.BspController;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.TradeMapping;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import cn.com.yusys.yusp.bsp.workflow.config.ServiceConfig;
import cn.com.yusys.yusp.bsp.workflow.worker.AbstractDataProcess;
import cn.com.yusys.yusp.bsp.workflow.worker.IServiceUrl;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AppStartAssist {
    private static Logger logger = LoggerFactory.getLogger(AppStartAssist.class);
    public static final String CONFIG_MODULE_FILE = "module.mrd";
    public static final String CONFIG_MODULE_PATH = "classpath*:config/*/*/*.mrd";
    private static SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();
    private static Map<String, ServiceEntity> _serviceEntityMap = new ConcurrentHashMap<String, ServiceEntity>();

    public static void startModule() throws Exception {
        try {
            String[] array = BspAutoConfiguration.applicationContext.getBeanNamesForAnnotation(BspController.class);
            for (int i = 0; i < array.length; ++i) {
                Object obean = BspAutoConfiguration.applicationContext.getBean(array[i]);
                Method[] methods = obean.getClass().getDeclaredMethods();
                for (int j = 0; j < methods.length; ++j) {
                    TradeMapping tradeMapping = methods[j].getAnnotation(TradeMapping.class);
                    if (tradeMapping == null) continue;
                    String value = tradeMapping.value();
                    String code = tradeMapping.code();
                    if (code.isEmpty()) {
                        code = value;
                    }
                    Class<?> paraClazz = methods[j].getParameterTypes()[0];
                    Class<?> retType = methods[j].getReturnType();
                    ServiceEntity entity = new ServiceEntity();
                    entity.setCode(code);
                    entity.setValue(value);
                    entity.setParaType(paraClazz);
                    entity.setRetType(retType);
                    entity.setParameterType(methods[j].getGenericParameterTypes()[0]);
                    entity.setReturnType(methods[j].getGenericReturnType());
                    entity.setMethod(methods[j]);
                    entity.setBean(obean);
                    ServiceEntity existEntity = _serviceEntityMap.get(value);
                    if (existEntity != null) {
                        throw new Exception("[" + entity.getBean() + "]\u4ea4\u6613\u5b9a\u4e49\u4e0e[" + existEntity.getBean() + "]\u91cd\u590d");
                    }
                    _serviceEntityMap.put(value, entity);
                }
            }
            logger.info("\u52a0\u8f7d\u901a\u8baf\u914d\u7f6e[{}]", (Object)CONFIG_MODULE_PATH);
            PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
            Resource[] reses = pmrpr.getResources(CONFIG_MODULE_PATH);
            Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
            String threadName = Thread.currentThread().getName();
            for (Resource res : reses) {
                boolean ret;
                String serviceName = AppStartAssist.fetchService(res.getURL().toString());
                Thread.currentThread().setName(serviceName);
                logger.info("\u52a0\u8f7d\u670d\u52a1\u540d[{}]\u914d\u7f6e", (Object)serviceName);
                BspAppContext xc = new BspAppContext(new String[]{res.getURL().toString()}, false, BspAutoConfiguration.applicationContext);
                xc.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)BspAutoConfiguration.getCustomEditorConfigurer());
                _contextRegistry.addAppContext(serviceName, xc);
                xc.refresh();
                IComm comm = AppStartAssist.loadComm(xc, res, serviceName);
                if (comm == null) continue;
                AbstractOutAdapter outAdapter = AppStartAssist.loadOutAdapter(xc, res, serviceName);
                if (outAdapter != null) {
                    ((AbstractCommOut)comm).setOutAdapter(outAdapter);
                    comm.setMsgConfig(outAdapter.getMsgConfig());
                    outCommMap.put(serviceName, comm);
                }
                if (!(ret = AppStartAssist.loadCommInProcess(xc, serviceName)) || !(ret = AppStartAssist.loadDataProcess(xc, serviceName))) continue;
                AppStartAssist.loadBspFilter(xc, serviceName);
            }
            Thread.currentThread().setName(threadName);
            logger.info("\u52a0\u8f7d\u901a\u8baf\u914d\u7f6e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u901a\u8baf\u914d\u7f6e\u5931\u8d25:", (Throwable)e);
            throw e;
        }
    }

    public static IComm loadComm(BspAppContext xc, Resource res, String serviceName) {
        String[] commName = xc.getBeanNamesForType(IComm.class);
        if (commName.length == 0) {
            logger.error("\u901a\u8baf\u7c7b\u578b\u672a\u914d\u7f6e");
            logger.warn("[{}]\u914d\u7f6e\u5ffd\u7565", (Object)res);
            xc.close();
            return null;
        }
        if (commName.length > 1) {
            logger.error("\u901a\u8baf\u914d\u7f6e\u591a\u4e2a");
            logger.warn("[{}]\u914d\u7f6e\u5ffd\u7565", (Object)res);
            xc.close();
            return null;
        }
        IComm comm = (IComm)xc.getBean(commName[0]);
        String[] inAdaptersName = xc.getBeanNamesForType(AbstractInAdapter.class);
        for (int i = 0; i < inAdaptersName.length; ++i) {
            AbstractInAdapter inAdapter = (AbstractInAdapter)xc.getBean(inAdaptersName[i]);
            inAdapter.setComm(comm);
            inAdapter.getMsgConfig().setServiceName(serviceName);
        }
        return comm;
    }

    public static AbstractOutAdapter loadOutAdapter(BspAppContext xc, Resource res, String serviceName) {
        String[] outAdapterName = xc.getBeanNamesForType(AbstractOutAdapter.class);
        if (outAdapterName.length > 1) {
            logger.warn("{},\u4e0d\u652f\u6301\u914d\u7f6e\u591a\u4e2a\u63a5\u51fa\u9002\u914d\u5668,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            xc.close();
            return null;
        }
        if (outAdapterName.length == 1) {
            AbstractOutAdapter outAdapter = (AbstractOutAdapter)xc.getBean(outAdapterName[0]);
            outAdapter.getMsgConfig().setServiceName(serviceName);
            return outAdapter;
        }
        return null;
    }

    public static boolean loadCommInProcess(BspAppContext xc, String serviceName) throws Exception {
        String[] serviceUrls = xc.getBeanNamesForType(IServiceUrl.class);
        if (serviceUrls.length > 1) {
            logger.warn("{},\u91cd\u590d\u914d\u7f6e\u63a5\u5165\u6269\u5c55\u670d\u52a1\u5b9e\u73b0\u3010IServiceUrl\u3011,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            xc.close();
            return false;
        }
        if (serviceUrls.length == 1) {
            MsgConfig msgConfig = AppStartAssist.findMsgConfig(xc, serviceName);
            IServiceUrl serviceUrl = (IServiceUrl)xc.getBean(serviceUrls[0]);
            msgConfig.setServiceUrl(serviceUrl);
        }
        return true;
    }

    public static boolean loadDataProcess(BspAppContext xc, String serviceName) throws Exception {
        String[] dataProcess = xc.getBeanNamesForType(AbstractDataProcess.class);
        if (dataProcess.length > 1) {
            logger.warn("{},\u91cd\u590d\u914d\u7f6e\u63a5\u5165\u6269\u5c55\u670d\u52a1\u5b9e\u73b0\u3010IDataProcess\u3011,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            xc.close();
            return false;
        }
        if (dataProcess.length == 1) {
            MsgConfig msgConfig = AppStartAssist.findMsgConfig(xc, serviceName);
            AbstractDataProcess dataProcessIns = (AbstractDataProcess)xc.getBean(dataProcess[0]);
            msgConfig.setDataProcess(dataProcessIns);
            dataProcessIns.setMsgConfig(msgConfig);
        }
        return true;
    }

    public static boolean loadBspFilter(BspAppContext xc, String serviceName) throws Exception {
        String[] filters = xc.getBeanNamesForType(BspFilter.class);
        if (filters.length > 0) {
            MsgConfig msgConfig = AppStartAssist.findMsgConfig(xc, serviceName);
            for (int i = 0; i < filters.length; ++i) {
                BspFilter filter = (BspFilter)xc.getBean(filters[i]);
                if ("PRE".equals(filter.filterType())) {
                    msgConfig.getPreFilter().add(filter);
                    continue;
                }
                if ("POST".equals(filter.filterType())) {
                    msgConfig.getPostFilter().add(filter);
                    continue;
                }
                if ("BOTH".equals(filter.filterType())) {
                    filter.setFilterType("PRE");
                    msgConfig.getPreFilter().add(filter);
                    filter = filter.clone();
                    filter.setFilterType("POST");
                    msgConfig.getPostFilter().add(filter);
                    continue;
                }
                logger.warn("\u8fc7\u6ee4\u5668\u7c7b\u578b[" + filter.filterType() + "]\u4e0d\u652f\u6301");
            }
        }
        return true;
    }

    public static MsgConfig findMsgConfig(BspAppContext xc, String serviceName) throws Exception {
        String[] msgConfigs = xc.getBeanNamesForType(MsgConfig.class);
        if (msgConfigs.length != 1) {
            logger.warn("{},\u62a5\u6587\u914d\u7f6e\u3010MsgConfig\u3011\u4e0d\u6b63\u786e,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            throw new Exception(serviceName + "\u62a5\u6587\u914d\u7f6e\u3010MsgConfig\u3011\u4e0d\u6b63\u786e,\u670d\u52a1\u4e0d\u542f\u52a8");
        }
        return (MsgConfig)xc.getBean(msgConfigs[0]);
    }

    public static ServiceConfig findServiceConfig(BspAppContext xc, String serviceName) throws Exception {
        String[] serviceConfigs = xc.getBeanNamesForType(ServiceConfig.class);
        if (serviceConfigs.length != 1) {
            logger.warn("{},\u670d\u52a1\u914d\u7f6e\u3010ServiceConfig\u3011\u4e0d\u6b63\u786e,\u670d\u52a1\u4e0d\u542f\u52a8", (Object)serviceName);
            throw new Exception(serviceName + "\u670d\u52a1\u914d\u7f6e\u3010ServiceConfig\u3011\u4e0d\u6b63\u786e,\u670d\u52a1\u4e0d\u542f\u52a8");
        }
        return (ServiceConfig)xc.getBean(serviceConfigs[0]);
    }

    public static String fetchService(String path) {
        int index = path.indexOf("config/comm");
        int startIndex = path.indexOf("/", index + 11);
        int endIndex = path.indexOf("/module.mrd", startIndex);
        return path.substring(startIndex + 1, endIndex);
    }

    public static void stopModule() throws Exception {
        Collection<BspAppContext> contextSet = _contextRegistry.getContextMap().values();
        for (BspAppContext bspAppContext : contextSet) {
            bspAppContext.close();
        }
    }

    public static Map<String, ServiceEntity> get_serviceEntityMap() {
        return _serviceEntityMap;
    }

    public static void set_serviceEntityMap(Map<String, ServiceEntity> _serviceEntityMap) {
        AppStartAssist._serviceEntityMap = _serviceEntityMap;
    }
}

