/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.dataformat.LogPhase;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import cn.com.yusys.yusp.bsp.workflow.comm.in.impl.http.BufferedHttpServerConnection;
import cn.com.yusys.yusp.bsp.workflow.component.ComponentException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.slf4j.MDC;

public class HttpCommIn
extends AbstractCommIn
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String COMM_ATTRIBUTE_RECEIVE_HEAD = "recvHead";
    protected static final String COMM_ATTRIBUTE_SEND_HEAD = "sendHead";
    protected HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
    protected volatile HttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
    private static final String BSPBIS = "_BSPBIS";
    protected String unitName = "HTTP\u901a\u8baf\u63a5\u5165";
    private String contentType;
    private String sendHead;
    private String chunkedFlag;
    private String userAgent;
    private String recvHead;

    @Override
    public void processSend(Map<String, Object> context, byte[] sendData, AbstractRequest request) throws Exception {
        HttpResponse httpResponse;
        HttpContext httpContext = (HttpContext)context.remove("T_HTTP_CONTEXT");
        if (httpContext == null) {
            throw new ComponentException("HttpContext\u5bf9\u8c61\u5728context\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u5148\u4f7f\u7528Http\u901a\u8baf\u7ec4\u4ef6\u63a5\u6536");
        }
        String contentType = HttpCommIn.getInExpressStringValue(this.contentType, context);
        HttpParams httpParams = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpServerProcessor();
        DefaultConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
        DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
        if (!conn.isOpen()) {
            Socket socket = null;
            if (request instanceof StreamRequest) {
                Object dw = request.getDatasourceWrapper();
                if (dw instanceof SocketWrapper) {
                    socket = ((SocketWrapper)dw).getSocket();
                } else if (dw instanceof Socket) {
                    socket = (Socket)dw;
                }
                conn.bind(socket, httpParams);
            }
        }
        if ((httpResponse = (HttpResponse)httpContext.getAttribute("http.response")) == null) {
            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, httpContext);
            httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
        }
        Map<Object, Object> headers = new HashMap();
        Object sendHead = this.getInExpressObjectValue(this.sendHead, context);
        if (sendHead != null) {
            if (sendHead instanceof Map) {
                headers = (Map)sendHead;
            } else {
                this.logger.debug("{} @ \u53d1\u9001\u62a5\u6587\u5934\u4e0d\u4e3aMap:{}", new Object[]{this.getUnitName(), sendHead});
                headers = StringTools.string2Map(StringTools.getString(sendHead));
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            httpResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        byte[] bsend = sendData;
        if (bsend != null) {
            int dataLen = bsend.length;
            InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bsend), (long)dataLen);
            if (this.logger.isInfoEnabled()) {
                if (this.printHexLog(LogPhase.SEND)) {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bsend.length, StringTools.toHexTable(bsend, this.getMsgConfig().getMsgEncode())});
                } else {
                    this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bsend.length, StringTools.printStr(bsend, this.getMsgConfig().getMsgEncode())});
                }
            }
            httpResponse.setEntity((HttpEntity)entity);
            String flag = HttpCommIn.getInExpressStringValue(this.chunkedFlag, context);
            if (!StringTools.isEmpty(flag) && "true".equals(flag)) {
                entity.setChunked(true);
            }
            entity.setContentType(contentType);
            httpProc.process(httpResponse, httpContext);
        }
        conn.sendResponseHeader(httpResponse);
        conn.sendResponseEntity(httpResponse);
        conn.flush();
        if (!connStrategy.keepAlive(httpResponse, httpContext)) {
            conn.close();
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        BufferedHttpServerConnection conn;
        String contentType = HttpCommIn.getInExpressStringValue(this.contentType, context);
        HttpParams httpParams = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpServerProcessor();
        BasicHttpContext httpContext = new BasicHttpContext(null);
        Object datasourceWrapper = request.getDatasourceWrapper();
        SocketWrapper socketWrapper = null;
        if (datasourceWrapper instanceof SocketWrapper) {
            socketWrapper = (SocketWrapper)datasourceWrapper;
            httpParams.setParameter(BSPBIS, (Object)socketWrapper.getBis());
        }
        if (!(conn = new BufferedHttpServerConnection()).isOpen()) {
            Socket socket = null;
            if (request instanceof StreamRequest) {
                Object dw = request.getDatasourceWrapper();
                if (dw instanceof SocketWrapper) {
                    socket = ((SocketWrapper)dw).getSocket();
                } else if (dw instanceof Socket) {
                    socket = (Socket)dw;
                }
                if (httpParams.getParameter("http.socket.timeout") == null) {
                    httpParams.setIntParameter("http.socket.timeout", socket.getSoTimeout());
                }
                conn.bind(socket, httpParams);
            }
        }
        httpContext.setAttribute("http.connection", (Object)conn);
        HttpResponse httpResponse = null;
        try {
            int index;
            String recvHeadStr;
            HttpRequest httpRequest = conn.receiveRequestHeader();
            ProtocolVersion ver = httpRequest.getRequestLine().getProtocolVersion();
            if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                if (((HttpEntityEnclosingRequest)httpRequest).expectContinue()) {
                    httpResponse = this.responseFactory.newHttpResponse(ver, 100, (HttpContext)httpContext);
                    httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
                    if (httpResponse.getStatusLine().getStatusCode() < 200) {
                        conn.sendResponseHeader(httpResponse);
                        conn.flush();
                        httpResponse = null;
                        conn.receiveRequestEntity((HttpEntityEnclosingRequest)httpRequest);
                    }
                } else {
                    conn.receiveRequestEntity((HttpEntityEnclosingRequest)httpRequest);
                }
            }
            if (httpResponse == null) {
                httpResponse = this.responseFactory.newHttpResponse(ver, 200, (HttpContext)httpContext);
                httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
            }
            httpContext.setAttribute("http.request", (Object)httpRequest);
            httpContext.setAttribute("http.response", (Object)httpResponse);
            httpProc.process(httpRequest, (HttpContext)httpContext);
            context.put("T_HTTP_CONTEXT", httpContext);
            Map<String, String> headers = this.parserHeader((HttpMessage)httpRequest);
            if ("1".equals(headers.get("X-B3-Sampled"))) {
                String traceId = headers.get("X-B3-TraceId");
                if (!StringTools.isEmpty(traceId)) {
                    MDC.put((String)"X-B3-TraceId", (String)traceId);
                }
                Session session = (Session)context.get("T_SESSION");
                session.setBsn(traceId);
                context.put("G_BSN", traceId);
            }
            if (StringTools.isEmpty(recvHeadStr = this.recvHead)) {
                recvHeadStr = COMM_ATTRIBUTE_RECEIVE_HEAD;
            } else if (headers.containsKey("uri")) {
                OgnlTools.setValue("recvHead.uri", headers.get("uri"), context);
            }
            OgnlTools.setValue(recvHeadStr, headers, context);
            this.logHeader(httpRequest);
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                byte[] data = EntityUtils.toByteArray((HttpEntity)((HttpEntityEnclosingRequest)httpRequest).getEntity());
                context.put("recvVar", data);
                if (this.logger.isInfoEnabled()) {
                    if (this.printHexLog(LogPhase.RECV)) {
                        this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), data.length, StringTools.toHexTable(data, this.getMsgConfig().getMsgEncode())});
                    } else {
                        this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), data.length, StringTools.printStr(data, this.getMsgConfig().getMsgEncode())});
                    }
                }
                HttpEntity entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
                EntityUtils.consume((HttpEntity)entity);
                return data;
            }
            RequestLine requestLine = httpRequest.getRequestLine();
            String uri = requestLine.getUri();
            context.put("recvVar", uri);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ \u8bf7\u6c42\u7684URL:{}", new Object[]{this.getUnitName(), requestLine});
            }
            if ((index = uri.indexOf("?")) != -1) {
                String subStr = uri.substring(index + 1);
                String[] params = StringUtils.split((String)subStr, (String)"&");
                HashMap<String, String> para = new HashMap<String, String>();
                for (String str : params) {
                    String[] temp = StringUtils.split((String)str, (String)"=");
                    if (temp.length == 1) {
                        para.put(temp[0], "");
                        continue;
                    }
                    if (temp.length != 2) continue;
                    para.put(temp[0], temp[1]);
                }
                headers.putAll(para);
                this.logParams(para, COMM_ATTRIBUTE_SEND_HEAD);
            }
            return uri.getBytes();
        }
        catch (HttpException e) {
            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, (HttpContext)httpContext);
            httpResponse.setParams((HttpParams)new DefaultedHttpParams(httpResponse.getParams(), httpParams));
            this.handleException(e, httpResponse);
            httpProc.process(httpResponse, (HttpContext)httpContext);
            conn.sendResponseHeader(httpResponse);
            conn.sendResponseEntity(httpResponse);
            conn.flush();
            throw e;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSendHead() {
        return this.sendHead;
    }

    public void setSendHead(String sendHead) {
        this.sendHead = sendHead;
    }

    public String getChunkedFlag() {
        return this.chunkedFlag;
    }

    public void setChunkedFlag(String chunkedFlag) {
        this.chunkedFlag = chunkedFlag;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getRecvHead() {
        return this.recvHead;
    }

    public void setRecvHead(String recvHead) {
        this.recvHead = recvHead;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    protected Map<String, String> parserHeader(HttpMessage httpMessage) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpMessage;
            map.put("method", req.getRequestLine().getMethod());
            map.put("uri", req.getRequestLine().getUri());
            map.put("protocol", req.getRequestLine().getProtocolVersion().getProtocol());
        }
        for (Header h : httpMessage.getAllHeaders()) {
            map.put(h.getName(), h.getValue());
        }
        return map;
    }

    private void logParams(Map<String, String> map, String headkey) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append(headkey + "." + key);
                sb.append("=");
                sb.append(value);
                sb.append("\n");
            }
            this.logger.debug(sb.toString());
        }
    }

    protected void logHeader(HttpRequest request) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ \u8bf7\u6c42HTTP\u5934:\n{}", (Object)this.getUnitName(), (Object)request);
        }
    }

    protected void logHeader(HttpResponse response) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ \u8fd4\u56deHTTP\u5934:\n{}", (Object)this.getUnitName(), (Object)response);
        }
    }

    protected Header[] buildHeader(Map<String, String> headers) {
        Header[] heads = new Header[headers.size()];
        int i = 0;
        for (String key : headers.keySet()) {
            BasicHeader head = new BasicHeader(key, headers.get(key));
            heads[i] = head;
            ++i;
        }
        return heads;
    }

    protected HttpParams getHttpParams(String contentType, Map<String, Object> context) throws Exception {
        NameValuePair param;
        BasicHeader header;
        HeaderElement[] values;
        String charset = "UTF-8";
        if (contentType != null && (values = (header = new BasicHeader("Content-Type", contentType)).getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)charset);
        String userAgent = HttpCommIn.getInExpressStringValue(this.userAgent, context);
        if (userAgent == null || userAgent.length() == 0) {
            userAgent = "BSP-HttpClient/1.1";
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        params.setParameter("http.origin-server", (Object)"BSP-HttpServer/1.1");
        params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true);
        params.setIntParameter("http.connection.timeout", 10000);
        return params;
    }

    protected HttpProcessor getHttpClientProcessor() {
        ImmutableHttpProcessor httpProc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue(), new RequestDate()});
        return httpProc;
    }

    protected HttpProcessor getHttpServerProcessor() {
        ImmutableHttpProcessor httpProc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseContent(), new ResponseConnControl(), new ResponseServer(), new ResponseDate()});
        return httpProc;
    }

    protected void handleException(HttpException ex, HttpResponse response) throws UnsupportedEncodingException {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        byte[] msg = ByteTools.getBytes(StringTools.printExceptionStackTrace(ex), "UTF-8");
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=UTF-8");
        response.setEntity((HttpEntity)entity);
    }
}

