/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.LogPhase;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.config.MsgConfig;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComm
implements IComm {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private MsgConfig msgConfig;

    protected void sendMessageData(OutputStream output, byte[] bSend) throws Exception {
        if (bSend == null || bSend.length == 0) {
            throw new Exception(this.getUnitName() + " @ \u53d1\u9001\u53d8\u91cf\u4e3a\u7a7a");
        }
        output.write(bSend);
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.SEND)) {
                this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bSend.length, StringTools.toHexTable(bSend, this.getMsgConfig().getMsgEncode())});
            } else {
                this.logger.info("{} @ \u53d1\u9001\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bSend.length, StringTools.printStr(bSend, this.getMsgConfig().getMsgEncode())});
            }
        }
    }

    protected void recvMessageData(DataInputStream dis, byte[] bRecv) throws Exception {
        dis.readFully(bRecv);
        if (this.logger.isInfoEnabled()) {
            if (this.printHexLog(LogPhase.RECV)) {
                this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bRecv.length, StringTools.toHexTable(bRecv, this.getMsgConfig().getMsgEncode())});
            } else {
                this.logger.info("{} @ \u63a5\u6536\u6570\u636e[{}]:\n{}", new Object[]{this.getUnitName(), bRecv.length, StringTools.printStr(bRecv, this.getMsgConfig().getMsgEncode())});
            }
        }
    }

    public static String getInExpressStringValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return null;
        }
        try {
            return (String)value;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("\u8868\u8fbe\u5f0f\u7684\u503c\u7684\u7c7b\u578b\u4e0d\u4e3aString");
        }
    }

    public static byte[] getInExpressByteValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return null;
        }
        try {
            return (byte[])value;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("\u8868\u8fbe\u5f0f\u7684\u503c\u7684\u7c7b\u578b\u4e0d\u4e3abyte[]");
        }
    }

    public static boolean getInExpressBooleanValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return false;
        }
        try {
            return (Boolean)value;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("\u8868\u8fbe\u5f0f\u7684\u503c\u7684\u7c7b\u578b\u4e0d\u4e3aboolean");
        }
    }

    protected Object getInExpressObjectValue(String expr, Map<String, Object> context) throws Exception {
        return ExpressTools.getValue(expr, context);
    }

    protected boolean printHexLog(LogPhase phase) {
        String msgType = this.msgConfig.getInputMsgType();
        if (phase == LogPhase.RECV) {
            if (StringTools.isEmpty(msgType) || "NONE".equals(msgType)) {
                msgType = this.msgConfig.getReqMsgType();
            }
        } else if (phase == LogPhase.SEND) {
            msgType = this.msgConfig.getRespMsgType();
        }
        return !DataFormatRegistry._plainDataformat.contains(msgType);
    }

    protected abstract String getUnitName();

    @Override
    public MsgConfig getMsgConfig() {
        return this.msgConfig;
    }

    @Override
    public void setMsgConfig(MsgConfig msgConfig) {
        this.msgConfig = msgConfig;
    }
}

