/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.resources.ResourceCreator;
import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.resources.core.ResourceHolder;
import cn.com.yusys.yusp.bsp.resources.creator.impl.MappingCreator;
import cn.com.yusys.yusp.bsp.resources.creator.impl.NTMCreator;
import cn.com.yusys.yusp.bsp.workflow.CommRegistry;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import cn.com.yusys.yusp.bsp.workflow.mapping.MappingRegistry;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ResourcePortal {
    private static ResourcePortal instance = new ResourcePortal();
    private SpringContextRegistry _springContextRegistry = new SpringContextRegistry();
    private Map<String, IComm> outCommMap = new HashMap<String, IComm>();
    private CommRegistry _commRegistry = new CommRegistry();
    private MappingRegistry _mappingRegistry = new MappingRegistry();
    private ResourceHolder resourceHolder = new ResourceHolder();

    private ResourcePortal() {
        ResourceCreator.addCreator(new MappingCreator());
        ResourceCreator.addCreator(new NTMCreator());
    }

    public static ResourcePortal getInstance() {
        return instance;
    }

    public ResourceHolder getResourceHolder() {
        return this.resourceHolder;
    }

    public SpringContextRegistry getSpringContextRegistry() {
        return this._springContextRegistry;
    }

    public static String getCurDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = Calendar.getInstance().getTime();
        return format.format(date);
    }

    public Object getResource(String fileType, String filePath) throws ResourceException {
        ResourceHolder rh = ResourcePortal.getInstance().getResourceHolder();
        if (rh == null) {
            throw new ResourceException("\u8d44\u6e90\u7f13\u5b58\u4e0d\u5b58\u5728");
        }
        return rh.getResource(fileType, filePath);
    }

    public CommRegistry getCommRegistry() {
        return this._commRegistry;
    }

    public MappingRegistry getMappingRegistry() {
        return this._mappingRegistry;
    }

    public void setMappingRegistry(MappingRegistry mappingRegistry) {
        this._mappingRegistry = mappingRegistry;
    }

    public Map<String, IComm> getOutCommMap() {
        return this.outCommMap;
    }

    public void setOutCommMap(Map<String, IComm> outCommMap) {
        this.outCommMap = outCommMap;
    }
}

