/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.impl;

import cn.com.yusys.yusp.bsp.method.util.DesEncrypAndDecrypUtil;
import cn.com.yusys.yusp.bsp.toolkit.common.Base64Tools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.EbcdTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMethodTool {
    private static final String CASE_TYPE = "caseType";
    private static final String CCSID = "ccsid";
    private static final char CHAR_A = 'a';
    private static final char CHAR_AUP = 'A';
    private static final char CHAR_QUOT = '&';
    private static final char CHAR_Z = 'z';
    private static final char CHAR_ZUP = 'Z';
    private static final byte[] destChar = new byte[]{60, 62, 34, 39, 38, 10};
    private static final String DIR_LEFT = "LEFT";
    private static final String DIR_RIGHT = "RIGHT";
    private static final String DIR_BOTH = "BOTH";
    private static final String DIRECTION = "direction";
    private static final String ENCODE = "encoding";
    private static final String END_PLACE = "endPlace";
    private static final byte[][] esc = new byte[][]{"&lt;".getBytes(), "&gt;".getBytes(), "&quot;".getBytes(), "&apos;".getBytes(), "&amp;".getBytes(), "&#xA;".getBytes()};
    private static final Logger logger = LoggerFactory.getLogger(StringMethodTool.class);
    private static final String LOW_CASE = "lowerCase";
    private static final int NUM_CCSID = 935;
    private static final String REPLACE_STR = "replaceStr";
    private static final String SIGN_CHAR = "signChar";
    private static final String SIGN_STR = "signString";
    private static final String SOUR_ENCOD = "sourceEncoding";
    private static final String SOURCE_STR = "sourceStr";
    private static final String SPLIT_STR = "splitStr";
    private static final String START_PLACE = "startPlace";
    private static final String TAR_ENCOD = "targetEncoding";
    private static final String TARGET_LEN = "targetLength";
    private static final String UP_CASE = "upperCase";

    public static byte[] ASCII2EBCD(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        return EbcdTools.asciiToEbcd(srcData);
    }

    public static String ASCIIToHex2(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        return StringTools.byte2String(srcData);
    }

    public static byte[] base64Decoder(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        return Base64Tools.decode(srcData);
    }

    public static byte[] base64Encoder(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        return Base64Tools.encodeToByte(srcData);
    }

    public static byte[] byte2Byte(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        byte[] ret;
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SOUR_ENCOD)))) {
            logger.warn("byte\u7f16\u7801\u8f6c\u6362\u51fd\u6570 @ \u539f\u7f16\u7801\u65b9\u5f0f\u672a\u914d\u7f6e,\u4e0d\u505a\u8f6c\u6362");
            return srcData;
        }
        if (StringTools.isEmpty(StringTools.getString(paras.get(TAR_ENCOD)))) {
            logger.warn("byte\u7f16\u7801\u8f6c\u6362\u51fd\u6570 @ \u76ee\u6807\u7f16\u7801\u65b9\u5f0f\u672a\u914d\u7f6e,\u4e0d\u505a\u8f6c\u6362");
            return srcData;
        }
        String sourEncoding = StringTools.getString(paras.get(SOUR_ENCOD));
        String tarEncoding = StringTools.getString(paras.get(TAR_ENCOD));
        try {
            String tmp = new String(srcData, sourEncoding);
            ret = tmp.getBytes(tarEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("\u6e90\u7f16\u7801\u7c7b\u578b\uff1a" + sourEncoding + "\uff0c\u76ee\u6807\u7f16\u7801\u7c7b\u578b\uff1a" + tarEncoding + ",\u4e0d\u652f\u6301\u6e90\u7f16\u7801\u6216\u76ee\u6807\u7f16\u7801\u65b9\u5f0f!", e);
        }
        return ret;
    }

    public static byte[] convertUpperLowerCase(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String caseType = StringTools.getString(paras.get(CASE_TYPE));
        if (caseType == null || caseType.length() == 0) {
            logger.warn("\u5927\u5c0f\u5199\u8f6c\u6362\u51fd\u6570 @ \u8f6c\u6362\u7c7b\u578b\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u8f6c\u6362");
            return srcData;
        }
        if (caseType.equals(UP_CASE)) {
            for (int i = 0; i < srcData.length; ++i) {
                if (srcData[i] < 97 || srcData[i] > 122) continue;
                srcData[i] = (byte)(srcData[i] - 32);
            }
            return srcData;
        }
        if (caseType.equals(LOW_CASE)) {
            for (int i = 0; i < srcData.length; ++i) {
                if (srcData[i] < 65 || srcData[i] > 90) continue;
                srcData[i] = (byte)(srcData[i] + 32);
            }
            return srcData;
        }
        logger.warn("\u5927\u5c0f\u5199\u8f6c\u6362\u51fd\u6570 @ \u8f6c\u6362\u7c7b\u578b\u914d\u7f6e\u4e0d\u5408\u6cd5,\u4e0d\u505a\u8f6c\u6362:{}", (Object)caseType);
        return srcData;
    }

    public static int countChar(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SIGN_CHAR)))) {
            logger.warn("\u7edf\u8ba1\u5b57\u7b26\u4e2a\u6570\u51fd\u6570 @ \u6307\u5b9a\u5b57\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u7edf\u8ba1");
        }
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        byte signChar = sign[0];
        int count = 0;
        for (int i = 0; i < srcData.length; ++i) {
            if (srcData[i] != signChar) continue;
            ++count;
        }
        return count;
    }

    public static byte[] cutString(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SIGN_CHAR)))) {
            logger.warn("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u6307\u5b9a\u5b57\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u622a\u53d6");
            return srcData;
        }
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        byte signChar = sign[0];
        String direction = StringTools.isEmpty(StringTools.getString(paras.get(DIRECTION))) ? DIR_RIGHT : StringTools.getString(paras.get(DIRECTION));
        byte[] bt = null;
        if (direction.equals(DIR_LEFT)) {
            for (int i = 0; i < srcData.length; ++i) {
                if (srcData[i] != signChar) continue;
                bt = new byte[i];
                System.arraycopy(srcData, 0, bt, 0, i);
                break;
            }
        } else if (direction.equals(DIR_RIGHT)) {
            for (int i = srcData.length - 1; i >= 0; --i) {
                if (srcData[i] != signChar) continue;
                bt = new byte[srcData.length - i - 1];
                System.arraycopy(srcData, i + 1, bt, 0, srcData.length - i - 1);
                break;
            }
        } else {
            logger.warn("\u5b57\u7b26\u4e32\u622a\u53d6\u51fd\u6570 @ \u4e0d\u652f\u6301\u8be5\u65b9\u5411,\u4e0d\u505a\u622a\u53d6");
            return srcData;
        }
        if (bt == null) {
            bt = srcData;
        }
        return bt;
    }

    public static byte[] deleteWord(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SIGN_CHAR)))) {
            logger.warn("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u5220\u9664");
            return srcData;
        }
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        byte signChar = sign[0];
        String direction = StringTools.isEmpty(StringTools.getString(paras.get(DIRECTION))) ? DIR_RIGHT : StringTools.getString(paras.get(DIRECTION));
        if (srcData.length == 0) {
            return srcData;
        }
        int targetLength = StringTools.isEmpty(StringTools.getString(paras.get(TARGET_LEN))) ? 0 : Integer.parseInt(StringTools.getString(paras.get(TARGET_LEN)));
        if (targetLength < 0) {
            targetLength = 0;
        }
        if (direction.equals(DIR_LEFT)) {
            int i = 0;
            int j = 0;
            while (srcData[i] == signChar && srcData.length - i > targetLength) {
                if (++i == srcData.length) {
                    return new byte[0];
                }
                ++j;
            }
            byte[] bt = new byte[srcData.length - j];
            System.arraycopy(srcData, j, bt, 0, srcData.length - j);
            return bt;
        }
        if (direction.equals(DIR_RIGHT)) {
            int i = srcData.length - 1;
            while (srcData[i] == signChar && i != targetLength - 1) {
                if (--i >= 0) continue;
                return new byte[0];
            }
            byte[] bt = new byte[i + 1];
            System.arraycopy(srcData, 0, bt, 0, i + 1);
            return bt;
        }
        if (direction.equals(DIR_BOTH)) {
            int i = 0;
            while (srcData[i] == signChar) {
                if (++i < srcData.length) continue;
                return new byte[0];
            }
            byte[] bt = new byte[srcData.length - i];
            System.arraycopy(srcData, i, bt, 0, srcData.length - i);
            int j = bt.length;
            while (bt[j - 1] == signChar) {
                if (--j >= 0) continue;
                return new byte[0];
            }
            byte[] btt = new byte[bt.length - (bt.length - j)];
            System.arraycopy(bt, 0, btt, 0, bt.length - (bt.length - j));
            return btt;
        }
        logger.warn("\u5220\u9664\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u8be5\u5220\u9664\u65b9\u5411,\u4e0d\u505a\u5220\u9664");
        return srcData;
    }

    public static byte[] EBCD2ASCII(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        return EbcdTools.ebcdToAscii(srcData);
    }

    public static byte[] fillWord(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SIGN_CHAR)))) {
            logger.warn("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        byte signChar = sign[0];
        if (StringTools.isEmpty(StringTools.getString(paras.get(TARGET_LEN)))) {
            logger.warn("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u76ee\u6807\u957f\u5ea6\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        int targetLength = Integer.parseInt(StringTools.getString(paras.get(TARGET_LEN)));
        String direction = StringTools.isEmpty(StringTools.getString(paras.get(DIRECTION))) ? DIR_RIGHT : StringTools.getString(paras.get(DIRECTION));
        int j = targetLength - srcData.length;
        if (j <= 0) {
            return srcData;
        }
        byte[] b = new byte[j];
        byte[] bb = new byte[srcData.length + j];
        for (int i = 0; i < j; ++i) {
            b[i] = signChar;
        }
        if (direction.equals(DIR_LEFT)) {
            System.arraycopy(b, 0, bb, 0, j);
            System.arraycopy(srcData, 0, bb, j, srcData.length);
            return bb;
        }
        if (direction.equals(DIR_RIGHT)) {
            System.arraycopy(srcData, 0, bb, 0, srcData.length);
            System.arraycopy(b, 0, bb, srcData.length, j);
            return bb;
        }
        logger.warn("\u586b\u5145\u5b57\u7b26\u51fd\u6570 @ \u4e0d\u652f\u6301\u8be5\u586b\u5145\u65b9\u5411,\u4e0d\u505a\u586b\u5145");
        return srcData;
    }

    public static byte[] fillWords(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        if (StringTools.isEmpty(StringTools.getString(paras.get(SIGN_CHAR)))) {
            logger.warn("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u6807\u8bc6\u7b26\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u586b\u5145");
            return srcData;
        }
        byte[] sign = StringTools.escString2Byte(StringTools.getString(paras.get(SIGN_CHAR)));
        String direction = StringTools.isEmpty(StringTools.getString(paras.get(DIRECTION))) ? DIR_RIGHT : StringTools.getString(paras.get(DIRECTION));
        if (sign == null || sign.length == 0) {
            logger.warn("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u586b\u5145\u5185\u5bb9\u4e3a\u7a7a");
            return srcData;
        }
        int j = sign.length;
        byte[] bb = new byte[srcData.length + j];
        if (direction.equals(DIR_LEFT)) {
            System.arraycopy(sign, 0, bb, 0, j);
            System.arraycopy(srcData, 0, bb, j, srcData.length);
            return bb;
        }
        if (direction.equals(DIR_RIGHT)) {
            System.arraycopy(srcData, 0, bb, 0, srcData.length);
            System.arraycopy(sign, 0, bb, srcData.length, j);
            return bb;
        }
        logger.warn("\u62fc\u63a5\u5b57\u7b26\u4e32\u51fd\u6570 @ \u4e0d\u652f\u6301\u8be5\u586b\u5145\u65b9\u5411,\u4e0d\u505a\u586b\u5145");
        return srcData;
    }

    public static byte[] Hex2ToASCII(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        byte[] srcData = ByteTools.getBytes(_srcData);
        return StringTools.string2Byte(new String(srcData));
    }

    public static void main(String[] args) {
    }

    public static String replace(String srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        String reStr = StringTools.getString(paras.get(REPLACE_STR));
        if (StringTools.isEmpty(reStr)) {
            logger.warn("replace\u51fd\u6570 @ \u66ff\u6362\u5b57\u7b26\u4e32\u672a\u914d\u7f6e,\u4e0d\u505a\u8f6c\u6362");
            return srcData;
        }
        String soStr = StringTools.getString(paras.get(SOURCE_STR));
        if (StringTools.isEmpty(soStr)) {
            logger.warn("replace\u51fd\u6570 @ \u6e90\u5b57\u7b26\u4e32\u672a\u914d\u7f6e,\u4e0d\u505a\u8f6c\u6362");
            return srcData;
        }
        return srcData.replaceAll(soStr, reStr);
    }

    public static byte[] replaceString(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String sp = StringTools.getString(paras.get(START_PLACE));
        int start = StringTools.isEmpty(sp) ? 1 : Integer.parseInt(sp);
        String ep = StringTools.getString(paras.get(END_PLACE));
        int end = StringTools.isEmpty(ep) ? 1 : Integer.parseInt(ep);
        if (start <= 0) {
            start = 1;
        }
        int len1 = srcData.length;
        if (end <= 0 || end > len1) {
            end = len1;
        }
        if (start > len1 || start > end) {
            logger.warn("\u5b57\u7b26\u4e32\u66ff\u6362\u51fd\u6570 @ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u914d\u7f6e\u6709\u8bef,\u4e0d\u505a\u66ff\u6362");
            return srcData;
        }
        String signString = StringTools.getString(paras.get(SIGN_STR));
        if (StringTools.isEmpty(signString)) {
            logger.warn("\u5b57\u7b26\u4e32\u66ff\u6362\u51fd\u6570 @ \u66ff\u6362\u5b57\u7b26\u4e32\u4e3a\u7a7a,\u4e0d\u505a\u66ff\u6362");
            return srcData;
        }
        int len2 = signString.length();
        byte[] b = signString.getBytes();
        byte[] bb = new byte[len1 + len2 - end + start - 1];
        System.arraycopy(srcData, 0, bb, 0, start - 1);
        System.arraycopy(b, 0, bb, start - 1, len2);
        System.arraycopy(srcData, end, bb, start + len2 - 1, len1 - end);
        return bb;
    }

    public static byte[] selectSubString(Object _srcData, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String sp = StringTools.getString(paras.get(START_PLACE));
        String ep = StringTools.getString(paras.get(END_PLACE));
        if (StringTools.isEmpty(sp) || StringTools.isEmpty(ep)) {
            logger.warn("\u9009\u53d6\u5b50\u4e32\u51fd\u6570@ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u672a\u914d\u7f6e\u53c2\u6570,\u4e0d\u505a\u9009\u53d6");
            return srcData;
        }
        int start = Integer.parseInt(sp);
        int end = Integer.parseInt(ep);
        int len = srcData.length;
        if (start < 1) {
            start = 1;
        }
        if (end > len || end < 1) {
            end = len;
        }
        if (start > end || start > srcData.length) {
            logger.warn("\u9009\u53d6\u5b50\u4e32\u51fd\u6570 @ \u8d77\u59cb\u4f4d\u7f6e\u6216\u7ed3\u675f\u4f4d\u7f6e\u914d\u7f6e\u6709\u8bef,\u4e0d\u505a\u9009\u53d6");
            return srcData;
        }
        int len1 = end - start + 1;
        byte[] b = new byte[len1];
        System.arraycopy(srcData, start - 1, b, 0, len1);
        return b;
    }

    public static String[] splitString(String srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        String splitStr = StringTools.getString(paras.get(SPLIT_STR));
        if (StringTools.isEmpty(splitStr)) {
            logger.warn("split\u51fd\u6570 @ \u62c6\u5206\u5b57\u7b26\u672a\u914d\u7f6e,\u4e0d\u505a\u8f6c\u6362");
            return new String[]{srcData};
        }
        byte[] sign = StringTools.escString2Byte(splitStr);
        return srcData.split(new String(sign));
    }

    public static byte[] translateChar(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws UnsupportedEncodingException {
        byte[] srcData = ByteTools.getBytes(_srcData);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        for (int i = 0; i < srcData.length; ++i) {
            if (srcData[i] == 38) {
                int index = -1;
                for (int j = 0; j < esc.length; ++j) {
                    boolean flag = true;
                    if (i + esc[j].length <= srcData.length) {
                        for (int k = 1; k < esc[j].length; ++k) {
                            if (esc[j][k] == srcData[i + k]) continue;
                            flag = false;
                            break;
                        }
                    } else {
                        flag = false;
                    }
                    if (!flag) continue;
                    index = j;
                    break;
                }
                if (index != -1) {
                    baos.write(destChar[index]);
                    i += esc[index].length - 1;
                    continue;
                }
                baos.write(srcData[i]);
                continue;
            }
            baos.write(srcData[i]);
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    public static byte[] unicode2Chinese(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        byte[] srcData = ByteTools.getBytes(_srcData);
        String encode = StringTools.getString(paras.get(ENCODE));
        return ByteTools.unicode2Asc(srcData, encode);
    }

    public static byte[] desEncrypAndDecryp(Object _srcData, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        return DesEncrypAndDecrypUtil.des(_srcData, paras, context);
    }
}

